/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.block;

import forge.com.jsblock.BlockEntityTypes;
import forge.com.jsblock.Joban;
import forge.com.jsblock.packet.PacketServer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mtr.block.IBlock;
import mtr.data.TicketSystem;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.Score;

public class SubsidyMachine1
extends HorizontalDirectionalBlock
implements EntityBlockMapper {
    private final Map<UUID, Integer> timeouts = new HashMap<UUID, Integer>();

    public SubsidyMachine1(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return IBlock.getVoxelShapeByDirection((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)17.0, (double)3.0, (Direction)((Direction)state.m_61143_((Property)f_54117_)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext collisionContext) {
        return IBlock.getVoxelShapeByDirection((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (Direction)((Direction)state.m_61143_((Property)f_54117_)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        UUID playerUUID = player.m_20148_();
        BlockEntity entity = world.m_7702_(pos);
        TicketSystem.addObjectivesIfMissing((Level)world);
        IBlock.checkHoldingBrush((Level)world, (Player)player, () -> {
            if (entity instanceof TileEntitySubsidyMachine) {
                this.timeouts.remove(playerUUID);
                PacketServer.sendSubsidyConfigScreenS2C((ServerPlayer)player, pos, ((TileEntitySubsidyMachine)entity).getPricePerClick(), ((TileEntitySubsidyMachine)entity).getTimeout());
            }
        }, () -> {
            if (entity instanceof TileEntitySubsidyMachine) {
                Score balanceScore;
                long finalPrice;
                int subsidyPrice = ((TileEntitySubsidyMachine)entity).getPricePerClick();
                int timeoutTick = ((TileEntitySubsidyMachine)entity).getTimeout() * 20;
                if (this.timeouts.containsKey(playerUUID)) {
                    int timeoutLeft = this.timeouts.get(playerUUID) - Joban.getGameTick();
                    if (timeoutLeft <= 0) {
                        this.timeouts.remove(playerUUID);
                    } else {
                        player.m_5661_((Component)Text.translatable((String)"gui.jsblock.subsidy_timeout", (Object[])new Object[]{timeoutLeft / 20}), true);
                        return;
                    }
                }
                if ((finalPrice = (long)(balanceScore = TicketSystem.getPlayerScore((Level)world, (Player)player, (String)"mtr_balance")).m_83400_() + (long)subsidyPrice) <= Integer.MAX_VALUE) {
                    balanceScore.m_83402_(balanceScore.m_83400_() + subsidyPrice);
                    player.m_5661_((Component)Text.translatable((String)"gui.jsblock.subsidy", (Object[])new Object[]{subsidyPrice, balanceScore.m_83400_()}), true);
                    this.timeouts.put(playerUUID, Joban.getGameTick() + timeoutTick);
                } else {
                    player.m_5661_((Component)Text.translatable((String)"gui.jsblock.subsidy_maxed", (Object[])new Object[0]), true);
                }
            }
        });
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockEntityType<? extends BlockEntityMapper> getType() {
        return (BlockEntityType)BlockEntityTypes.SUBSIDY_MACHINE_TILE_ENTITY_1.get();
    }

    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntitySubsidyMachine(pos, state);
    }

    public static class TileEntitySubsidyMachine
    extends BlockEntityMapper {
        private int pricePerClick = 10;
        private int timeout = 0;
        private static final String KEY_PRICE_PER_CLICK = "price_per_click";
        private static final String KEY_TIMEOUT = "timeout";

        public TileEntitySubsidyMachine(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityTypes.SUBSIDY_MACHINE_TILE_ENTITY_1.get(), pos, state);
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.pricePerClick = compoundTag.m_128451_(KEY_PRICE_PER_CLICK);
            this.timeout = compoundTag.m_128451_(KEY_TIMEOUT);
            super.readCompoundTag(compoundTag);
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128405_(KEY_PRICE_PER_CLICK, this.pricePerClick);
            compoundTag.m_128405_(KEY_TIMEOUT, this.timeout);
        }

        public void setData(int pricePerClick, int timeout) {
            this.pricePerClick = pricePerClick;
            this.timeout = timeout;
            this.m_6596_();
        }

        public int getPricePerClick() {
            return this.pricePerClick;
        }

        public int getTimeout() {
            return this.timeout;
        }
    }
}

