/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import forge.com.jsblock.Joban;
import forge.com.jsblock.data.PIDSPreset;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Consumer;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class JobanCustomResources {
    private static final PIDSPreset defaultPreset1 = new PIDSPreset(new ResourceLocation("jsblock", "textures/pids_screen/door_cls_apg.png"), true, true, false, new boolean[]{true, true, true, false}, null, null, null);
    private static final PIDSPreset defaultPreset2 = new PIDSPreset(new ResourceLocation("jsblock", "textures/pids_screen/door_cls_psd.png"), true, true, false, new boolean[]{true, true, true, false}, null, null, null);
    private static final PIDSPreset defaultPreset3 = new PIDSPreset(new ResourceLocation("jsblock", "textures/pids_screen/door_cls_train.png"), true, true, false, new boolean[]{true, true, true, false}, null, null, null);
    public static final String CUSTOM_RESOURCES_ID = "joban_custom_resources";
    public static final String customResourcePath = "jsblock:joban_custom_resources.json";
    public static HashMap<String, PIDSPreset> PIDSPresets = new HashMap();

    public static void reload(ResourceManager manager) {
        PIDSPresets.clear();
        PIDSPresets.put("door_cls_apg", defaultPreset1);
        PIDSPresets.put("door_cls_psd", defaultPreset2);
        PIDSPresets.put("door_cls_train", defaultPreset3);
        JobanCustomResources.readResource(manager, customResourcePath, jsonConfig -> {
            try {
                if (!jsonConfig.has("pids_images") || !jsonConfig.get("pids_images").isJsonArray()) {
                    Joban.LOGGER.warn("[JCM] Invalid joban_custom_resources.json!");
                    Joban.LOGGER.warn("[JCM] \"pids_images\" must be an array");
                    return;
                }
                jsonConfig.get("pids_images").getAsJsonArray().forEach(jsonElement -> {
                    String id = jsonElement.getAsJsonObject().get("id").getAsString();
                    if (PIDSPresets.containsKey(id)) {
                        Joban.LOGGER.warn("[Joban Client] PIDS Preset ID: " + id + " already added.");
                        return;
                    }
                    PIDSPreset preset = PIDSPreset.fromJson(jsonElement);
                    PIDSPresets.put(id, preset);
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Joban.LOGGER.info("[Joban Client] Loaded PIDS Preset: " + String.join((CharSequence)", ", PIDSPresets.keySet()));
    }

    private static void readResource(ResourceManager manager, String path, Consumer<JsonObject> callback) {
        try {
            UtilitiesClient.getResources((ResourceManager)manager, (ResourceLocation)new ResourceLocation(path)).forEach(resource -> {
                try (InputStream stream = Utilities.getInputStream((Resource)resource);){
                    callback.accept(new JsonParser().parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Utilities.closeResource((Resource)resource);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

