/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.mappings;

import dev.architectury.platform.forge.EventBuses;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkHooks;

public class ForgeUtilities {
    private static Runnable renderTickAction = () -> {};
    private static Consumer<Object> renderGameOverlayAction = matrices -> {};
    private static Consumer<Object> textureStitchEvent = atlas -> {};
    private static final List<ResourceLocation> CREATIVE_TAB_ORDER = new ArrayList<ResourceLocation>();
    private static final Map<ResourceLocation, CreativeModeTabWrapper> CREATIVE_TABS = new HashMap<ResourceLocation, CreativeModeTabWrapper>();
    private static final Set<EntityRendererPair<?>> ENTITY_RENDERER_PAIRS = new HashSet();

    public static void registerModEventBus(String modId, IEventBus eventBus) {
        EventBuses.registerModEventBus((String)modId, (IEventBus)eventBus);
    }

    public static void registerKeyBinding(KeyMapping keyMapping) {
        KeyMappingRegistry.register((KeyMapping)keyMapping);
    }

    public static Packet<?> createAddEntityPacket(Entity entity) {
        return NetworkHooks.getEntitySpawningPacket((Entity)entity);
    }

    public static Supplier<CreativeModeTab> createCreativeModeTab(ResourceLocation resourceLocation, Supplier<ItemStack> iconSupplier, String translationKey) {
        if (!CREATIVE_TAB_ORDER.contains(resourceLocation)) {
            CREATIVE_TAB_ORDER.add(resourceLocation);
            CREATIVE_TABS.put(resourceLocation, new CreativeModeTabWrapper(iconSupplier, translationKey));
        }
        return ForgeUtilities.CREATIVE_TABS.get((Object)resourceLocation).creativeModeTabSupplier;
    }

    public static void registerCreativeModeTab(ResourceLocation resourceLocation, Item item) {
        if (CREATIVE_TABS.containsKey(resourceLocation)) {
            ForgeUtilities.CREATIVE_TABS.get((Object)resourceLocation).items.add(item);
        }
    }

    public static ResourceKey<Registry<Item>> registryGetItem() {
        return Registries.f_256913_;
    }

    public static ResourceKey<Registry<Block>> registryGetBlock() {
        return Registries.f_256747_;
    }

    public static ResourceKey<Registry<BlockEntityType<?>>> registryGetBlockEntityType() {
        return Registries.f_256922_;
    }

    public static ResourceKey<Registry<EntityType<?>>> registryGetEntityType() {
        return Registries.f_256939_;
    }

    public static ResourceKey<Registry<SoundEvent>> registryGetSoundEvent() {
        return Registries.f_256840_;
    }

    public static ResourceKey<Registry<ParticleType<?>>> registryGetParticleType() {
        return Registries.f_256890_;
    }

    public static void renderTickAction(Runnable runnable) {
        renderTickAction = runnable;
    }

    public static void renderGameOverlayAction(Consumer<Object> consumer) {
        renderGameOverlayAction = consumer;
    }

    public static void registerTextureStitchEvent(Consumer<Object> consumer) {
        textureStitchEvent = consumer;
    }

    public static <T extends Entity> void registerEntityRenderer(Supplier<EntityType<? extends T>> entityType, EntityRendererProvider<T> entityRendererProvider) {
        ENTITY_RENDERER_PAIRS.add(new EntityRendererPair<T>(entityType, entityRendererProvider));
    }

    private static class CreativeModeTabWrapper {
        private CreativeModeTab creativeModeTab;
        private final Supplier<ItemStack> iconSupplier;
        private final Supplier<CreativeModeTab> creativeModeTabSupplier;
        private final String translationKey;
        private final List<Item> items = new ArrayList<Item>();

        private CreativeModeTabWrapper(Supplier<ItemStack> iconSupplier, String translationKey) {
            this.iconSupplier = iconSupplier;
            this.creativeModeTabSupplier = () -> this.creativeModeTab;
            this.translationKey = translationKey;
        }
    }

    private static class EntityRendererPair<T extends Entity> {
        private final Supplier<EntityType<? extends T>> entityTypeSupplier;
        private final EntityRendererProvider<T> entityRendererProvider;

        private EntityRendererPair(Supplier<EntityType<? extends T>> entityTypeSupplier, EntityRendererProvider<T> entityRendererProvider) {
            this.entityTypeSupplier = entityTypeSupplier;
            this.entityRendererProvider = entityRendererProvider;
        }

        private void register(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(this.entityTypeSupplier.get(), this.entityRendererProvider);
        }
    }

    public static class RegisterCreativeTabs {
        @SubscribeEvent
        public static void onRegisterCreativeModeTabsEvent(CreativeModeTabEvent.Register event) {
            CREATIVE_TAB_ORDER.forEach(resourceLocation -> {
                CreativeModeTabWrapper creativeModeTabWrapper = CREATIVE_TABS.get(resourceLocation);
                creativeModeTabWrapper.creativeModeTab = event.registerCreativeModeTab(resourceLocation, builder -> builder.m_257737_(creativeModeTabWrapper.iconSupplier).m_257941_((Component)Component.m_237115_((String)creativeModeTabWrapper.translationKey)).m_257652_());
            });
        }

        @SubscribeEvent
        public static void onRegisterCreativeModeTabsEvent(CreativeModeTabEvent.BuildContents event) {
            CREATIVE_TABS.forEach((resourceLocation, creativeModeTabWrapper) -> {
                if (creativeModeTabWrapper.creativeModeTab.m_40786_().equals(event.getTab().m_40786_())) {
                    creativeModeTabWrapper.items.forEach(item -> event.getEntries().put((Object)new ItemStack((ItemLike)item), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                }
            });
        }
    }

    public static class ClientsideEvents {
        @SubscribeEvent
        public static void onEntityRendererEvent(EntityRenderersEvent.RegisterRenderers event) {
            ENTITY_RENDERER_PAIRS.forEach(entityRendererPair -> entityRendererPair.register(event));
        }

        @SubscribeEvent
        public static void onTextureStitchEvent(TextureStitchEvent event) {
            textureStitchEvent.accept(event.getAtlas());
        }
    }

    public static class Events {
        @SubscribeEvent
        public static void onRenderTickEvent(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
                renderTickAction.run();
            }
        }

        @SubscribeEvent
        public static void onRenderGameOverlayEvent(RenderGuiOverlayEvent.Post event) {
            renderGameOverlayAction.accept(event.getPoseStack());
        }
    }
}

