/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.com.jsblock.client.ClientConfig;
import mtr.block.BlockSignalLightBase;
import mtr.block.BlockSignalSemaphoreBase;
import mtr.block.IBlock;
import mtr.data.IGui;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.UtilitiesClient;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class RenderConstantSignalBase<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IBlock,
IGui {
    protected final boolean isSingleSided;

    public RenderConstantSignalBase(BlockEntityRenderDispatcher dispatcher, boolean isSingleSided) {
        super(dispatcher);
        this.isSingleSided = isSingleSided;
    }

    public final void render(T entity, float delta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world == null || ClientConfig.getRenderDisabled()) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof BlockSignalLightBase) && !(state.m_60734_() instanceof BlockSignalSemaphoreBase)) {
            return;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)HorizontalDirectionalBlock.f_54117_);
        if (RenderTrains.shouldNotRender((BlockPos)pos, (int)RenderTrains.maxTrainRenderDistance, null)) {
            return;
        }
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.0, 0.5);
        for (int i = 0; i < 2; ++i) {
            Direction newFacing = i == 1 ? facing.m_122424_() : facing;
            matrices.m_85836_();
            UtilitiesClient.rotateYDegrees((PoseStack)matrices, (float)(-newFacing.m_122435_()));
            VertexConsumer vertexConsumer = vertexConsumers.m_6299_(MoreRenderLayers.getLight((ResourceLocation)new ResourceLocation("mtr:textures/block/white.png"), (boolean)false));
            this.render(matrices, vertexConsumers, vertexConsumer, entity, delta, newFacing, false, i == 1);
            matrices.m_85849_();
            if (this.isSingleSided) break;
        }
        matrices.m_85849_();
    }

    protected abstract void render(PoseStack var1, MultiBufferSource var2, VertexConsumer var3, T var4, float var5, Direction var6, boolean var7, boolean var8);
}

