/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.render;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.com.jsblock.block.DepartureTimer;
import forge.com.jsblock.block.FontBase;
import forge.com.jsblock.client.ClientConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.data.DataCache;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.ScheduleEntry;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderDepartureTimer<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T> {
    public RenderDepartureTimer(BlockEntityRenderDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float delta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        BlockPos pos = entity.m_58899_();
        String fontName = ((FontBase.TileEntityBlockFontBase)((Object)entity)).getFont();
        if (world == null || ClientConfig.getRenderDisabled() || !(entity instanceof DepartureTimer.TileEntityDepartureTimer)) {
            return;
        }
        long platformId = RailwayData.getClosePlatformId((Set)ClientData.PLATFORMS, (DataCache)ClientData.DATA_CACHE, (BlockPos)pos, (int)5, (int)3, (int)3);
        if (platformId == 0L) {
            return;
        }
        Set schedules = (Set)ClientData.SCHEDULES_FOR_PLATFORM.get(platformId);
        if (schedules == null) {
            return;
        }
        String timeRemaining = "";
        ArrayList scheduleList = new ArrayList(schedules);
        if (!scheduleList.isEmpty()) {
            Collections.sort(scheduleList);
            if (((ScheduleEntry)scheduleList.get((int)0)).arrivalMillis - System.currentTimeMillis() > 0L) {
                return;
            }
            int remainingSecond = (int)(((ScheduleEntry)scheduleList.get((int)0)).arrivalMillis - System.currentTimeMillis()) / 1000;
            Platform platform = (Platform)ClientData.DATA_CACHE.platformIdMap.get(platformId);
            int seconds = platform == null ? 0 : Math.abs(platform.getDwellTime() / 2 - Math.abs(remainingSecond));
            int minutes = seconds / 60;
            timeRemaining = String.format("%d:%02d", minutes % 60, seconds % 60);
        }
        Style style = Config.useMTRFont() ? Style.f_131099_.m_131150_(new ResourceLocation(fontName)) : Style.f_131099_;
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockGetter)world, (BlockPos)pos, (Property)HorizontalDirectionalBlock.f_54117_);
        matrices.m_85836_();
        if (facing == Direction.SOUTH) {
            matrices.m_85837_(0.73, 0.52, 0.43);
        }
        if (facing == Direction.NORTH) {
            matrices.m_85837_(0.28, 0.52, 0.57);
        }
        if (facing == Direction.EAST) {
            matrices.m_85837_(0.43, 0.52, 0.28);
        }
        if (facing == Direction.WEST) {
            matrices.m_85837_(0.57, 0.52, 0.73);
        }
        UtilitiesClient.rotateZDegrees((PoseStack)matrices, (float)180.0f);
        UtilitiesClient.rotateYDegrees((PoseStack)matrices, (float)facing.m_122435_());
        matrices.m_85841_(0.018f, 0.018f, 0.018f);
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        MutableComponent formattedText = Text.literal((String)timeRemaining).m_6270_(style);
        textRenderer.m_92889_(matrices, (Component)formattedText, 0.0f, 0.0f, 0xEE2233);
        matrices.m_85849_();
    }
}

