/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import forge.com.jsblock.block.FontBase;
import forge.com.jsblock.block.KCRNameSign;
import forge.com.jsblock.client.ClientConfig;
import forge.com.jsblock.screen.IDrawingJoban;
import java.util.Set;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.data.DataCache;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderKCRStationName<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IGui {
    public RenderKCRStationName(BlockEntityRenderDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float delta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (!(entity instanceof FontBase.TileEntityBlockFontBase)) {
            return;
        }
        Level world = entity.m_58904_();
        BlockPos pos = entity.m_58899_();
        String fontName = ((FontBase.TileEntityBlockFontBase)((Object)entity)).getFont();
        if (world == null || ClientConfig.getRenderDisabled()) {
            return;
        }
        Station station = RailwayData.getStation((Set)ClientData.STATIONS, (DataCache)ClientData.DATA_CACHE, (BlockPos)pos);
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockGetter)world, (BlockPos)pos, (Property)HorizontalDirectionalBlock.f_54117_);
        Boolean exitOnLeft = (Boolean)IBlock.getStatePropertySafe((BlockGetter)world, (BlockPos)pos, (Property)KCRNameSign.EXIT_ON_LEFT);
        double offset = exitOnLeft != false ? 0.5 : 0.0;
        for (int i = 0; i < 2; ++i) {
            Direction newFacing;
            Direction direction = newFacing = i == 1 ? facing.m_122424_() : facing;
            offset = i == 1 ? (!exitOnLeft.booleanValue() ? 0.5 : 0.0) : offset;
            matrices.m_85836_();
            if (newFacing == Direction.SOUTH) {
                matrices.m_85837_(0.69 - offset, 0.53, 0.33);
            }
            if (newFacing == Direction.NORTH) {
                matrices.m_85837_(0.31 + offset, 0.53, 0.67);
            }
            if (newFacing == Direction.EAST) {
                matrices.m_85837_(0.33, 0.53, 0.31 + offset);
            }
            if (newFacing == Direction.WEST) {
                matrices.m_85837_(0.67, 0.53, 0.69 - offset);
            }
            UtilitiesClient.rotateZDegrees((PoseStack)matrices, (float)180.0f);
            UtilitiesClient.rotateYDegrees((PoseStack)matrices, (float)newFacing.m_122435_());
            matrices.m_85841_(0.021f, 0.021f, 0.021f);
            Font textRenderer = Minecraft.m_91087_().f_91062_;
            String stationName = station == null ? Text.translatable((String)"gui.mtr.untitled", (Object[])new Object[0]).getString() : station.name;
            MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            IDrawingJoban.drawStringWithFont(matrices, textRenderer, immediate, stationName, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0.0f, 0.0f, 60.0f, 32.0f, 1.0f, false, 0xEEEEEE, false, 0xF000F0, fontName);
            immediate.m_109911_();
            matrices.m_85849_();
        }
    }
}

