/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.com.jsblock.data.PIDSPreset;
import forge.com.jsblock.render.RenderPIDSBase;
import forge.com.jsblock.screen.IDrawingJoban;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mtr.MTRClient;
import mtr.block.IBlock;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.data.DataCache;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.ScheduleEntry;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderLCDPIDS<T extends BlockEntityMapper>
extends RenderPIDSBase<T>
implements IGui {
    private static final float BACKGROUND_WIDTH = 111.0f;
    private static final float BACKGROUND_HEIGHT = 60.0f;
    private final float scale;
    private final float totalScaledWidth;
    private final float destinationStart;
    private final float destinationMaxWidth;
    private final float platformMaxWidth;
    private final float arrivalMaxWidth;
    private final int maxArrivals;
    private final float maxHeight;
    private final float startX;
    private final float startY;
    private final float startZ;
    private final boolean rotate90;
    private final boolean showPlatforms;
    private final float screenWidth;
    private final float rotation;
    private final int defaultTextColor;
    private static final String defaultFont = "jsblock:pids_lcd";
    private final PIDSPreset DEFAULT_PRESET = new PIDSPreset(null, false, false, false, SHOW_ALL_ROWS, null, null, null);
    private List<ClientCache.PlatformRouteDetails> routeData;

    public RenderLCDPIDS(BlockEntityRenderDispatcher dispatcher, int maxArrivals, float startX, float startY, float startZ, float maxHeight, int maxWidth, boolean rotate90, boolean renderArrivalNumber, boolean showPlatforms, int defaultTextColor, float rotation) {
        super(dispatcher, maxArrivals);
        this.scale = (float)(230 * maxArrivals) / maxHeight;
        this.totalScaledWidth = this.scale * (float)maxWidth / 16.0f;
        this.destinationStart = renderArrivalNumber ? this.scale * 2.0f / 16.0f : 0.0f;
        this.destinationMaxWidth = this.totalScaledWidth * 0.33f;
        this.platformMaxWidth = showPlatforms ? this.scale * 2.0f / 16.0f : 0.0f;
        this.arrivalMaxWidth = this.totalScaledWidth - this.destinationStart - this.destinationMaxWidth - this.platformMaxWidth;
        this.screenWidth = this.arrivalMaxWidth / 1.35f;
        this.maxArrivals = maxArrivals;
        this.maxHeight = maxHeight;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.rotate90 = rotate90;
        this.showPlatforms = showPlatforms;
        this.rotation = rotation;
        this.defaultTextColor = defaultTextColor;
    }

    @Override
    public void render(T entity, Level world, String[] customMessages, boolean[] hideArrivals, boolean hidePlatforms, PIDSPreset preset, List<Long> filteredPlatformIds, float delta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        BlockPos pos = entity.m_58899_();
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockGetter)world, (BlockPos)pos, (Property)HorizontalDirectionalBlock.f_54117_);
        try {
            Object vertexConsumerPIDSBG;
            PIDSPreset pidsPreset = preset == null ? this.DEFAULT_PRESET : preset;
            Font textRenderer = Minecraft.m_91087_().f_91062_;
            String textFont = pidsPreset.font == null ? defaultFont : pidsPreset.font;
            int textColor = pidsPreset.color == null ? this.defaultTextColor : pidsPreset.color;
            int languageTicks = (int)Math.floor(MTRClient.getGameTick()) / 80;
            MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            ArrayList scheduleList = new ArrayList();
            matrices.m_85836_();
            matrices.m_85837_(0.5, 0.0, 0.5);
            UtilitiesClient.rotateYDegrees((PoseStack)matrices, (float)((float)(this.rotate90 ? 90 : 0) - facing.m_122435_()));
            UtilitiesClient.rotateZDegrees((PoseStack)matrices, (float)180.0f);
            UtilitiesClient.rotateXDegrees((PoseStack)matrices, (float)this.rotation);
            matrices.m_252880_((this.startX - 8.0f) / 16.0f, -this.startY / 16.0f + 0.0f * this.maxHeight / (float)this.maxArrivals / 16.0f, (this.startZ - 8.0f) / 16.0f - 0.00625f);
            matrices.m_85841_(1.0f / this.scale, 1.0f / this.scale, 1.0f / this.scale);
            if (pidsPreset.image != null) {
                matrices.m_85836_();
                vertexConsumerPIDSBG = vertexConsumers.m_6299_(MoreRenderLayers.getLight((ResourceLocation)pidsPreset.image, (boolean)false));
                matrices.m_85837_(0.0, -1.0, 0.01);
                RenderLCDPIDS.drawTexture(matrices, (VertexConsumer)vertexConsumerPIDSBG, this.startX - 10.5f, -1.5f, 111.0f, 60.0f, facing, -1, 0xF000F0);
                matrices.m_85849_();
            }
            matrices.m_85849_();
            if (RenderTrains.shouldNotRender((BlockPos)pos, (int)Math.min(16, RenderTrains.maxTrainRenderDistance), (Direction)(this.rotate90 ? null : facing))) {
                return;
            }
            if (!filteredPlatformIds.isEmpty()) {
                vertexConsumerPIDSBG = filteredPlatformIds.iterator();
                while (vertexConsumerPIDSBG.hasNext()) {
                    long platformId = (Long)vertexConsumerPIDSBG.next();
                    Set schedulesForPlatform = (Set)ClientData.SCHEDULES_FOR_PLATFORM.get(platformId);
                    if (schedulesForPlatform == null) continue;
                    scheduleList.addAll(schedulesForPlatform);
                }
            } else {
                long closestPlatformId = RailwayData.getClosePlatformId((Set)ClientData.PLATFORMS, (DataCache)ClientData.DATA_CACHE, (BlockPos)pos);
                Set schedulesForPlatform = (Set)ClientData.SCHEDULES_FOR_PLATFORM.get(closestPlatformId);
                if (schedulesForPlatform != null) {
                    scheduleList.addAll(schedulesForPlatform);
                }
            }
            Collections.sort(scheduleList);
            int maxCars = 0;
            int minCars = Integer.MAX_VALUE;
            for (ScheduleEntry scheduleEntry : scheduleList) {
                int trainCars = scheduleEntry.trainCars;
                if (trainCars > maxCars) {
                    maxCars = trainCars;
                }
                if (trainCars >= minCars) continue;
                minCars = trainCars;
            }
            boolean showCarLength = minCars != maxCars;
            int entryIndex = 0;
            for (int i = 0; i < this.maxArrivals; ++i) {
                boolean useCustomMessage;
                Object destinationString;
                Route route;
                ScheduleEntry currentSchedule = entryIndex < scheduleList.size() ? (ScheduleEntry)scheduleList.get(entryIndex) : null;
                Route route2 = route = currentSchedule == null ? null : (Route)ClientData.DATA_CACHE.routeIdMap.get(currentSchedule.routeId);
                if (entryIndex < scheduleList.size() && !hideArrivals[i] && route != null) {
                    destinationSplit = ClientData.DATA_CACHE.getFormattedRouteDestination(route, currentSchedule.currentStationIndex, "").split("\\|");
                    boolean isLightRailRoute = route.isLightRailRoute;
                    String[] routeNumberSplit = route.lightRailRouteNumber.split("\\|");
                    if (customMessages[i].isEmpty()) {
                        destinationString = (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled((String)destinationSplit[languageTicks % destinationSplit.length]);
                        useCustomMessage = false;
                    } else {
                        String[] customMessageSplit = customMessages[i].split("\\|");
                        int destinationMaxIndex = Math.max(routeNumberSplit.length, destinationSplit.length);
                        int indexToUse = languageTicks % (destinationMaxIndex + customMessageSplit.length);
                        if (indexToUse < destinationMaxIndex) {
                            destinationString = (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled((String)destinationSplit[languageTicks % destinationSplit.length]);
                            useCustomMessage = false;
                        } else {
                            destinationString = customMessageSplit[indexToUse - destinationMaxIndex];
                            useCustomMessage = true;
                        }
                    }
                } else {
                    destinationSplit = customMessages[i].split("\\|");
                    destinationString = destinationSplit[languageTicks % destinationSplit.length];
                    useCustomMessage = true;
                }
                matrices.m_85836_();
                matrices.m_85837_(0.5, 0.0, 0.5);
                UtilitiesClient.rotateYDegrees((PoseStack)matrices, (float)((float)(this.rotate90 ? 90 : 0) - facing.m_122435_()));
                UtilitiesClient.rotateZDegrees((PoseStack)matrices, (float)180.0f);
                matrices.m_252880_((this.startX - 8.0f) / 16.0f, -this.startY / 16.0f + (float)i * this.maxHeight / (float)this.maxArrivals / 16.0f, (this.startZ - 8.0f) / 16.0f - 0.00625f);
                matrices.m_85841_(1.0f / (this.scale / 2.0f), 1.0f / (this.scale / 2.0f), 1.0f / (this.scale / 2.0f));
                if (useCustomMessage) {
                    IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, (String)destinationString, 0.0f, 0.0f, this.screenWidth, 4.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.TOP, false, textFont);
                } else {
                    int seconds = (int)((currentSchedule.arrivalMillis - System.currentTimeMillis()) / 1000L);
                    boolean isCJK = IGui.isCjk((String)destinationString);
                    MutableComponent arrivalText = seconds >= 60 ? Text.translatable((String)(isCJK ? "gui.mtr.arrival_min_cjk" : "gui.mtr.arrival_min"), (Object[])new Object[]{seconds / 60}) : (seconds > 0 ? Text.translatable((String)(isCJK ? "gui.mtr.arrival_sec_cjk" : "gui.mtr.arrival_sec"), (Object[])new Object[]{seconds}) : null);
                    matrices.m_85836_();
                    matrices.m_252880_(this.destinationStart, 0.0f, 0.0f);
                    IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, (String)destinationString, 0.0f, 0.0f, this.destinationMaxWidth, 5.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.TOP, false, textFont);
                    matrices.m_85849_();
                    if (arrivalText != null) {
                        boolean isShowCar = showCarLength && (languageTicks % 6 == 0 || languageTicks % 6 == 1);
                        matrices.m_85836_();
                        matrices.m_252880_(this.screenWidth, 0.0f, 0.0f);
                        if (isShowCar) {
                            MutableComponent carText = Text.translatable((String)(isCJK ? "gui.mtr.arrival_car_cjk" : "gui.mtr.arrival_car"), (Object[])new Object[]{currentSchedule.trainCars});
                            Integer carColor = pidsPreset.getCarColor(currentSchedule.trainCars);
                            IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, carText.getString(), 0.0f, -0.025f, 15.0f, 5.0f, carColor == null ? textColor : carColor, 0xF000F0, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.TOP, false, textFont);
                        } else {
                            IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, arrivalText.getString(), 0.0f, -0.025f, 15.0f, 5.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.TOP, false, textFont);
                        }
                        matrices.m_85849_();
                    }
                }
                matrices.m_85849_();
                if (hideArrivals[i] || useCustomMessage && pidsPreset.customTextPushArrival) continue;
                ++entryIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

