/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.com.jsblock.block.BlockPIDSBaseHorizontal;
import forge.com.jsblock.block.JobanPIDSBase;
import forge.com.jsblock.block.PIDSRVBase;
import forge.com.jsblock.client.ClientConfig;
import forge.com.jsblock.client.JobanCustomResources;
import forge.com.jsblock.data.PIDSPreset;
import java.util.ArrayList;
import java.util.List;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public abstract class RenderPIDSBase<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IGui {
    private final int maxArrivals;
    public static final int SWITCH_LANGUAGE_TICKS = 80;
    public static final int MAX_VIEW_DISTANCE = 16;
    public static final boolean[] SHOW_ALL_ROWS = new boolean[]{false, false, false, false};

    public RenderPIDSBase(BlockEntityRenderDispatcher dispatcher, int maxArrivals) {
        super(dispatcher);
        this.maxArrivals = maxArrivals;
    }

    public void render(T entity, float delta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world == null || ClientConfig.getRenderDisabled()) {
            return;
        }
        if (!(entity instanceof JobanPIDSBase.TileEntityBlockJobanPIDS)) {
            return;
        }
        String[] customMessages = new String[this.maxArrivals];
        ArrayList<Long> platformIds = new ArrayList<Long>(((BlockPIDSBaseHorizontal.TileEntityBlockPIDSBaseHorizontal)((Object)entity)).getPlatformIds());
        boolean[] hideArrivals = new boolean[this.maxArrivals];
        String presetID = ((JobanPIDSBase.TileEntityBlockJobanPIDS)((Object)entity)).getPresetID();
        PIDSPreset preset = JobanCustomResources.PIDSPresets.getOrDefault(presetID, null);
        if (preset != null && preset.visibility != null) {
            System.arraycopy(preset.visibility, 0, hideArrivals, 0, hideArrivals.length);
        }
        for (int i = 0; i < this.maxArrivals; ++i) {
            customMessages[i] = RenderPIDSBase.parseVariable(((BlockPIDSBaseHorizontal.TileEntityBlockPIDSBaseHorizontal)((Object)entity)).getMessage(i), world);
            boolean hideArrival = ((BlockPIDSBaseHorizontal.TileEntityBlockPIDSBaseHorizontal)((Object)entity)).getHideArrival(i);
            if (!hideArrival) continue;
            hideArrivals[i] = true;
        }
        boolean hidePlatforms = entity instanceof PIDSRVBase.TileEntityBlockRVPIDS ? ((PIDSRVBase.TileEntityBlockRVPIDS)((Object)entity)).getHidePlatformNumber() : false;
        try {
            this.render(entity, world, customMessages, hideArrivals, hidePlatforms, preset, platformIds, delta, matrices, vertexConsumers, light, overlay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void render(T var1, Level var2, String[] var3, boolean[] var4, boolean var5, PIDSPreset var6, List<Long> var7, float var8, PoseStack var9, MultiBufferSource var10, int var11, int var12);

    public static String parseVariable(String str, Level world) {
        String weatherString;
        long time = world.m_46468_() + 6000L;
        long hours = time / 1000L;
        long minutes = Math.round((double)(time - hours * 1000L) / 16.8);
        String timeString = String.format("%02d:%02d", hours % 24L, minutes % 60L);
        String string = world.m_46471_() ? "Raining" : (weatherString = world.m_46470_() ? "Thundering" : "Sunny");
        String weatherChinString = world.m_46471_() ? "\u4e0b\u96e8" : (world.m_46470_() ? "\u96f7\u66b4" : "\u6674\u5929");
        int worldDay = (int)(world.m_46468_() / 24000L);
        int worldPlayer = world.m_6907_().size();
        String timeGreetings = time >= 6000L & time <= 12000L ? "Morning" : (time >= 12000L & time <= 18000L ? "Afternoon" : "Night");
        return str.replace("{time}", timeString).replace("{day}", String.valueOf(worldDay)).replace("{weather}", weatherString).replace("{time_period}", timeGreetings).replace("{weatherChin}", weatherChinString).replace("{worldPlayer}", String.valueOf(worldPlayer));
    }

    static void drawTexture(PoseStack matrices, VertexConsumer vertexConsumer, float x, float y, float width, float height, Direction facing, int color, int light) {
        IDrawing.drawTexture((PoseStack)matrices, (VertexConsumer)vertexConsumer, (float)x, (float)y, (float)0.0f, (float)(x + width), (float)(y + height), (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)facing, (int)color, (int)light);
    }
}

