/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.screen;

import forge.com.jsblock.Joban;
import forge.com.jsblock.client.ClientConfig;
import forge.com.jsblock.data.InlineComponentEntry;
import forge.com.jsblock.data.ScreenAlignment;
import forge.com.jsblock.data.ScreenRoot;
import forge.com.jsblock.data.TextLabel;
import forge.com.jsblock.screen.ConfigScreenBase;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import mtr.data.IGui;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;

public class ConfigScreen
extends ConfigScreenBase
implements IGui {
    private boolean enableRendering;
    private boolean ignoreVerCheck;
    private boolean debugMode;
    private boolean initalized;
    private static final Component TITLE_TEXT = Text.translatable((String)"gui.jsblock.brand", (Object[])new Object[0]);
    private static final Component VERSION_TEXT = Text.translatable((String)"gui.jsblock.version", (Object[])new Object[]{Joban.getVersion()});

    public ConfigScreen() {
        super(new ScreenRoot(ScreenAlignment.HORZ_CENTER, 1.25f, 1.0f), new TextLabel(TITLE_TEXT, 2.0f, ScreenAlignment.HORZ_CENTER, 6), new TextLabel(VERSION_TEXT, 1.0f, ScreenAlignment.HORZ_CENTER, 6));
    }

    @Override
    protected void m_7856_() {
        if (!this.initalized) {
            this.initalized = true;
            this.enableRendering = ClientConfig.getRenderDisabled();
            this.ignoreVerCheck = ClientConfig.getVersionCheckDisabled();
            this.debugMode = ClientConfig.getDebugModeEnabled();
            this.registerConfigRowButton(Text.translatable((String)"gui.jsblock.config.enable_render", (Object[])new Object[0]), ConfigScreen.getBooleanButtonText(this.enableRendering), button -> {
                this.enableRendering = ClientConfig.setRenderDisabled(!this.enableRendering);
                button.m_93666_(ConfigScreen.getBooleanButtonText(this.enableRendering));
            });
            this.registerConfigRowButton(Text.translatable((String)"gui.jsblock.config.ignore_ver_check", (Object[])new Object[0]), ConfigScreen.getBooleanButtonText(this.ignoreVerCheck), button -> {
                this.ignoreVerCheck = ClientConfig.setVersionCheckDisabled(!this.ignoreVerCheck);
                button.m_93666_(ConfigScreen.getBooleanButtonText(this.ignoreVerCheck));
            });
            this.registerConfigRowButton(Text.translatable((String)"gui.jsblock.config.debug_mode", (Object[])new Object[0]), ConfigScreen.getBooleanButtonText(this.debugMode), button -> {
                this.debugMode = ClientConfig.setDebugMode(!this.debugMode);
                button.m_93666_(ConfigScreen.getBooleanButtonText(this.debugMode));
            });
            Button saveButton = UtilitiesClient.newButton((Component)Text.translatable((String)"gui.jsblock.config.save", (Object[])new Object[0]), button1 -> this.closeScreen(true));
            Button discardButton = UtilitiesClient.newButton((Component)Text.translatable((String)"gui.jsblock.config.discard", (Object[])new Object[0]), button1 -> this.closeScreen(false));
            Button resetButton = UtilitiesClient.newButton((Component)Text.translatable((String)"gui.jsblock.config.reset", (Object[])new Object[0]), button1 -> {
                ClientConfig.setRenderDisabled(false);
                ClientConfig.setVersionCheckDisabled(false);
                ClientConfig.setDebugMode(false);
                this.closeScreen(true);
            });
            Button latestLogButton = UtilitiesClient.newButton((Component)Text.translatable((String)"gui.jsblock.config.openlog", (Object[])new Object[0]), button1 -> this.showLog());
            Button crashLogButton = UtilitiesClient.newButton((Component)Text.translatable((String)"gui.jsblock.config.opencrashlog", (Object[])new Object[0]), button1 -> this.showCrashLog());
            InlineComponentEntry inlineRowConfig = new InlineComponentEntry(ScreenAlignment.HORZ_CENTER, ScreenAlignment.VERT_BOTTOM, new AbstractWidget[]{saveButton, discardButton, resetButton});
            InlineComponentEntry inlineRowLogs = new InlineComponentEntry(ScreenAlignment.HORZ_CENTER, ScreenAlignment.VERT_BOTTOM, new AbstractWidget[]{latestLogButton, crashLogButton});
            this.registerInlineRow(inlineRowLogs, inlineRowConfig);
        }
        super.m_7856_();
    }

    private void showLog() {
        File latestLog = Paths.get(this.f_96541_.f_91069_.toString(), "logs", "latest.log").toFile();
        if (latestLog.exists()) {
            Util.m_137581_().m_137644_(latestLog);
        }
    }

    private void showCrashLog() {
        Path logDir = Paths.get(this.f_96541_.f_91069_.toString(), "crash-reports");
        if (Files.exists(logDir, new LinkOption[0])) {
            File[] crashLogList = logDir.toFile().listFiles();
            if (crashLogList != null && crashLogList.length > 0) {
                Arrays.sort(crashLogList, Comparator.comparingLong(File::lastModified));
                Util.m_137581_().m_137644_(crashLogList[0]);
            } else {
                SystemToast errorToast = SystemToast.m_94847_((Minecraft)this.f_96541_, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Text.translatable((String)"gui.jsblock.brand", (Object[])new Object[0]), (Component)Text.translatable((String)"gui.jsblock.config.nocrashlogfound", (Object[])new Object[0]));
                this.f_96541_.m_91300_().m_94922_((Toast)errorToast);
            }
        }
    }

    @Override
    public void onSave() {
        try {
            ClientConfig.writeConfig();
        }
        catch (Exception e) {
            SystemToast errorToast = SystemToast.m_94847_((Minecraft)this.f_96541_, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Text.translatable((String)"gui.jsblock.brand", (Object[])new Object[0]), (Component)Text.translatable((String)"gui.jsblock.config.savefailed", (Object[])new Object[0]));
            this.f_96541_.m_91300_().m_94922_((Toast)errorToast);
        }
        super.m_7379_();
    }
}

