/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import forge.com.jsblock.data.ConfigGuiEntry;
import forge.com.jsblock.data.InlineComponentEntry;
import forge.com.jsblock.data.ScreenAlignment;
import forge.com.jsblock.data.ScreenRoot;
import forge.com.jsblock.data.TextLabel;
import forge.com.jsblock.vermappings.render.RenderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;

public class ConfigScreenBase
extends ScreenMapper
implements IGui {
    private double elapsedTime;
    private final List<InlineComponentEntry> inlineComponentList;
    private final List<ConfigGuiEntry> configList;
    private final List<TextLabel> customText;
    private final ScreenRoot screenRoot;
    private boolean initalized;
    public static final int BUTTON_HEIGHT = 20;
    private static final int TRANSITION_DURATION = 20;
    private static final int TEXT_PADDING = 12;
    private static final int CONFIG_BUTTON_WIDTH = 60;
    private static final int TEXT_FIELD_WIDTH = 100;
    private static final int FINAL_TEXT_HEIGHT = 20;
    private static final int MAX_TEXT_LENGTH = 128;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("jsblock:textures/gui/background/bg.png");
    private static final ResourceLocation STAR_BACKGROUND = new ResourceLocation("jsblock:textures/gui/background/stars.png");
    private static final ResourceLocation TERRAIN_BACKGROUND = new ResourceLocation("jsblock:textures/gui/background/terrain.png");

    public ConfigScreenBase(ScreenRoot root, TextLabel ... customText) {
        super((Component)Text.literal((String)""));
        this.screenRoot = root;
        this.inlineComponentList = new ArrayList<InlineComponentEntry>();
        this.customText = new ArrayList<TextLabel>();
        this.configList = new ArrayList<ConfigGuiEntry>();
        this.customText.addAll(Arrays.asList(customText));
    }

    public AbstractWidget registerConfigRowButton(MutableComponent description, Component defaultMessage, Consumer<AbstractWidget> onClick) {
        Button button = UtilitiesClient.newButton((Component)Text.literal((String)""), onClick::accept);
        button.m_93666_(defaultMessage);
        this.configList.add(new ConfigGuiEntry(description, (AbstractWidget)button, 60, 20));
        return button;
    }

    public void registerInlineRow(InlineComponentEntry ... entries) {
        this.inlineComponentList.addAll(Arrays.asList(entries));
    }

    /*
     * WARNING - void declaration
     */
    protected void m_7856_() {
        void var4_7;
        super.m_7856_();
        int i = 0;
        int startY = 0;
        for (TextLabel textLabel : this.customText) {
            startY += (int)(textLabel.y * (double)textLabel.scale);
        }
        this.screenRoot.init(this.f_96543_, this.f_96544_);
        ArrayList<ConfigGuiEntry> originalList = new ArrayList<ConfigGuiEntry>(this.configList);
        this.configList.clear();
        for (ConfigGuiEntry configGuiEntry : originalList) {
            configGuiEntry.y = startY + 12 + (20 * i++ + 20);
            this.configList.add(configGuiEntry);
            IDrawing.setPositionAndWidth((AbstractWidget)configGuiEntry.widget, (int)(this.f_96543_ - this.screenRoot.startX - 60), (int)configGuiEntry.y, (int)configGuiEntry.widgetWidth);
            this.addDrawableChild(configGuiEntry.widget);
        }
        boolean bl = false;
        while (var4_7 < this.inlineComponentList.size()) {
            InlineComponentEntry inlineComponentEntry = this.inlineComponentList.get((int)var4_7);
            inlineComponentEntry.setAvailableWidth(this.screenRoot.width);
            for (int j = 0; j < inlineComponentEntry.widgetList.size(); ++j) {
                AbstractWidget widget = inlineComponentEntry.widgetList.get(j);
                UtilitiesClient.setWidgetX((AbstractWidget)widget, (int)(inlineComponentEntry.calculateWidth() * j));
                this.addDrawableChild(widget);
            }
            this.inlineComponentList.set((int)var4_7, inlineComponentEntry);
            ++var4_7;
        }
        if (!this.initalized) {
            this.initalized = true;
        }
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.elapsedTime += (double)delta;
            int startY = 0;
            this.renderBG(matrices);
            for (TextLabel component : this.customText) {
                int textWidth = (int)((float)this.f_96547_.m_92852_((FormattedText)component.text) * component.scale);
                int componentX = this.screenRoot.startX + ScreenAlignment.getX(component.horizontalAlignment, this.screenRoot.width, textWidth);
                int componentY = (int)((double)startY + component.y);
                matrices.m_85836_();
                matrices.m_252880_((float)componentX, (float)componentY, 0.0f);
                matrices.m_85841_(component.scale, component.scale, component.scale);
                this.f_96547_.m_92763_(matrices, component.text, 0.0f, 0.0f, -1);
                startY = (int)((float)startY + 12.0f * component.scale);
                matrices.m_85849_();
            }
            for (ConfigGuiEntry entry : this.configList) {
                boolean mouseXInScreenRoot = RailwayData.isBetween((double)mouseX, (double)this.screenRoot.startX, (double)(this.screenRoot.startX + this.screenRoot.width));
                boolean mouseYInThisEntry = RailwayData.isBetween((double)mouseY, (double)entry.y, (double)(entry.y + entry.widgetHeight));
                if (mouseXInScreenRoot && mouseYInThisEntry) {
                    RenderSystem.m_69478_();
                    RenderSystem.m_69453_();
                    RenderHelper.disableTexture();
                    RenderHelper.setShaderColor(1.0f, 1.0f, 1.0f, 0.3f);
                    RenderHelper.fill(matrices, this.screenRoot.startX, entry.y, this.screenRoot.width, entry.widgetHeight, -1);
                    RenderHelper.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                    RenderHelper.enableTexture();
                }
                ConfigScreenBase.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)entry.text, (int)this.screenRoot.startX, (int)(entry.y + entry.widgetHeight / 4), (int)-1);
            }
            int inlineRow = 1;
            int bottomPadding = 20;
            for (InlineComponentEntry entry : this.inlineComponentList) {
                int startInlineY = ScreenAlignment.getY(entry.verticalAlignment, this.f_96544_, 20) - 20 * this.inlineComponentList.size() - bottomPadding;
                int y = startInlineY + 20 * inlineRow;
                int totalWidth = entry.calculateWidth() * entry.widgetList.size() + 10 * entry.widgetList.size();
                int startX = ScreenAlignment.getX(entry.horizontalAlignment, this.f_96543_, totalWidth);
                for (int i = 0; i < entry.widgetList.size(); ++i) {
                    AbstractWidget widget = entry.widgetList.get(i);
                    int buttonX = startX + entry.calculateWidth() * i + 10 * i;
                    IDrawing.setPositionAndWidth((AbstractWidget)widget, (int)buttonX, (int)y, (int)entry.calculateWidth());
                }
                ++inlineRow;
            }
            super.m_86412_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256) {
            this.closeScreen(true);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifier);
    }

    private void renderBG(PoseStack matrices) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        double easing = this.easeOutAnimation(Math.min(1.0, this.elapsedTime / 20.0));
        this.renderTexture(matrices, bufferBuilder, BACKGROUND, this.f_96543_, this.f_96544_, 1.0f, 1.0f);
        tesselator.m_85914_();
        int starBackgroundSize = Math.max(this.f_96543_, this.f_96544_) * 4;
        float starUVSize = (float)starBackgroundSize / 384.0f;
        matrices.m_85836_();
        matrices.m_85837_(0.0, (1.0 - easing) * ((double)this.f_96544_ * 0.2), 0.0);
        matrices.m_85837_((double)this.f_96543_ / 2.0, (double)this.f_96544_ / 2.0, 0.0);
        float rotationAngle = (float)this.elapsedTime * -0.075f % 360.0f;
        matrices.m_252781_(new Quaternionf(0.0f, 0.0f, 1.0f, rotationAngle / 360.0f));
        matrices.m_85837_((double)(-this.f_96543_) / 2.0, (double)(-this.f_96544_) / 2.0, 0.0);
        this.renderTexture(matrices, bufferBuilder, STAR_BACKGROUND, starBackgroundSize, starBackgroundSize, starUVSize, starUVSize);
        matrices.m_85849_();
        tesselator.m_85914_();
        int terrainHeight = this.f_96543_ / 4;
        matrices.m_85836_();
        matrices.m_85837_(0.0, (double)this.f_96544_ - (double)terrainHeight * easing, 0.0);
        this.renderTexture(matrices, bufferBuilder, TERRAIN_BACKGROUND, this.f_96543_, terrainHeight, 1.0f, 1.0f);
        matrices.m_85849_();
        tesselator.m_85914_();
    }

    private void renderTexture(PoseStack matrices, BufferBuilder bufferBuilder, ResourceLocation identifier, float width, float height, float u, float v) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderHelper.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderHelper.setTexture(this.f_96541_, identifier);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        PoseStack.Pose pose = matrices.m_85850_();
        bufferBuilder.m_252986_(pose.m_252922_(), 0.0f, height, 0.0f).m_7421_(0.0f, v).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(pose.m_252922_(), width, height, 0.0f).m_7421_(u, v).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(pose.m_252922_(), width, 0.0f, 0.0f).m_7421_(u, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_252986_(pose.m_252922_(), 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
    }

    public void closeScreen(boolean save) {
        if (save) {
            this.onSave();
        }
        super.m_7379_();
    }

    public void onSave() {
    }

    protected static Component getBooleanButtonText(boolean state) {
        return Text.translatable((String)(state ? "options.mtr.on" : "options.mtr.off"), (Object[])new Object[0]);
    }

    private double easeOutAnimation(double x) {
        return x == 1.0 ? 1.0 : 1.0 - Math.pow(1.0 - x, 5.0);
    }
}

