/*
 * Decompiled with CFR 0.152.
 */
package net.londonunderground.render;

import java.util.Locale;
import java.util.Set;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.IDrawing;
import mtr.data.DataCache;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.londonunderground.blocks.BlockRoundelBase;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_824;
import org.joml.Matrix4f;

public class RenderNameProjector<T extends BlockRoundelBase.TileEntityBlockRoundelBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IDrawing {
    private final float maxWidth;
    private final float maxScale;
    private final float xOffset;
    private final float yOffset;
    private final float zOffset;
    private final float xTilt;
    private final int textColor;
    private final boolean isDoubleSided;
    private static class_2583 STYLE;
    private final String font;

    public RenderNameProjector(class_824 dispatcher, float maxWidth, float maxScale, float xOffset, float yOffset, float zOffset, float xTilt, int textColor, boolean isDoubleSided, String font) {
        super(dispatcher);
        this.maxWidth = maxWidth;
        this.maxScale = maxScale;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.xTilt = xTilt;
        this.textColor = textColor;
        this.isDoubleSided = isDoubleSided;
        this.font = font;
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        STYLE = Config.useMTRFont() ? class_2583.field_24360.method_27704(new class_2960("londonunderground", this.font)) : class_2583.field_24360;
        if (!((BlockRoundelBase.TileEntityBlockRoundelBase)((Object)entity)).shouldRender()) {
            return;
        }
        class_1937 world = entity.method_10997();
        if (world == null) {
            return;
        }
        class_2338 pos = entity.method_11016();
        class_2680 state = world.method_8320(pos);
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_2680)state, (class_2769)BlockRoundelBase.field_11177);
        int color = switch ((Integer)IBlock.getStatePropertySafe((class_2680)state, (class_2769)BlockRoundelBase.COLOR)) {
            case 1 -> -5592406;
            case 2 -> -16777216;
            default -> -1;
        };
        Station station = RailwayData.getStation((Set)ClientData.STATIONS, (DataCache)ClientData.DATA_CACHE, (class_2338)pos);
        class_5481 roundelText = Text.literal((String)IGui.textOrUntitled((String)IGui.formatStationName((String)(station == null ? "" : station.name))).toUpperCase(Locale.ROOT)).method_10862(STYLE).method_30937();
        int textWidth = class_310.method_1551().field_1772.method_30880(roundelText);
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        UtilitiesClient.rotateYDegrees((class_4587)matrices, (float)(-facing.method_10144()));
        UtilitiesClient.rotateZDegrees((class_4587)matrices, (float)180.0f);
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        this.render(matrices, immediate, roundelText, textWidth, color, light);
        if (this.isDoubleSided) {
            UtilitiesClient.rotateYDegrees((class_4587)matrices, (float)180.0f);
            this.render(matrices, immediate, roundelText, textWidth, color, light);
        }
        immediate.method_22993();
        matrices.method_22909();
    }

    private void render(class_4587 matrices, class_4597.class_4598 immediate, class_5481 roundelText, int textWidth, int color, int light) {
        matrices.method_22903();
        UtilitiesClient.rotateXDegrees((class_4587)matrices, (float)this.xTilt);
        matrices.method_46416(-this.xOffset, -this.yOffset, -this.zOffset - 0.00625f);
        float scale = Math.min(this.maxWidth / (float)textWidth, this.maxScale);
        matrices.method_22905(scale, scale, scale);
        matrices.method_22904(0.0, -3.5, 0.0);
        UtilitiesClient.drawInBatch((class_327)class_310.method_1551().field_1772, (class_5481)roundelText, (float)((float)(-textWidth) / 2.0f), (float)0.0f, (int)this.textColor, (boolean)false, (Matrix4f)matrices.method_23760().method_23761(), (class_4597)immediate, (int)0, (int)190);
        matrices.method_22909();
    }
}

