/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.mtrsteamloco.render.ShadersModHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Function;
import net.minecraft.class_310;

public class ClientConfig {
    private static Path path;
    public static boolean enableOptimization;
    public static boolean enableBbModelPreload;
    public static boolean translucentSort;
    public static boolean enableScriptDebugOverlay;
    public static boolean enableRail3D;
    public static boolean enableRailRender;
    public static boolean enableTrainRender;
    public static boolean enableTrainSound;
    public static boolean enableSmoke;
    public static boolean hideRidingTrain;

    public static void load(Path path) {
        ClientConfig.path = path;
        if (!Files.exists(path, new LinkOption[0])) {
            ClientConfig.save();
        }
        try {
            JsonObject configObject = Main.JSON_PARSER.parse(Files.readString(path)).getAsJsonObject();
            enableOptimization = ClientConfig.getOrDefault(configObject, "shaderCompatMode", JsonElement::getAsBoolean, false) == false;
            enableBbModelPreload = ClientConfig.getOrDefault(configObject, "enableBbModelPreload", JsonElement::getAsBoolean, false);
            translucentSort = ClientConfig.getOrDefault(configObject, "translucentSort", JsonElement::getAsBoolean, false);
            enableScriptDebugOverlay = ClientConfig.getOrDefault(configObject, "enableScriptDebugOverlay", JsonElement::getAsBoolean, false);
            enableRail3D = ClientConfig.getOrDefault(configObject, "enableRail3D", JsonElement::getAsBoolean, true);
            enableRailRender = ClientConfig.getOrDefault(configObject, "enableRailRender", JsonElement::getAsBoolean, true);
            enableTrainRender = ClientConfig.getOrDefault(configObject, "enableTrainRender", JsonElement::getAsBoolean, true);
            enableTrainSound = ClientConfig.getOrDefault(configObject, "enableTrainSound", JsonElement::getAsBoolean, true);
            enableSmoke = ClientConfig.getOrDefault(configObject, "enableSmoke", JsonElement::getAsBoolean, true);
            hideRidingTrain = ClientConfig.getOrDefault(configObject, "hideRidingTrain", JsonElement::getAsBoolean, false);
        }
        catch (Exception ex) {
            Main.LOGGER.warn("Failed loading client config:", (Throwable)ex);
            ClientConfig.save();
        }
    }

    private static <T> T getOrDefault(JsonObject jsonObject, String key, Function<JsonElement, T> getter, T defaultValue) {
        if (jsonObject.has(key)) {
            return getter.apply(jsonObject.get(key));
        }
        return defaultValue;
    }

    public static int getRailRenderLevel() {
        if (!ClientConfig.useRenderOptimization()) {
            return enableRailRender ? 1 : 0;
        }
        return enableRailRender ? (enableRail3D ? (ShadersModHandler.canInstance() ? 3 : 2) : 1) : 0;
    }

    public static boolean useRenderOptimization() {
        return enableOptimization && ShadersModHandler.canDrawWithBuffer();
    }

    public static void save() {
        try {
            if (path == null) {
                return;
            }
            JsonObject configObject = new JsonObject();
            configObject.addProperty("shaderCompatMode", Boolean.valueOf(!enableOptimization));
            configObject.addProperty("enableBbModelPreload", Boolean.valueOf(enableBbModelPreload));
            configObject.addProperty("translucentSort", Boolean.valueOf(translucentSort));
            configObject.addProperty("enableScriptDebugOverlay", Boolean.valueOf(enableScriptDebugOverlay));
            configObject.addProperty("enableRail3D", Boolean.valueOf(enableRail3D));
            configObject.addProperty("enableRailRender", Boolean.valueOf(enableRailRender));
            configObject.addProperty("enableTrainRender", Boolean.valueOf(enableTrainRender));
            configObject.addProperty("enableTrainSound", Boolean.valueOf(enableTrainSound));
            configObject.addProperty("enableSmoke", Boolean.valueOf(enableSmoke));
            configObject.addProperty("hideRidingTrain", Boolean.valueOf(hideRidingTrain));
            Files.writeString(path, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)configObject), new OpenOption[0]);
        }
        catch (Exception ex) {
            Main.LOGGER.warn("Failed loading client config:", (Throwable)ex);
        }
    }

    public static void load() {
        ClientConfig.load(class_310.method_1551().field_1697.toPath().resolve("config").resolve("mtrsteamloco.json"));
    }

    static {
        enableOptimization = true;
        enableBbModelPreload = false;
        translucentSort = false;
        enableScriptDebugOverlay = false;
        enableRail3D = true;
        enableRailRender = true;
        enableTrainRender = true;
        enableTrainSound = true;
        enableSmoke = true;
        hideRidingTrain = false;
    }
}

