/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco;

import fabric.cn.zbx1425.mtrsteamloco.ClientConfig;
import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.mtrsteamloco.MainClient;
import fabric.cn.zbx1425.mtrsteamloco.data.EyeCandyRegistry;
import fabric.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import fabric.cn.zbx1425.mtrsteamloco.data.ScriptedCustomTrains;
import fabric.cn.zbx1425.mtrsteamloco.mixin.TrainClientAccessor;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.ScriptContextManager;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.ScriptHolder;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.ScriptResourceUtil;
import fabric.cn.zbx1425.mtrsteamloco.render.train.NoopTrainRenderer;
import fabric.cn.zbx1425.mtrsteamloco.render.train.RenderTrainD51;
import fabric.cn.zbx1425.mtrsteamloco.render.train.RenderTrainDK3;
import fabric.cn.zbx1425.mtrsteamloco.render.train.RenderTrainDK3Mini;
import fabric.cn.zbx1425.mtrsteamloco.sound.DwellTimeBveTrainSound;
import fabric.cn.zbx1425.mtrsteamloco.sound.NoopTrainSound;
import java.io.IOException;
import java.util.HashMap;
import mtr.client.ClientData;
import mtr.client.TrainClientRegistry;
import mtr.client.TrainProperties;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.render.TrainRendererBase;
import mtr.sound.TrainSoundBase;
import mtr.sound.bve.BveTrainSoundConfig;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3300;

public class CustomResources {
    public static void reset(class_3300 resourceManager) {
        try {
            MainClient.drawScheduler.reloadShaders(resourceManager);
        }
        catch (IOException e) {
            Main.LOGGER.error("Failed loading shader:", (Throwable)e);
        }
        MainClient.modelManager.clear();
        MainClient.atlasManager.clear();
    }

    public static void init(class_3300 resourceManager) {
        Main.LOGGER.info("MTR-NTE has started loading custom resources.");
        EyeCandyRegistry.reload(resourceManager);
        RailModelRegistry.reload(resourceManager);
        ScriptHolder.resetRunner();
        ScriptResourceUtil.init(resourceManager);
        ScriptedCustomTrains.init(resourceManager);
        RenderTrainD51.initGLModel(resourceManager);
        RenderTrainDK3.initGLModel(resourceManager);
        RenderTrainDK3Mini.initGLModel(resourceManager);
        Main.LOGGER.info("MTR-NTE: Uploaded Models: " + MainClient.modelManager.uploadedVertArrays.size() + " (" + MainClient.modelManager.vaoCount + " VAOs, " + MainClient.modelManager.vboCount + " VBOs)");
        TrainClientRegistry.register((String)"dk3", (TrainProperties)new TrainProperties("train_20_2", (class_2561)Text.translatable((String)"train.mtrsteamloco.dk3", (Object[])new Object[0]), Text.translatable((String)"train.mtrsteamloco.dk3.description", (Object[])new Object[0]).getString(), "", 7377151, 0.0f, 0.0f, 6.0f, false, false, (TrainRendererBase)new RenderTrainDK3(null), (TrainSoundBase)new DwellTimeBveTrainSound(new BveTrainSoundConfig(resourceManager, "mtrsteamloco:dk3"))));
        TrainClientRegistry.register((String)"dk3_mini", (TrainProperties)new TrainProperties("train_9_2", (class_2561)Text.translatable((String)"train.mtrsteamloco.dk3_mini", (Object[])new Object[0]), Text.translatable((String)"train.mtrsteamloco.dk3.description", (Object[])new Object[0]).getString(), "", 7377151, 0.0f, 0.0f, 2.0f, false, false, (TrainRendererBase)new RenderTrainDK3Mini(null), (TrainSoundBase)new DwellTimeBveTrainSound(new BveTrainSoundConfig(resourceManager, "mtrsteamloco:dk3"))));
        HashMap<String, TrainProperties> existingTrains19m = new HashMap<String, TrainProperties>();
        TrainClientRegistry.forEach((TransportMode)TransportMode.TRAIN, (key, prop) -> {
            if (prop.baseTrainType.equals("train_19_2") || key.equals("dk3")) {
                existingTrains19m.put((String)key, (TrainProperties)prop);
            }
        });
        TrainClientRegistry.register((String)"d51", (TrainProperties)new TrainProperties("train_19_2", (class_2561)Text.translatable((String)"train.mtrsteamloco.d51", (Object[])new Object[0]), Text.translatable((String)"train.mtrsteamloco.d51.description", (Object[])new Object[0]).getString(), "", 0x808080, 0.0f, 0.0f, 6.0f, false, false, (TrainRendererBase)new RenderTrainD51(null), (TrainSoundBase)new DwellTimeBveTrainSound(new BveTrainSoundConfig(resourceManager, "mtrsteamloco:d51"))));
        existingTrains19m.forEach((key, prop) -> TrainClientRegistry.register((String)("d51_" + key), (TrainProperties)new TrainProperties("train_19_2", (class_2561)Text.literal((String)("D51 + " + prop.name.getString())), Text.translatable((String)"train.mtrsteamloco.d51.description", (Object[])new Object[0]).getString() + (String)(prop.description != null ? "\n\n" + prop.description : ""), "", prop.color, 0.0f, 0.0f, prop.bogiePosition, false, false, (TrainRendererBase)new RenderTrainD51(prop.renderer), (TrainSoundBase)new DwellTimeBveTrainSound(new BveTrainSoundConfig(resourceManager, "mtrsteamloco:d51")))));
    }

    public static void resetTrainComponents() {
        ClientData.TRAINS.forEach(train -> {
            train.isRemoved = true;
        });
        class_310.method_1551().method_1483().method_18670(false);
        ScriptContextManager.disposeDeadContexts();
        ClientData.TRAINS.forEach(train -> {
            train.isRemoved = false;
            if (ClientConfig.enableTrainRender) {
                TrainRendererBase renderer = TrainClientRegistry.getTrainProperties((String)train.trainId).renderer;
                ((TrainClientAccessor)train).setTrainRenderer(renderer.createTrainInstance(train));
            } else {
                ((TrainClientAccessor)train).setTrainRenderer(NoopTrainRenderer.INSTANCE);
            }
            if (ClientConfig.enableTrainSound) {
                TrainSoundBase sound = TrainClientRegistry.getTrainProperties((String)train.trainId).sound;
                ((TrainClientAccessor)train).setTrainSound(sound.createTrainInstance(train));
            } else {
                ((TrainClientAccessor)train).setTrainSound(NoopTrainSound.INSTANCE);
            }
        });
    }
}

