/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco;

import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.mtrsteamloco.MainClient;
import fabric.cn.zbx1425.mtrsteamloco.data.EyeCandyProperties;
import fabric.cn.zbx1425.mtrsteamloco.data.EyeCandyRegistry;
import fabric.cn.zbx1425.mtrsteamloco.render.integration.TrainModelCapture;
import fabric.cn.zbx1425.sowcerext.model.ModelCluster;
import fabric.cn.zbx1425.sowcerext.model.RawModel;
import fabric.cn.zbx1425.sowcerext.model.loader.NmbModelLoader;
import fabric.cn.zbx1425.sowcerext.model.loader.ObjModelLoader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import mtr.client.TrainClientRegistry;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelSimpleTrainBase;
import mtr.render.JonModelTrainRenderer;
import mtr.render.TrainRendererBase;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.apache.commons.io.FilenameUtils;

public class Debug {
    public static void saveAllBuiltinModels(Path outputDir) {
        TrainClientRegistry.forEach((TransportMode)TransportMode.TRAIN, (trainId, trainProperties) -> {
            block12: {
                TrainRendererBase patt1254$temp = trainProperties.renderer;
                if (patt1254$temp instanceof JonModelTrainRenderer) {
                    JonModelTrainRenderer renderer = (JonModelTrainRenderer)patt1254$temp;
                    if (renderer.model != null && renderer.textureId != null && renderer.model instanceof ModelSimpleTrainBase) {
                        try {
                            List resources;
                            String textureName = FilenameUtils.getBaseName((String)renderer.textureId);
                            TrainModelCapture.CaptureResult result = TrainModelCapture.captureModels(renderer.model, new class_2960(renderer.textureId + ".png"));
                            result.getNamedModels().values().forEach(RawModel::distinct);
                            ObjModelLoader.saveModels(result.getNamedModels(), outputDir.resolve(trainId + ".obj"), outputDir.resolve(textureName + ".mtl"), false);
                            if (Files.exists(outputDir.resolve(textureName + ".png"), new LinkOption[0]) || (resources = UtilitiesClient.getResources((class_3300)class_310.method_1551().method_1478(), (class_2960)new class_2960(renderer.textureId + ".png"))).isEmpty()) break block12;
                            try (InputStream is = Utilities.getInputStream((class_3298)((class_3298)resources.get(0)));){
                                Files.copy(is, outputDir.resolve(textureName + ".png"), new CopyOption[0]);
                            }
                            catch (IOException ex) {
                                Main.LOGGER.warn("Failed to save texture for " + trainId + ": ", (Throwable)ex);
                            }
                        }
                        catch (IOException ex) {
                            Main.LOGGER.warn("Failed to save model for " + trainId, (Throwable)ex);
                        }
                    }
                }
            }
        });
    }

    public static void saveAllLoadedModels(Path outputDir) {
        for (Map.Entry<class_2960, RawModel> pair : MainClient.modelManager.loadedRawModels.entrySet()) {
            Path path = Paths.get(outputDir.toString(), pair.getKey().method_12836(), pair.getKey().method_12832());
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                FileOutputStream fos = new FileOutputStream(FilenameUtils.removeExtension((String)path.toString()) + ".nmb");
                NmbModelLoader.serializeModel(pair.getValue(), fos, false);
                fos.close();
            }
            catch (IOException e) {
                Main.LOGGER.error("Failed exporting models:", (Throwable)e);
            }
        }
    }

    public static void registerAllModelsAsEyeCandy() {
        for (Map.Entry<class_2960, ModelCluster> entry : MainClient.modelManager.uploadedVertArrays.entrySet()) {
            String key = FilenameUtils.getBaseName((String)entry.getKey().method_12832());
            EyeCandyRegistry.register(key, new EyeCandyProperties((class_2561)Text.literal((String)key), entry.getValue()));
        }
    }
}

