/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.mtrsteamloco.render.integration.MtrModelRegistryUtil;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.ScriptHolder;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.train.ScriptedTrainRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.client.ICustomResources;
import mtr.client.IResourcePackCreatorProperties;
import mtr.client.TrainClientRegistry;
import mtr.client.TrainProperties;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.render.TrainRendererBase;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class ScriptedCustomTrains
implements IResourcePackCreatorProperties,
ICustomResources {
    public static void init(class_3300 resourceManager) {
        ScriptedCustomTrains.readResource(resourceManager, "mtr:mtr_custom_resources.json", jsonConfig -> {
            try {
                jsonConfig.get("custom_trains").getAsJsonObject().entrySet().forEach(entry -> {
                    try {
                        int i;
                        JsonObject jsonObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                        if (!jsonObject.has("script_files") && !jsonObject.has("script_texts")) {
                            return;
                        }
                        String trainId = "mtr_custom_train_" + (String)entry.getKey();
                        TrainProperties prevTrainProp = TrainClientRegistry.getTrainProperties((String)trainId);
                        if (prevTrainProp.baseTrainType.isEmpty()) {
                            return;
                        }
                        boolean isJacobsBogie = ScriptedCustomTrains.getOrDefault(jsonObject, "is_jacobs_bogie", prevTrainProp.isJacobsBogie, JsonElement::getAsBoolean);
                        float bogiePosition = ScriptedCustomTrains.getOrDefault(jsonObject, "bogie_position", Float.valueOf(prevTrainProp.bogiePosition), JsonElement::getAsFloat).floatValue();
                        ScriptHolder scriptContext = new ScriptHolder();
                        Object2ObjectArrayMap scripts = new Object2ObjectArrayMap();
                        if (jsonObject.has("script_texts")) {
                            JsonArray scriptTexts = jsonObject.get("script_texts").getAsJsonArray();
                            for (i = 0; i < scriptTexts.size(); ++i) {
                                scripts.put(new class_2960("mtrsteamloco", "script_texts/" + trainId + "/" + i), scriptTexts.get(i).getAsString());
                            }
                        }
                        if (jsonObject.has("script_files")) {
                            JsonArray scriptFiles = jsonObject.get("script_files").getAsJsonArray();
                            for (i = 0; i < scriptFiles.size(); ++i) {
                                class_2960 scriptLocation = new class_2960(scriptFiles.get(i).getAsString());
                                scripts.put(scriptLocation, null);
                            }
                        }
                        scriptContext.load("Train " + (String)entry.getKey(), "Train", resourceManager, (Map<class_2960, String>)scripts);
                        boolean dummyBaseTrain = jsonObject.has("base_type");
                        String baseTrainType = dummyBaseTrain ? jsonObject.get("base_type").getAsString() : prevTrainProp.baseTrainType;
                        boolean hasGangwayConnection = ScriptedCustomTrains.getOrDefault(jsonObject, "has_gangway_connection", dummyBaseTrain || prevTrainProp.hasGangwayConnection, JsonElement::getAsBoolean);
                        ScriptedTrainRenderer newRenderer = new ScriptedTrainRenderer(scriptContext, dummyBaseTrain ? null : prevTrainProp.renderer);
                        TrainClientRegistry.register((String)trainId, (TrainProperties)new TrainProperties(baseTrainType, prevTrainProp.name, prevTrainProp.description, prevTrainProp.wikipediaArticle, prevTrainProp.color, prevTrainProp.riderOffset, prevTrainProp.riderOffsetDismounting, bogiePosition, isJacobsBogie, hasGangwayConnection, (TrainRendererBase)newRenderer, prevTrainProp.sound));
                    }
                    catch (Exception ex) {
                        Main.LOGGER.error("Reading scripted custom train", (Throwable)ex);
                        MtrModelRegistryUtil.recordLoadingError("Failed loading Scripted Custom Train", ex);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private static void readResource(class_3300 manager, String path, Consumer<JsonObject> callback) {
        try {
            UtilitiesClient.getResources((class_3300)manager, (class_2960)new class_2960(path)).forEach(resource -> {
                try (InputStream stream = Utilities.getInputStream((class_3298)resource);){
                    callback.accept(new JsonParser().parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject());
                }
                catch (Exception e) {
                    Main.LOGGER.error("On behalf of MTR: Parsing JSON " + path, (Throwable)e);
                }
                try {
                    Utilities.closeResource((class_3298)resource);
                }
                catch (IOException e) {
                    Main.LOGGER.error("On behalf of MTR: Closing resource " + path, (Throwable)e);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static <T> T getOrDefault(JsonObject jsonObject, String key, T defaultValue, Function<JsonElement, T> function) {
        if (jsonObject.has(key)) {
            return function.apply(jsonObject.get(key));
        }
        return defaultValue;
    }
}

