/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.gui;

import com.mojang.datafixers.util.Pair;
import fabric.cn.zbx1425.mtrsteamloco.data.RailExtraSupplier;
import fabric.cn.zbx1425.mtrsteamloco.data.RailModelProperties;
import fabric.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import fabric.cn.zbx1425.mtrsteamloco.gui.SelectListScreen;
import fabric.cn.zbx1425.mtrsteamloco.gui.WidgetLabel;
import fabric.cn.zbx1425.mtrsteamloco.network.PacketUpdateHoldingItem;
import fabric.cn.zbx1425.mtrsteamloco.network.PacketUpdateRail;
import fabric.cn.zbx1425.mtrsteamloco.render.RailPicker;
import java.util.List;
import java.util.function.Consumer;
import mtr.Items;
import mtr.client.IDrawing;
import mtr.data.Rail;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class BrushEditRailScreen
extends SelectListScreen {
    private boolean isSelectingModel = false;
    private static final String INSTRUCTION_LINK = "https://www.zbx1425.cn/nautilus/mtr-nte/#/railmodel";
    private final WidgetLabel lblInstruction = new WidgetLabel(0, 0, 0, (class_2561)Text.translatable((String)"gui.mtrsteamloco.eye_candy.tip_resource_pack", (Object[])new Object[0]), () -> this.field_22787.method_1507((class_437)new class_407(bl -> {
        if (bl) {
            class_156.method_668().method_670(INSTRUCTION_LINK);
        }
        this.field_22787.method_1507((class_437)this);
    }, INSTRUCTION_LINK, true)));
    private static Rail pickedRail = null;
    private static class_2338 pickedPosStart = class_2338.field_10980;
    private static class_2338 pickedPosEnd = class_2338.field_10980;
    class_4185 btnSetDefaultRadius = UtilitiesClient.newButton((class_2561)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.vertical_curve_radius_set_max", (Object[])new Object[0]), sender -> this.updateRadius(0.0f, true));
    class_4185 btnSetNoRadius = UtilitiesClient.newButton((class_2561)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.vertical_curve_radius_set_none", (Object[])new Object[0]), sender -> this.updateRadius(-1.0f, true));
    WidgetLabel valuesLabel = new WidgetLabel(20, 146, this.field_22789 - 40, (class_2561)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.vertical_curve_radius_irl_ref", (Object[])new Object[0]));
    WidgetBetterTextField radiusInput = new WidgetBetterTextField("", 8);

    public BrushEditRailScreen() {
        super((class_2561)Text.literal((String)"Select rail arguments"));
        if (pickedRail == null) {
            BrushEditRailScreen.acquirePickInfoWhenUse();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.loadPage();
    }

    @Override
    protected void loadPage() {
        this.method_37067();
        if (this.isSelectingModel) {
            class_2487 brushTag = this.getBrushTag();
            String modelKey = brushTag == null ? "" : brushTag.method_10558("ModelKey");
            this.scrollList.field_22764 = true;
            this.loadSelectPage(key -> !key.equals(modelKey));
            this.lblInstruction.alignR = true;
            IDrawing.setPositionAndWidth((class_339)this.lblInstruction, (int)(this.field_22789 / 2 + 20), (int)(this.field_22790 - 20 - 8), (int)0);
            this.lblInstruction.method_25358(this.field_22789 / 2 - 40);
            this.method_37063((class_364)this.lblInstruction);
        } else {
            this.scrollList.field_22764 = false;
            this.loadMainPage();
        }
    }

    @Override
    protected void onBtnClick(String btnKey) {
        this.updateBrushTag(compoundTag -> compoundTag.method_10582("ModelKey", btnKey));
    }

    private void loadMainPage() {
        class_2487 brushTag = this.getBrushTag();
        this.method_37063((class_364)new WidgetLabel(20, 22, this.field_22789 - 40, (class_2561)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.brush_hint", (Object[])new Object[0])));
        boolean enableModelKey = brushTag != null && brushTag.method_10545("ModelKey");
        String modelKey = ((RailExtraSupplier)pickedRail).getModelKey();
        ((WidgetBetterCheckbox)this.method_37063((class_364)new WidgetBetterCheckbox(20, 40, 160, 20, (class_2561)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.enable_model_key", (Object[])new Object[0]), checked -> {
            this.updateBrushTag(compoundTag -> {
                if (checked) {
                    compoundTag.method_10582("ModelKey", modelKey);
                } else {
                    compoundTag.method_10551("ModelKey");
                }
            });
            this.loadPage();
        }))).setChecked(enableModelKey);
        if (enableModelKey) {
            RailModelProperties properties = RailModelRegistry.elements.get(modelKey);
            IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)UtilitiesClient.newButton((class_2561)(properties != null ? properties.name : Text.literal((String)(modelKey + " (???)"))), sender -> {
                this.isSelectingModel = true;
                this.loadPage();
            }))), (int)20, (int)60, (int)240);
        }
        boolean enableVertCurveRadius = brushTag != null && brushTag.method_10545("VerticalCurveRadius");
        float vertCurveRadius = ((RailExtraSupplier)pickedRail).getVerticalCurveRadius();
        ((WidgetBetterCheckbox)this.method_37063((class_364)new WidgetBetterCheckbox(20, 100, 160, 20, (class_2561)Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.enable_vertical_curve_radius", (Object[])new Object[0]), checked -> {
            this.updateBrushTag(compoundTag -> {
                if (checked) {
                    compoundTag.method_10548("VerticalCurveRadius", vertCurveRadius);
                } else {
                    compoundTag.method_10551("VerticalCurveRadius");
                }
            });
            this.loadPage();
        }))).setChecked(enableVertCurveRadius);
        if (enableVertCurveRadius) {
            this.updateRadius(vertCurveRadius, false);
            this.radiusInput.method_1863(text -> {
                if (!text.isEmpty()) {
                    try {
                        float newRadius = Float.parseFloat(text);
                        Rail rail = pickedRail;
                        if (rail != null) {
                            double maxRadius;
                            int H = Math.abs(((RailExtraSupplier)rail).getHeight());
                            double L = rail.getLength();
                            double d = maxRadius = H == 0 ? 0.0 : ((double)(H * H) + L * L) / (double)(H * 4);
                            if ((double)newRadius < maxRadius) {
                                this.radiusInput.method_1868(0xE0E0E0);
                            } else {
                                this.radiusInput.method_1868(0xEEEE00);
                            }
                        } else {
                            this.radiusInput.method_1868(0xEEEE00);
                        }
                        this.updateRadius(newRadius, true);
                    }
                    catch (Exception ignored) {
                        this.radiusInput.method_1868(0xFF0000);
                    }
                }
            });
            IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)this.radiusInput)), (int)20, (int)120, (int)160);
            IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)this.btnSetDefaultRadius)), (int)180, (int)120, (int)80);
            IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)this.btnSetNoRadius)), (int)260, (int)120, (int)80);
            this.valuesLabel.method_25358(this.field_22789 - 40);
            this.method_37063((class_364)this.valuesLabel);
        }
    }

    private void updateRadius(float newRadius, boolean send) {
        this.valuesLabel.method_25355((class_2561)Text.literal((String)this.getVerticalValueText(newRadius)));
        this.btnSetDefaultRadius.field_22763 = newRadius != 0.0f;
        this.btnSetNoRadius.field_22763 = newRadius >= 0.0f;
        String expectedText = newRadius <= 0.0f ? "" : Integer.toString((int)newRadius);
        if (!expectedText.equals(this.radiusInput.method_1882())) {
            this.radiusInput.method_1852(expectedText);
            this.radiusInput.method_1870();
        }
        if (send) {
            this.updateBrushTag(compoundTag -> compoundTag.method_10548("VerticalCurveRadius", newRadius));
        }
    }

    private String getVerticalValueText(float verticalRadius) {
        double maxRadius;
        Rail rail = pickedRail;
        if (rail == null) {
            return "(???)";
        }
        int H = Math.abs(((RailExtraSupplier)rail).getHeight());
        double L = rail.getLength();
        double d = maxRadius = H == 0 ? 0.0 : ((double)(H * H) + L * L) / (double)(H * 4);
        double gradient = verticalRadius < 0.0f ? (double)H / L * 1000.0 : (verticalRadius == 0.0f || (double)verticalRadius > maxRadius ? Math.tan(RailExtraSupplier.getVTheta(rail, maxRadius)) * 1000.0 : Math.tan(RailExtraSupplier.getVTheta(rail, verticalRadius)) * 1000.0);
        return Text.translatable((String)"gui.mtrsteamloco.brush_edit_rail.vertical_curve_radius_values", (Object[])new Object[]{String.format("%.1f", maxRadius), String.format("%.1f", gradient)}).getString();
    }

    @Override
    protected List<Pair<String, String>> getRegistryEntries() {
        return RailModelRegistry.elements.entrySet().stream().filter(e -> !((RailModelProperties)e.getValue()).name.getString().isEmpty()).map(e -> new Pair((Object)((String)e.getKey()), (Object)((RailModelProperties)e.getValue()).name.getString())).toList();
    }

    private class_2487 getBrushTag() {
        if (class_310.method_1551().field_1724 == null) {
            return null;
        }
        class_1799 brushItem = class_310.method_1551().field_1724.method_6047();
        if (!brushItem.method_31574((class_1792)Items.BRUSH.get())) {
            return null;
        }
        class_2487 nteTag = brushItem.method_7941("NTERailBrush");
        return nteTag;
    }

    private void updateBrushTag(Consumer<class_2487> modifier) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        class_1799 brushItem = class_310.method_1551().field_1724.method_6047();
        if (!brushItem.method_31574((class_1792)Items.BRUSH.get())) {
            return;
        }
        class_2487 nteTag = brushItem.method_7911("NTERailBrush");
        modifier.accept(nteTag);
        BrushEditRailScreen.applyBrushToPickedRail(nteTag, false);
        PacketUpdateHoldingItem.sendUpdateC2S();
    }

    public static void acquirePickInfoWhenUse() {
        pickedRail = RailPicker.pickedRail;
        pickedPosStart = RailPicker.pickedPosStart;
        pickedPosEnd = RailPicker.pickedPosEnd;
    }

    public static void applyBrushToPickedRail(class_2487 railBrushProp, boolean isBatchApply) {
        if (railBrushProp == null) {
            return;
        }
        if (pickedRail == null) {
            return;
        }
        RailExtraSupplier pickedExtra = (RailExtraSupplier)pickedRail;
        boolean propertyUpdated = false;
        if (railBrushProp.method_10545("ModelKey") && !railBrushProp.method_10558("ModelKey").equals(pickedExtra.getModelKey())) {
            pickedExtra.setModelKey(railBrushProp.method_10558("ModelKey"));
            propertyUpdated = true;
        }
        if (railBrushProp.method_10545("VerticalCurveRadius") && railBrushProp.method_10583("VerticalCurveRadius") != pickedExtra.getVerticalCurveRadius()) {
            pickedExtra.setVerticalCurveRadius(railBrushProp.method_10583("VerticalCurveRadius"));
            propertyUpdated = true;
        }
        if (isBatchApply && !propertyUpdated) {
            pickedExtra.setRenderReversed(!pickedExtra.getRenderReversed());
        }
        PacketUpdateRail.sendUpdateC2S(pickedRail, pickedPosStart, pickedPosEnd);
    }

    public void method_25394(class_4587 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.isSelectingModel) {
            this.renderSelectPage(guiGraphics);
        }
    }

    public void method_25419() {
        if (this.isSelectingModel) {
            this.isSelectingModel = false;
            this.loadPage();
        } else {
            this.field_22787.method_1507(null);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

