/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.gui;

import com.mojang.datafixers.util.Pair;
import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.mtrsteamloco.block.BlockEyeCandy;
import fabric.cn.zbx1425.mtrsteamloco.data.EyeCandyProperties;
import fabric.cn.zbx1425.mtrsteamloco.data.EyeCandyRegistry;
import fabric.cn.zbx1425.mtrsteamloco.gui.SelectListScreen;
import fabric.cn.zbx1425.mtrsteamloco.gui.WidgetLabel;
import fabric.cn.zbx1425.mtrsteamloco.gui.WidgetSlider;
import fabric.cn.zbx1425.mtrsteamloco.network.PacketUpdateBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mtr.client.IDrawing;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterCheckbox;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class EyeCandyScreen
extends SelectListScreen {
    private boolean isSelectingModel = false;
    private static final String INSTRUCTION_LINK = "https://www.zbx1425.cn/nautilus/mtr-nte/#/eyecandy";
    private final WidgetLabel lblInstruction = new WidgetLabel(0, 0, 0, (class_2561)Text.translatable((String)"gui.mtrsteamloco.eye_candy.tip_resource_pack", (Object[])new Object[0]), () -> this.field_22787.method_1507((class_437)new class_407(bl -> {
        if (bl) {
            class_156.method_668().method_670(INSTRUCTION_LINK);
        }
        this.field_22787.method_1507((class_437)this);
    }, INSTRUCTION_LINK, true)));
    private final class_2338 editingBlockPos;

    public EyeCandyScreen(class_2338 blockPos) {
        super((class_2561)Text.literal((String)"Select EyeCandy"));
        this.editingBlockPos = blockPos;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.loadPage();
    }

    public void method_25394(@NotNull class_4587 guiGraphics, int i, int j, float f) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, i, j, f);
        if (this.isSelectingModel) {
            super.renderSelectPage(guiGraphics);
        }
    }

    @Override
    protected void loadPage() {
        this.method_37067();
        Optional<BlockEyeCandy.BlockEntityEyeCandy> optionalBlockEntity = this.getBlockEntity();
        if (optionalBlockEntity.isEmpty()) {
            this.method_25419();
            return;
        }
        BlockEyeCandy.BlockEntityEyeCandy blockEntity = optionalBlockEntity.get();
        if (this.isSelectingModel) {
            this.scrollList.field_22764 = true;
            this.loadSelectPage(key -> !key.equals(blockEntity.prefabId));
            this.lblInstruction.alignR = true;
            IDrawing.setPositionAndWidth((class_339)this.lblInstruction, (int)(this.field_22789 / 2 + 20), (int)(this.field_22790 - 20 - 8), (int)0);
            this.lblInstruction.method_25358(this.field_22789 / 2 - 40);
            this.method_37063((class_364)this.lblInstruction);
        } else {
            this.scrollList.field_22764 = false;
            this.loadMainPage(blockEntity);
        }
    }

    @Override
    protected void onBtnClick(String btnKey) {
        this.updateBlockEntity(blockEntity -> {
            blockEntity.prefabId = btnKey;
        });
    }

    @Override
    protected List<Pair<String, String>> getRegistryEntries() {
        return EyeCandyRegistry.elements.entrySet().stream().map(e -> new Pair((Object)((String)e.getKey()), (Object)((EyeCandyProperties)e.getValue()).name.getString())).toList();
    }

    private void loadMainPage(BlockEyeCandy.BlockEntityEyeCandy blockEntity) {
        EyeCandyProperties properties = EyeCandyRegistry.elements.get(blockEntity.prefabId);
        IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)UtilitiesClient.newButton((class_2561)(properties != null ? properties.name : Text.literal((String)(blockEntity.prefabId + " (???)"))), sender -> {
            this.isSelectingModel = true;
            this.loadPage();
        }))), (int)20, (int)20, (int)240);
        IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)new WidgetSlider(40, Math.round(blockEntity.translateX * 100.0f / 5.0f) + 20, value -> {
            this.updateBlockEntity(be -> {
                be.translateX = (float)(value - 20) * 5.0f / 100.0f;
            });
            return "TX " + (value - 20) * 5 + "cm";
        }))), (int)20, (int)60, (int)((this.field_22789 - 40) / 3));
        IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)new WidgetSlider(40, Math.round(blockEntity.translateY * 100.0f / 5.0f) + 20, value -> {
            this.updateBlockEntity(be -> {
                be.translateY = (float)(value - 20) * 5.0f / 100.0f;
            });
            return "TY " + (value - 20) * 5 + "cm";
        }))), (int)(20 + (this.field_22789 - 40) / 3), (int)60, (int)((this.field_22789 - 40) / 3));
        IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)new WidgetSlider(40, Math.round(blockEntity.translateZ * 100.0f / 5.0f) + 20, value -> {
            this.updateBlockEntity(be -> {
                be.translateZ = (float)(value - 20) * 5.0f / 100.0f;
            });
            return "TZ " + (value - 20) * 5 + "cm";
        }))), (int)(20 + (this.field_22789 - 40) / 3 * 2), (int)60, (int)((this.field_22789 - 40) / 3));
        IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)new WidgetSlider(36, (int)Math.round(Math.toDegrees(blockEntity.rotateX) / 5.0) + 18, value -> {
            this.updateBlockEntity(be -> {
                be.rotateX = (float)Math.toRadians((float)(value - 18) * 5.0f);
            });
            return "RX " + (value - 18) * 5 + "\u00b0";
        }))), (int)20, (int)80, (int)((this.field_22789 - 40) / 3));
        IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)new WidgetSlider(36, (int)Math.round(Math.toDegrees(blockEntity.rotateY) / 5.0) + 18, value -> {
            this.updateBlockEntity(be -> {
                be.rotateY = (float)Math.toRadians((float)(value - 18) * 5.0f);
            });
            return "RY " + (value - 18) * 5 + "\u00b0";
        }))), (int)(20 + (this.field_22789 - 40) / 3), (int)80, (int)((this.field_22789 - 40) / 3));
        IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)new WidgetSlider(36, (int)Math.round(Math.toDegrees(blockEntity.rotateZ) / 5.0) + 18, value -> {
            this.updateBlockEntity(be -> {
                be.rotateZ = (float)Math.toRadians((float)(value - 18) * 5.0f);
            });
            return "RZ " + (value - 18) * 5 + "\u00b0";
        }))), (int)(20 + (this.field_22789 - 40) / 3 * 2), (int)80, (int)((this.field_22789 - 40) / 3));
        ((WidgetBetterCheckbox)this.method_37063((class_364)new WidgetBetterCheckbox(20, 120, 160, 20, (class_2561)Text.translatable((String)"gui.mtrsteamloco.eye_candy.full_light", (Object[])new Object[0]), checked -> this.updateBlockEntity(be -> {
            be.fullLight = checked;
        })))).setChecked(blockEntity.fullLight);
        IDrawing.setPositionAndWidth((class_339)((class_339)this.method_37063((class_364)UtilitiesClient.newButton((class_2561)Text.literal((String)"X"), sender -> this.method_25419()))), (int)(this.field_22789 - 40), (int)(this.field_22790 - 40), (int)20);
    }

    private void updateBlockEntity(Consumer<BlockEyeCandy.BlockEntityEyeCandy> modifier) {
        this.getBlockEntity().ifPresent(blockEntity -> {
            modifier.accept((BlockEyeCandy.BlockEntityEyeCandy)((Object)blockEntity));
            PacketUpdateBlockEntity.sendUpdateC2S((BlockEntityMapper)blockEntity);
        });
    }

    private Optional<BlockEyeCandy.BlockEntityEyeCandy> getBlockEntity() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return Optional.empty();
        }
        return level.method_35230(this.editingBlockPos, (class_2591)Main.BLOCK_ENTITY_TYPE_EYE_CANDY.get());
    }

    public void method_25419() {
        if (this.isSelectingModel) {
            this.isSelectingModel = false;
            this.loadPage();
        } else {
            this.field_22787.method_1507(null);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

