/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.gui;

import com.google.common.base.Splitter;
import com.mojang.blaze3d.systems.RenderSystem;
import fabric.cn.zbx1425.mtrsteamloco.ClientConfig;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.AbstractScriptContext;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.ScriptContextManager;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.ScriptHolder;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.util.GraphicsTexture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class ScriptDebugOverlay {
    public static void render(class_4587 vdStuff) {
        class_4587 matrices = vdStuff;
        if (!ClientConfig.enableScriptDebugOverlay) {
            return;
        }
        if (class_310.method_1551().field_1755 != null) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(10.0f, 10.0f, 0.0f);
        HashMap<ScriptHolder, List> contexts = new HashMap<ScriptHolder, List>();
        for (Map.Entry<AbstractScriptContext, ScriptHolder> entry : ScriptContextManager.livingContexts.entrySet()) {
            contexts.computeIfAbsent(entry.getValue(), k -> new ArrayList()).add(entry.getKey());
        }
        int y = 0;
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        int lineHeight = class_3532.method_15386((float)(9.0f * 1.2f));
        for (Map.Entry entry : contexts.entrySet()) {
            ScriptHolder holder = (ScriptHolder)entry.getKey();
            if (holder.failTime > 0L) {
                ScriptDebugOverlay.drawText(vdStuff, font, holder.name + " FAILED", 0, y, -65536);
                y += lineHeight;
                for (String msgLine : Splitter.fixedLength((int)60).split((CharSequence)holder.failException.getMessage())) {
                    ScriptDebugOverlay.drawText(vdStuff, font, msgLine, 5, y, -30584);
                    y += lineHeight;
                }
            } else {
                ScriptDebugOverlay.drawText(vdStuff, font, holder.name, 0, y, -5592321);
                y += lineHeight;
            }
            for (AbstractScriptContext context : (List)entry.getValue()) {
                ScriptDebugOverlay.drawText(vdStuff, font, String.format("#%08X (%.2f ms)", context.hashCode(), (double)context.lastExecuteDuration / 1000.0), 10, y, -3355393);
                y += lineHeight;
                for (Map.Entry<String, Object> debugInfo : context.debugInfo.entrySet()) {
                    Object value = debugInfo.getValue();
                    if (value instanceof GraphicsTexture) {
                        GraphicsTexture texture = (GraphicsTexture)value;
                        float scale = (float)(class_310.method_1551().method_22683().method_4486() - 40) / (float)texture.width;
                        ScriptDebugOverlay.blit(vdStuff, texture.identifier, 20, y, (int)((float)texture.width * scale), (int)((float)texture.height * scale));
                        ScriptDebugOverlay.drawText(vdStuff, font, debugInfo.getKey() + ": GraphicsTexture", 20, y, -1);
                        y += (int)((float)texture.height * scale) + lineHeight / 2;
                        continue;
                    }
                    ScriptDebugOverlay.drawText(vdStuff, font, debugInfo.getKey() + ": " + debugInfo.getValue(), 20, y, -1);
                    y += lineHeight;
                }
            }
        }
        matrices.method_22909();
    }

    private static void drawText(class_4587 matrices, class_327 font, String text, int x, int y, int color) {
        font.method_1720(matrices, text, (float)x, (float)y, color);
    }

    private static void blit(class_4587 matrices, class_2960 texture, int x, int y, int width, int height) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        class_332.method_25293((class_4587)matrices, (int)x, (int)y, (int)width, (int)height, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
    }
}

