/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.mixin;

import fabric.cn.zbx1425.mtrsteamloco.ClientConfig;
import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.mtrsteamloco.data.RailExtraSupplier;
import fabric.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import fabric.cn.zbx1425.mtrsteamloco.render.rail.RailRenderDispatcher;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import mtr.data.MessagePackHelper;
import mtr.data.Rail;
import mtr.data.RailType;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Rail.class}, priority=1425)
public abstract class RailMixin
implements RailExtraSupplier {
    private String modelKey = "";
    private boolean isSecondaryDir = false;
    private float verticalCurveRadius = 0.0f;
    private final int NTE_PACKET_EXTRA_MAGIC = 622072869;
    @Shadow(remap=false)
    @Final
    private int yStart;
    @Shadow(remap=false)
    @Final
    private int yEnd;
    private float vTheta;
    private static final class_2540 hashBuilder = new class_2540(Unpooled.buffer());
    private byte[] dataBytes;
    private int hashCode;

    @Override
    public String getModelKey() {
        return this.modelKey;
    }

    @Override
    public void setModelKey(String key) {
        this.modelKey = key;
    }

    @Override
    public boolean getRenderReversed() {
        return this.isSecondaryDir;
    }

    @Override
    public void setRenderReversed(boolean value) {
        this.isSecondaryDir = value;
    }

    @Override
    public float getVerticalCurveRadius() {
        return this.verticalCurveRadius;
    }

    @Override
    public void setVerticalCurveRadius(float value) {
        this.verticalCurveRadius = value;
    }

    @Override
    public int getHeight() {
        return this.yEnd - this.yStart;
    }

    @Inject(method={"<init>(Ljava/util/Map;)V"}, at={@At(value="TAIL")}, remap=false)
    private void fromMessagePack(Map<String, Value> map, CallbackInfo ci) {
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.modelKey = messagePackHelper.getString("model_key", "");
        this.isSecondaryDir = messagePackHelper.getBoolean("is_secondary_dir", false);
        this.verticalCurveRadius = messagePackHelper.getFloat("vertical_curve_radius", 0.0f);
    }

    @Inject(method={"toMessagePack"}, at={@At(value="TAIL")}, remap=false)
    private void toMessagePack(MessagePacker messagePacker, CallbackInfo ci) throws IOException {
        messagePacker.packString("model_key").packString(this.modelKey);
        messagePacker.packString("is_secondary_dir").packBoolean(this.isSecondaryDir);
        messagePacker.packString("vertical_curve_radius").packFloat(this.verticalCurveRadius);
    }

    @Inject(method={"messagePackLength"}, at={@At(value="TAIL")}, cancellable=true, remap=false)
    private void messagePackLength(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)((Integer)cir.getReturnValue() + 3));
    }

    @Inject(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="TAIL")})
    private void fromPacket(class_2540 packet, CallbackInfo ci) {
        if (!Main.enableRegistry) {
            return;
        }
        if (packet.readableBytes() <= 4) {
            return;
        }
        if (packet.readInt() != 622072869) {
            packet.readerIndex(packet.readerIndex() - 4);
            return;
        }
        this.modelKey = packet.method_19772();
        this.isSecondaryDir = packet.readBoolean();
        this.verticalCurveRadius = packet.readFloat();
    }

    @Inject(method={"writePacket"}, at={@At(value="TAIL")})
    private void toPacket(class_2540 packet, CallbackInfo ci) {
        if (!Main.enableRegistry) {
            return;
        }
        packet.writeInt(622072869);
        packet.method_10814(this.modelKey);
        packet.writeBoolean(this.isSecondaryDir);
        packet.writeFloat(this.verticalCurveRadius);
    }

    @Redirect(method={"renderSegment"}, remap=false, at=@At(value="INVOKE", target="Ljava/lang/Math;round(D)J"))
    private long redirectRenderSegmentRound(double r) {
        if (ClientConfig.getRailRenderLevel() < 2) {
            return Math.round(r);
        }
        Rail instance = (Rail)this;
        if (instance.railType == RailType.NONE) {
            return Math.round(r);
        }
        return Math.round(r / (double)RailModelRegistry.getProperty((String)RailRenderDispatcher.getModelKeyForRender((Rail)instance)).repeatInterval);
    }

    @Inject(method={"getPositionY"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getPositionY(double rawValue, CallbackInfoReturnable<Double> cir) {
        double maxRadius;
        if (((Rail)this).railType.railSlopeStyle == RailType.RailSlopeStyle.CABLE) {
            return;
        }
        double H = Math.abs(this.yEnd - this.yStart);
        double L = ((Rail)this).getLength();
        int sign = this.yStart < this.yEnd ? 1 : -1;
        double d = maxRadius = H == 0.0 ? 0.0 : Math.abs((H * H + L * L) / (H * 4.0));
        if (this.verticalCurveRadius < 0.0f) {
            cir.setReturnValue((Object)((double)sign * (rawValue / L * H) + (double)this.yStart));
        } else if (this.verticalCurveRadius != 0.0f && !((double)this.verticalCurveRadius > maxRadius)) {
            if (this.vTheta == 0.0f) {
                this.vTheta = RailExtraSupplier.getVTheta((Rail)this, this.verticalCurveRadius);
            }
            if (!Double.isFinite(this.vTheta)) {
                return;
            }
            float curveL = class_3532.method_15374((float)this.vTheta) * this.verticalCurveRadius;
            float curveH = (1.0f - class_3532.method_15362((float)this.vTheta)) * this.verticalCurveRadius;
            if (rawValue < (double)curveL) {
                float r = (float)rawValue;
                cir.setReturnValue((Object)((double)sign * ((double)this.verticalCurveRadius - Math.sqrt(this.verticalCurveRadius * this.verticalCurveRadius - r * r)) + (double)this.yStart));
            } else if (rawValue > L - (double)curveL) {
                float r = (float)(L - rawValue);
                cir.setReturnValue((Object)((double)(-sign) * ((double)this.verticalCurveRadius - Math.sqrt(this.verticalCurveRadius * this.verticalCurveRadius - r * r)) + (double)this.yEnd));
            } else {
                cir.setReturnValue((Object)((double)sign * ((rawValue - (double)curveL) / (L - (double)(2.0f * curveL)) * (H - (double)(2.0f * curveH)) + (double)curveH) + (double)this.yStart));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.dataBytes == null) {
            this.createDataBytes();
        }
        if (((RailMixin)o).dataBytes == null) {
            ((RailMixin)o).createDataBytes();
        }
        return Arrays.equals(this.dataBytes, ((RailMixin)o).dataBytes);
    }

    public int hashCode() {
        if (this.dataBytes == null) {
            this.createDataBytes();
        }
        return this.hashCode;
    }

    private void createDataBytes() {
        hashBuilder.clear();
        ((Rail)this).writePacket(hashBuilder);
        this.dataBytes = new byte[hashBuilder.writerIndex()];
        hashBuilder.getBytes(0, this.dataBytes);
        this.hashCode = Arrays.hashCode(this.dataBytes);
    }
}

