/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.integration;

import fabric.cn.zbx1425.mtrsteamloco.mixin.ModelPartAccessor;
import fabric.cn.zbx1425.sowcer.batch.MaterialProp;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.model.Face;
import fabric.cn.zbx1425.sowcerext.model.RawMesh;
import fabric.cn.zbx1425.sowcerext.model.RawModel;
import fabric.cn.zbx1425.sowcerext.model.Vertex;
import java.util.Arrays;
import java.util.stream.IntStream;
import mtr.model.ModelTrainBase;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;

public class CapturingVertexConsumer
implements class_4588 {
    RawModel[] models = new RawModel[5];
    RawMesh[] buildingMeshes = new RawMesh[5];
    Vertex buildingVertex = new Vertex();

    public CapturingVertexConsumer() {
        Arrays.setAll(this.models, ignored -> new RawModel());
    }

    public void captureModelPart(class_630 modelPart) {
        CapturingVertexConsumer.dumpModelPartQuads(modelPart, new class_4587(), this, 0, 0);
    }

    public static void dumpModelPartQuads(class_630 modelPart, class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay) {
        if (!(!modelPart.field_3665 || ((ModelPartAccessor)modelPart).getCubes().isEmpty() && ((ModelPartAccessor)modelPart).getChildren().isEmpty())) {
            poseStack.method_22903();
            modelPart.method_22703(poseStack);
            for (class_630.class_628 cube : ((ModelPartAccessor)modelPart).getCubes()) {
                cube.method_32089(poseStack.method_23760(), vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            for (class_630 child : ((ModelPartAccessor)modelPart).getChildren().values()) {
                CapturingVertexConsumer.dumpModelPartQuads(child, poseStack, vertexConsumer, packedLight, packedOverlay);
            }
            poseStack.method_22909();
        }
    }

    public void beginStage(class_2960 texture, ModelTrainBase.RenderStage stage) {
        MaterialProp materialProp = new MaterialProp();
        materialProp.texture = texture;
        switch (stage) {
            case LIGHTS: {
                materialProp.shaderName = "rendertype_beacon_beam";
                materialProp.cutoutHack = true;
                break;
            }
            case ALWAYS_ON_LIGHTS: {
                materialProp.shaderName = "rendertype_beacon_beam";
                materialProp.translucent = true;
                materialProp.writeDepthBuf = false;
                break;
            }
            case EXTERIOR: {
                materialProp.shaderName = "rendertype_entity_cutout";
                break;
            }
            case INTERIOR: {
                materialProp.shaderName = "rendertype_entity_cutout";
                materialProp.attrState.setLightmapUV(0xF000F0);
                break;
            }
            case INTERIOR_TRANSLUCENT: {
                materialProp.shaderName = "rendertype_entity_translucent_cull";
                materialProp.translucent = true;
                materialProp.attrState.setLightmapUV(0xF000F0);
            }
        }
        for (int i = 0; i < this.models.length; ++i) {
            this.buildingMeshes[i] = this.models[i].meshList.computeIfAbsent(materialProp, RawMesh::new);
        }
    }

    public void reset() {
        Arrays.setAll(this.models, ignored -> new RawModel());
        Arrays.fill(this.buildingMeshes, null);
        this.buildingVertex = new Vertex();
    }

    @NotNull
    public class_4588 method_22912(double x, double y, double z) {
        this.buildingVertex.position = new Vector3f((float)x, (float)y, (float)z);
        return this;
    }

    @NotNull
    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        return this;
    }

    @NotNull
    public class_4588 method_22913(float u, float v) {
        this.buildingVertex.u = u;
        this.buildingVertex.v = v;
        return this;
    }

    @NotNull
    public class_4588 method_22917(int u, int v) {
        return this;
    }

    @NotNull
    public class_4588 method_22921(int u, int v) {
        return this;
    }

    @NotNull
    public class_4588 method_22914(float x, float y, float z) {
        this.buildingVertex.normal = new Vector3f(x, y, z);
        return this;
    }

    public void method_1344() {
        int meshToUse;
        if (Math.abs(this.buildingVertex.position.z()) > 1024.0f) {
            boolean xSign = this.buildingVertex.position.x() > 0.0f;
            boolean zSign = this.buildingVertex.position.z() > 0.0f;
            meshToUse = (xSign ? 0 : 2) + (zSign ? 0 : 1) + 1;
            this.buildingVertex.position.add(new Vector3f(0.0f, 0.0f, zSign ? -2048.0f : 2048.0f));
        } else {
            meshToUse = 0;
        }
        RawMesh buildingMesh = this.buildingMeshes[meshToUse];
        buildingMesh.vertices.add(this.buildingVertex);
        if (buildingMesh.vertices.size() % 4 == 0) {
            buildingMesh.faces.add(new Face(IntStream.range(buildingMesh.vertices.size() - 4, buildingMesh.vertices.size()).toArray()));
        }
        this.buildingVertex = new Vertex();
    }

    public void method_22901(int defaultR, int defaultG, int defaultB, int defaultA) {
    }

    public void method_35666() {
    }
}

