/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.integration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import fabric.cn.zbx1425.mtrsteamloco.ClientConfig;
import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.mtrsteamloco.MainClient;
import fabric.cn.zbx1425.mtrsteamloco.mixin.ModelMapperAccessor;
import fabric.cn.zbx1425.mtrsteamloco.render.integration.CapturingVertexConsumer;
import fabric.cn.zbx1425.mtrsteamloco.render.integration.MtrModelRegistryUtil;
import fabric.cn.zbx1425.mtrsteamloco.render.integration.SowcerModelAgent;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcer.util.GlStateTracker;
import fabric.cn.zbx1425.sowcerext.model.RawModel;
import fabric.cn.zbx1425.sowcerext.model.loader.ObjModelLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import mtr.client.DynamicTrainModel;
import mtr.client.ResourcePackCreatorProperties;
import mtr.data.EnumHelper;
import mtr.mappings.ModelMapper;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelTrainBase;
import mtr.render.RenderTrains;
import net.minecraft.class_2960;
import net.minecraft.class_630;
import org.apache.commons.lang3.StringUtils;

public class DynamicTrainModelLoader {
    private static Map<String, RawModel> cachedModels;
    private static String cachedPath;
    private static long cachedPathMtime;

    public static void loadInto(JsonObject model, DynamicTrainModel target) {
        if (MtrModelRegistryUtil.isDummyBbData(model)) {
            DynamicTrainModelLoader.loadObjInto(model, target);
        } else {
            if (!model.has("dummyBbData")) {
                return;
            }
            boolean bbModelPreload = MtrModelRegistryUtil.getBbModelPreloadFromDummyBbData(model.get("dummyBbData").getAsJsonObject());
            if (ClientConfig.enableBbModelPreload || bbModelPreload) {
                DynamicTrainModelLoader.loadVanillaModelInto(model, target);
            }
        }
    }

    public static void loadObjInto(JsonObject model, DynamicTrainModel target) {
        int bbDataType = MtrModelRegistryUtil.getDummyBbDataType(model);
        String path = MtrModelRegistryUtil.getPathFromDummyBbData(model);
        target.parts.clear();
        try {
            Map<Object, Object> models;
            if (target.properties.has("atlasIndex")) {
                MainClient.atlasManager.load(MtrModelRegistryUtil.resourceManager, new class_2960(target.properties.get("atlasIndex").getAsString()));
            }
            if (bbDataType == 1) {
                String modelLocations = MtrModelRegistryUtil.getPathFromDummyBbData(model);
                if (modelLocations.contains("|")) {
                    String modelLocationName;
                    boolean isModelReversed;
                    String[] extraAttribs;
                    class_2960 modelLocation;
                    int i;
                    models = new HashMap();
                    String[] stringArray = modelLocations.split("\\|");
                    ArrayList<JsonObject> arrayList = new ArrayList<JsonObject>();
                    target.properties.get("parts").getAsJsonArray().forEach(elem -> previousParts.add(elem.getAsJsonObject()));
                    JsonArray newParts = new JsonArray();
                    for (i = 0; i < stringArray.length / 2; ++i) {
                        modelLocation = new class_2960(stringArray[i * 2]);
                        extraAttribs = stringArray[i * 2 + 1].split(";", -1)[2].split(",");
                        isModelReversed = Arrays.asList(extraAttribs).contains("reversed");
                        modelLocationName = modelLocation.method_12832().substring(modelLocation.method_12832().lastIndexOf(47) + 1) + (isModelReversed ? "/reversed" : "");
                        Map<String, RawModel> modelParts = ObjModelLoader.loadModels(MtrModelRegistryUtil.resourceManager, modelLocation, MainClient.atlasManager);
                        for (Map.Entry<String, RawModel> entry : modelParts.entrySet()) {
                            if (isModelReversed) {
                                entry.getValue().sourceLocation = new class_2960(entry.getValue().sourceLocation.toString().substring(0, entry.getValue().sourceLocation.toString().lastIndexOf("/")) + "/reversed" + entry.getValue().sourceLocation.toString().substring(entry.getValue().sourceLocation.toString().lastIndexOf("/")));
                                entry.getValue().applyRotation(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f);
                            }
                            models.put(modelLocationName + "/" + entry.getKey(), entry.getValue());
                        }
                        arrayList.forEach(elem -> {
                            if (elem.get("name").getAsString().startsWith(modelLocationName)) {
                                newParts.add((JsonElement)elem);
                            }
                        });
                        arrayList.removeIf(elem -> elem.get("name").getAsString().startsWith(modelLocationName));
                    }
                    for (i = 0; i < stringArray.length / 2; ++i) {
                        modelLocation = new class_2960(stringArray[i * 2]);
                        extraAttribs = stringArray[i * 2 + 1].split(";", -1)[2].split(",");
                        isModelReversed = Arrays.asList(extraAttribs).contains("reversed");
                        modelLocationName = modelLocation.method_12832().substring(modelLocation.method_12832().lastIndexOf(47) + 1) + (isModelReversed ? "/reversed" : "");
                        String whiteList = stringArray[i * 2 + 1].split(";", -1)[0];
                        String blackList = stringArray[i * 2 + 1].split(";", -1)[1];
                        for (JsonObject part : arrayList) {
                            JsonObject newPartObj = (JsonObject)new JsonParser().parse(part.toString());
                            String previousName = newPartObj.get("name").getAsString();
                            newPartObj.remove("name");
                            newPartObj.addProperty("name", modelLocationName + "/" + previousName);
                            newPartObj.remove("whitelisted_cars");
                            newPartObj.addProperty("whitelisted_cars", whiteList);
                            newPartObj.remove("blacklisted_cars");
                            newPartObj.addProperty("blacklisted_cars", blackList);
                            if (isModelReversed) {
                                ResourcePackCreatorProperties.DoorOffset newDoorOffset = (ResourcePackCreatorProperties.DoorOffset)EnumHelper.valueOf((Enum)ResourcePackCreatorProperties.DoorOffset.NONE, (String)newPartObj.get("door_offset").getAsString().toUpperCase(Locale.ROOT));
                                newDoorOffset = switch (newDoorOffset) {
                                    case ResourcePackCreatorProperties.DoorOffset.LEFT_POSITIVE -> ResourcePackCreatorProperties.DoorOffset.RIGHT_NEGATIVE;
                                    case ResourcePackCreatorProperties.DoorOffset.RIGHT_POSITIVE -> ResourcePackCreatorProperties.DoorOffset.LEFT_NEGATIVE;
                                    case ResourcePackCreatorProperties.DoorOffset.LEFT_NEGATIVE -> ResourcePackCreatorProperties.DoorOffset.RIGHT_POSITIVE;
                                    case ResourcePackCreatorProperties.DoorOffset.RIGHT_NEGATIVE -> ResourcePackCreatorProperties.DoorOffset.LEFT_POSITIVE;
                                    default -> newDoorOffset;
                                };
                                newPartObj.remove("door_offset");
                                newPartObj.addProperty("door_offset", newDoorOffset.toString());
                                ResourcePackCreatorProperties.RenderCondition newRenderCondition = (ResourcePackCreatorProperties.RenderCondition)EnumHelper.valueOf((Enum)ResourcePackCreatorProperties.RenderCondition.ALL, (String)newPartObj.get("render_condition").getAsString().toUpperCase(Locale.ROOT));
                                newRenderCondition = switch (newRenderCondition) {
                                    case ResourcePackCreatorProperties.RenderCondition.DOOR_LEFT_OPEN -> ResourcePackCreatorProperties.RenderCondition.DOOR_RIGHT_OPEN;
                                    case ResourcePackCreatorProperties.RenderCondition.DOOR_RIGHT_OPEN -> ResourcePackCreatorProperties.RenderCondition.DOOR_LEFT_OPEN;
                                    case ResourcePackCreatorProperties.RenderCondition.DOOR_LEFT_CLOSED -> ResourcePackCreatorProperties.RenderCondition.DOOR_RIGHT_CLOSED;
                                    case ResourcePackCreatorProperties.RenderCondition.DOOR_RIGHT_CLOSED -> ResourcePackCreatorProperties.RenderCondition.DOOR_LEFT_CLOSED;
                                    default -> newRenderCondition;
                                };
                                newPartObj.remove("render_condition");
                                newPartObj.addProperty("render_condition", newRenderCondition.toString());
                                JsonArray newPositions = new JsonArray();
                                JsonArray oldPositions = newPartObj.get("positions").getAsJsonArray();
                                for (int j = 0; j < oldPositions.size(); ++j) {
                                    JsonArray pos = oldPositions.get(j).getAsJsonArray();
                                    pos.set(1, (JsonElement)new JsonPrimitive((Number)Float.valueOf(-pos.get(1).getAsFloat())));
                                    newPositions.add((JsonElement)pos);
                                }
                                newPartObj.remove("positions");
                                newPartObj.add("positions", (JsonElement)newPositions);
                            }
                            newParts.add((JsonElement)newPartObj);
                        }
                    }
                    target.properties.remove("parts");
                    target.properties.add("parts", (JsonElement)newParts);
                } else {
                    models = ObjModelLoader.loadModels(MtrModelRegistryUtil.resourceManager, new class_2960(modelLocations), MainClient.atlasManager);
                }
            } else {
                if (cachedModels == null || !path.equals(cachedPath) || new File(path).lastModified() != cachedPathMtime) {
                    MainClient.modelManager.clearNamespace("mtrsteamloco-external");
                    cachedModels = ObjModelLoader.loadExternalModels(MtrModelRegistryUtil.getPathFromDummyBbData(model), MainClient.atlasManager);
                    for (RawModel rawModel : cachedModels.values()) {
                        rawModel.replaceAllTexture(MtrModelRegistryUtil.PLACEHOLDER_TILE_TEXTURE_LOCATION);
                    }
                    cachedPath = path;
                    cachedPathMtime = new File(path).lastModified();
                }
                models = cachedModels;
            }
            String repaintTexture = MtrModelRegistryUtil.getTextureIdFromDummyBbData(model);
            if (!StringUtils.isEmpty((CharSequence)repaintTexture)) {
                for (RawModel rawModel : models.values()) {
                    rawModel.replaceTexture("default.png", new class_2960(repaintTexture));
                }
            }
            if (MtrModelRegistryUtil.getFlipVFromDummyBbData(model)) {
                for (RawModel rawModel : models.values()) {
                    rawModel.applyUVMirror(false, true);
                }
            }
            JsonArray jsonArray = target.properties.getAsJsonArray("parts");
            Map<Object, Object> map = models;
            jsonArray.forEach(jsonElement -> {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String name = jsonObject.get("name").getAsString();
                RawModel partModel = finalModels.getOrDefault(name, null);
                if (partModel != null) {
                    ModelTrainBase.RenderStage renderStage = (ModelTrainBase.RenderStage)EnumHelper.valueOf((Enum)ModelTrainBase.RenderStage.EXTERIOR, (String)jsonObject.get("stage").getAsString().toUpperCase(Locale.ROOT));
                    switch (renderStage) {
                        case EXTERIOR: {
                            partModel.setAllRenderType("reset");
                            break;
                        }
                        case INTERIOR: {
                            partModel.setAllRenderType("interior");
                            break;
                        }
                        case INTERIOR_TRANSLUCENT: {
                            partModel.setAllRenderType("interiortranslucent");
                            break;
                        }
                        case LIGHTS: {
                            partModel.setAllRenderType("light");
                            break;
                        }
                        case ALWAYS_ON_LIGHTS: {
                            partModel.setAllRenderType("lighttranslucent");
                        }
                    }
                }
            });
            if (bbDataType == 1) {
                boolean isLoadingFromEditor;
                HashMap mergedModels = new HashMap();
                target.properties.getAsJsonArray("parts").forEach(elem -> {
                    JsonObject partObject = elem.getAsJsonObject();
                    String partName = partObject.get("name").getAsString();
                    RawModel partModel = (RawModel)models.get(partName);
                    if (partModel == null) {
                        return;
                    }
                    boolean mirror = partObject.get("mirror").getAsBoolean();
                    PartBatch batch = new PartBatch(partObject, mirror);
                    RawModel mergedModel = mergedModels.computeIfAbsent(batch, ignored -> new RawModel());
                    partObject.getAsJsonArray("positions").forEach(positionElement -> {
                        float x = positionElement.getAsJsonArray().get(0).getAsFloat() / 16.0f;
                        float z = positionElement.getAsJsonArray().get(1).getAsFloat() / 16.0f;
                        if (!mirror && x == 0.0f && z == 0.0f) {
                            mergedModel.append(partModel);
                        } else {
                            RawModel clonedModel = partModel.copy();
                            if (mirror) {
                                clonedModel.applyRotation(Vector3f.YP, 180.0f);
                                clonedModel.applyTranslation(-x, 0.0f, z);
                            } else {
                                clonedModel.applyTranslation(x, 0.0f, z);
                            }
                            mergedModel.append(clonedModel);
                        }
                    });
                });
                target.parts.clear();
                JsonArray partsPropArray = new JsonArray();
                target.properties.add("parts", (JsonElement)partsPropArray);
                boolean bl = isLoadingFromEditor = !GlStateTracker.isStateProtected;
                if (isLoadingFromEditor) {
                    GlStateTracker.capture();
                }
                for (Map.Entry entry : mergedModels.entrySet()) {
                    PartBatch batch = (PartBatch)entry.getKey();
                    RawModel mergedModel = (RawModel)entry.getValue();
                    target.parts.put(batch.batchId, new SowcerModelAgent(mergedModel, false));
                    partsPropArray.add((JsonElement)batch.getPartObject());
                }
                if (isLoadingFromEditor) {
                    GlStateTracker.restore();
                }
            } else {
                boolean isLoadingFromEditor;
                boolean bl = isLoadingFromEditor = !GlStateTracker.isStateProtected;
                if (isLoadingFromEditor) {
                    GlStateTracker.capture();
                }
                for (Map.Entry<Object, Object> entry : models.entrySet()) {
                    target.parts.put((String)entry.getKey(), new SowcerModelAgent((RawModel)entry.getValue(), false));
                }
                if (isLoadingFromEditor) {
                    GlStateTracker.restore();
                }
            }
        }
        catch (Exception e) {
            Main.LOGGER.error("Failed loading OBJ into DynamicTrainModel", (Throwable)e);
            MtrModelRegistryUtil.recordLoadingError("Failed loading OBJ model " + path, e);
        }
    }

    public static void loadVanillaModelInto(JsonObject model, DynamicTrainModel target) {
        if (!model.has("dummyBbData")) {
            return;
        }
        String path = MtrModelRegistryUtil.getPathFromDummyBbData(model.get("dummyBbData").getAsJsonObject());
        try {
            String textureId = MtrModelRegistryUtil.getTextureIdFromDummyBbData(model.get("dummyBbData").getAsJsonObject());
            class_2960 texture = DynamicTrainModelLoader.resolveTexture(textureId, str -> str.endsWith(".png") ? str : str + ".png");
            HashMap mergeVertexConsumers = new HashMap();
            target.properties.getAsJsonArray("parts").forEach(elem -> {
                JsonObject partObject = elem.getAsJsonObject();
                String partName = partObject.get("name").getAsString();
                ModelMapper partModel = (ModelMapper)target.parts.get(partName);
                if (partModel == null) {
                    return;
                }
                ModelTrainBase.RenderStage renderStage = (ModelTrainBase.RenderStage)EnumHelper.valueOf((Enum)ModelTrainBase.RenderStage.EXTERIOR, (String)partObject.get("stage").getAsString().toUpperCase(Locale.ROOT));
                boolean mirror = partObject.get("mirror").getAsBoolean();
                PartBatch batch = new PartBatch(partObject, mirror);
                CapturingVertexConsumer vertexConsumer = mergeVertexConsumers.computeIfAbsent(batch, ignored -> new CapturingVertexConsumer());
                vertexConsumer.beginStage(texture, renderStage);
                partObject.getAsJsonArray("positions").forEach(positionElement -> {
                    float x = positionElement.getAsJsonArray().get(0).getAsFloat();
                    float z = positionElement.getAsJsonArray().get(1).getAsFloat();
                    class_630 modelPart = ((ModelMapperAccessor)partModel).getModelPart();
                    if (mirror) {
                        modelPart.method_2851(-x, 0.0f, z);
                        modelPart.field_3675 = (float)Math.PI;
                    } else {
                        modelPart.method_2851(x, 0.0f, z);
                        modelPart.field_3675 = 0.0f;
                    }
                    vertexConsumer.captureModelPart(modelPart);
                });
            });
            target.parts.clear();
            JsonArray partsPropArray = new JsonArray();
            ArrayList propertiesToKeep = new ArrayList();
            target.properties.getAsJsonArray("parts").forEach(partElement -> {
                JsonObject partObject = partElement.getAsJsonObject();
                String partName = partObject.get("name").getAsString();
                if (!target.partsInfo.containsKey(partName) || !partObject.has("display")) {
                    return;
                }
                propertiesToKeep.add(partObject);
            });
            target.properties.add("parts", (JsonElement)partsPropArray);
            for (JsonObject jsonObject : propertiesToKeep) {
                partsPropArray.add((JsonElement)jsonObject);
            }
            for (Map.Entry entry : mergeVertexConsumers.entrySet()) {
                PartBatch batch = (PartBatch)entry.getKey();
                CapturingVertexConsumer vertexConsumer = (CapturingVertexConsumer)entry.getValue();
                RawModel rawModel = vertexConsumer.models[0];
                rawModel.triangulate();
                target.parts.put(batch.batchId, new SowcerModelAgent(rawModel, true));
                partsPropArray.add((JsonElement)batch.getPartObject());
            }
        }
        catch (Exception e) {
            Main.LOGGER.error("Error when optimizing BBMODEL in DynamicTrainModel", (Throwable)e);
            MtrModelRegistryUtil.recordLoadingError("Error when optimizing BBMODEL " + path, e);
        }
    }

    private static class_2960 resolveTexture(String textureId, Function<String, String> formatter) {
        boolean available;
        String textureString = formatter.apply(textureId);
        class_2960 id = new class_2960(textureString);
        if (!RenderTrains.AVAILABLE_TEXTURES.contains(textureString) && !RenderTrains.UNAVAILABLE_TEXTURES.contains(textureString)) {
            available = UtilitiesClient.hasResource((class_2960)id);
            (available ? RenderTrains.AVAILABLE_TEXTURES : RenderTrains.UNAVAILABLE_TEXTURES).add(textureString);
            if (!available) {
                System.out.println("Texture " + textureString + " not found, using default");
            }
        } else {
            available = RenderTrains.AVAILABLE_TEXTURES.contains(textureString);
        }
        if (available) {
            return id;
        }
        return new class_2960("mtr:textures/block/transparent.png");
    }

    static {
        cachedPathMtime = 0L;
    }

    public static class PartBatch {
        public final ResourcePackCreatorProperties.DoorOffset doorOffset;
        public final ResourcePackCreatorProperties.RenderCondition renderCondition;
        public final String whitelistedCars;
        public final String blacklistedCars;
        public final boolean skipRenderingIfTooFar;
        public final String batchId;

        public PartBatch(JsonObject partObject, boolean mirror) {
            ResourcePackCreatorProperties.DoorOffset rawDoorOffset = (ResourcePackCreatorProperties.DoorOffset)EnumHelper.valueOf((Enum)ResourcePackCreatorProperties.DoorOffset.NONE, (String)partObject.get("door_offset").getAsString());
            if (mirror) {
                this.doorOffset = switch (rawDoorOffset) {
                    default -> throw new IncompatibleClassChangeError();
                    case ResourcePackCreatorProperties.DoorOffset.NONE -> ResourcePackCreatorProperties.DoorOffset.NONE;
                    case ResourcePackCreatorProperties.DoorOffset.LEFT_NEGATIVE -> ResourcePackCreatorProperties.DoorOffset.LEFT_POSITIVE;
                    case ResourcePackCreatorProperties.DoorOffset.LEFT_POSITIVE -> ResourcePackCreatorProperties.DoorOffset.LEFT_NEGATIVE;
                    case ResourcePackCreatorProperties.DoorOffset.RIGHT_NEGATIVE -> ResourcePackCreatorProperties.DoorOffset.RIGHT_POSITIVE;
                    case ResourcePackCreatorProperties.DoorOffset.RIGHT_POSITIVE -> ResourcePackCreatorProperties.DoorOffset.RIGHT_NEGATIVE;
                };
            } else {
                this.doorOffset = rawDoorOffset;
            }
            this.renderCondition = (ResourcePackCreatorProperties.RenderCondition)EnumHelper.valueOf((Enum)ResourcePackCreatorProperties.RenderCondition.ALL, (String)partObject.get("render_condition").getAsString());
            this.whitelistedCars = partObject.get("whitelisted_cars").getAsString();
            this.blacklistedCars = partObject.get("blacklisted_cars").getAsString();
            ModelTrainBase.RenderStage renderStage = (ModelTrainBase.RenderStage)EnumHelper.valueOf((Enum)ModelTrainBase.RenderStage.EXTERIOR, (String)partObject.get("stage").getAsString().toUpperCase(Locale.ROOT));
            this.skipRenderingIfTooFar = partObject.get("skip_rendering_if_too_far").getAsBoolean() || renderStage == ModelTrainBase.RenderStage.INTERIOR_TRANSLUCENT;
            this.batchId = String.format("$NTEPart:%s:%s:%s:%s:%s", this.doorOffset, this.renderCondition, this.whitelistedCars, this.blacklistedCars, this.skipRenderingIfTooFar);
        }

        public JsonObject getPartObject() {
            JsonObject result = new JsonObject();
            result.addProperty("name", this.batchId);
            result.addProperty("stage", "EXTERIOR");
            result.addProperty("mirror", Boolean.valueOf(false));
            result.addProperty("skip_rendering_if_too_far", Boolean.valueOf(this.skipRenderingIfTooFar));
            result.addProperty("door_offset", this.doorOffset.toString());
            result.addProperty("render_condition", this.renderCondition.toString());
            result.add("positions", new JsonParser().parse("[[0, 0]]"));
            result.addProperty("whitelisted_cars", this.whitelistedCars);
            result.addProperty("blacklisted_cars", this.blacklistedCars);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartBatch partBatch = (PartBatch)o;
            return this.batchId.equals(partBatch.batchId);
        }

        public int hashCode() {
            return this.batchId.hashCode();
        }
    }
}

