/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.integration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_1255;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_4014;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MtrModelRegistryUtil {
    public static class_3300 resourceManager;
    public static final List<String> loadingErrorList;
    public static final class_2960 PLACEHOLDER_TILE_TEXTURE_LOCATION;

    public static void recordLoadingError(String context, Exception ex) {
        String[] uselessPrefixes = new String[]{"at " + CompletableFuture.class.getName(), "at java.base/" + CompletableFuture.class.getName(), "at " + class_4014.class.getName(), "at " + class_1255.class.getName(), "at " + class_4013.class.getName(), "at vendor.cn.zbx1425", "at mtr.MTRFabricClient", "at mtr.MTRForge", "at java.base/jdk.internal"};
        String cleanedStackTrace = Arrays.stream(ExceptionUtils.getStackTrace((Throwable)ex).split("\n")).map(l -> l.replace("\t", "  ").replace("\r", "")).filter(l -> Arrays.stream(uselessPrefixes).noneMatch(p -> l.trim().startsWith((String)p))).takeWhile(l -> !l.trim().startsWith("at net.minecraft.client.main.Main")).takeWhile(l -> !l.trim().startsWith("at com.mojang.blaze3d.systems.RenderSystem.replayQueue")).map(l -> l + "\n").collect(Collectors.joining()).trim();
        loadingErrorList.add(context + "\n" + cleanedStackTrace);
    }

    public static List<Pair<class_2960, class_3298>> listResources(class_3300 resourceManager, String namespace, String path, String extension) {
        return resourceManager.method_41265(path, rl -> rl.method_12836().equals(namespace) && rl.method_12832().endsWith(extension)).entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(r -> new Pair((Object)((class_2960)e.getKey()), r))).toList();
    }

    public static JsonObject createDummyBbDataPack(String actualPath, String textureId, boolean flipV, boolean preloadBbModel) {
        JsonObject result = MtrModelRegistryUtil.createDummyBbData();
        result.addProperty("zbxFlag", "dummyBbData.resourceLocation");
        result.addProperty("actualPath", actualPath);
        result.addProperty("textureId", textureId);
        result.addProperty("flipV", Boolean.valueOf(flipV));
        result.addProperty("preloadBbModel", Boolean.valueOf(preloadBbModel));
        return result;
    }

    public static JsonObject createDummyBbDataExternal(String actualPath) {
        JsonObject result = MtrModelRegistryUtil.createDummyBbData();
        result.addProperty("zbxFlag", "dummyBbData.path");
        result.addProperty("actualPath", actualPath);
        result.addProperty("textureId", "");
        result.addProperty("flipV", Boolean.valueOf(false));
        result.addProperty("preloadBbModel", Boolean.valueOf(false));
        return result;
    }

    private static JsonObject createDummyBbData() {
        JsonObject result = new JsonObject();
        result.add("elements", (JsonElement)new JsonArray());
        result.add("outliner", (JsonElement)new JsonArray());
        JsonObject resolution = new JsonObject();
        resolution.addProperty("width", (Number)0);
        resolution.addProperty("height", (Number)0);
        result.add("resolution", (JsonElement)resolution);
        return result;
    }

    public static int getDummyBbDataType(JsonObject obj) {
        if (!obj.has("zbxFlag")) {
            return 0;
        }
        if (obj.get("zbxFlag").getAsString().equals("dummyBbData.resourceLocation")) {
            return 1;
        }
        if (obj.get("zbxFlag").getAsString().equals("dummyBbData.path")) {
            return 2;
        }
        return 0;
    }

    public static boolean isDummyBbData(JsonObject obj) {
        return MtrModelRegistryUtil.getDummyBbDataType(obj) > 0;
    }

    public static String getPathFromDummyBbData(JsonObject obj) {
        return obj.get("actualPath").getAsString();
    }

    public static String getTextureIdFromDummyBbData(JsonObject obj) {
        return obj.get("textureId").getAsString();
    }

    public static boolean getFlipVFromDummyBbData(JsonObject obj) {
        return obj.get("flipV").getAsBoolean();
    }

    public static boolean getBbModelPreloadFromDummyBbData(JsonObject obj) {
        return obj.get("preloadBbModel").getAsBoolean();
    }

    static {
        loadingErrorList = new ArrayList<String>();
        PLACEHOLDER_TILE_TEXTURE_LOCATION = new class_2960("mtrsteamloco:textures/misc/nte_tile_faded.png");
    }
}

