/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.rail;

import com.google.common.io.LittleEndianDataOutputStream;
import fabric.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import fabric.cn.zbx1425.mtrsteamloco.render.ByteBufferOutputStream;
import fabric.cn.zbx1425.mtrsteamloco.render.rail.BakedRail;
import fabric.cn.zbx1425.mtrsteamloco.render.rail.RailChunkBase;
import fabric.cn.zbx1425.mtrsteamloco.render.rail.RailRenderDispatcher;
import fabric.cn.zbx1425.sowcer.batch.BatchManager;
import fabric.cn.zbx1425.sowcer.batch.EnqueueProp;
import fabric.cn.zbx1425.sowcer.batch.ShaderProp;
import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcer.model.Model;
import fabric.cn.zbx1425.sowcer.model.VertArrays;
import fabric.cn.zbx1425.sowcer.object.InstanceBuf;
import fabric.cn.zbx1425.sowcer.util.OffHeapAllocator;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrMapping;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrSrc;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrState;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrType;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_765;

public class InstancedRailChunk
extends RailChunkBase {
    private final InstanceBuf instanceBuf;
    private final VertArrays vertArrays;
    private static final VertAttrMapping RAIL_MAPPING = new VertAttrMapping.Builder().set(VertAttrType.POSITION, VertAttrSrc.VERTEX_BUF).set(VertAttrType.COLOR, VertAttrSrc.INSTANCE_BUF_OR_GLOBAL).set(VertAttrType.UV_TEXTURE, VertAttrSrc.VERTEX_BUF).set(VertAttrType.UV_OVERLAY, VertAttrSrc.GLOBAL).set(VertAttrType.UV_LIGHTMAP, VertAttrSrc.INSTANCE_BUF_OR_GLOBAL).set(VertAttrType.NORMAL, VertAttrSrc.VERTEX_BUF).set(VertAttrType.MATRIX_MODEL, VertAttrSrc.INSTANCE_BUF).build();

    public InstancedRailChunk(Long chunkId, String modelKey) {
        super(chunkId, modelKey);
        Model railModel = RailModelRegistry.getProperty((String)modelKey).uploadedModel;
        if (railModel != null) {
            this.instanceBuf = new InstanceBuf(0);
            this.vertArrays = VertArrays.createAll(railModel, RAIL_MAPPING, this.instanceBuf);
        } else {
            this.instanceBuf = null;
            this.vertArrays = null;
        }
    }

    @Override
    public void rebuildBuffer(class_1937 world) {
        super.rebuildBuffer(world);
        if (this.vertArrays == null) {
            return;
        }
        int instanceCount = this.containingRails.values().stream().mapToInt(ArrayList::size).sum();
        float yMin = 256.0f;
        float yMax = -64.0f;
        ByteBuffer byteBuf = OffHeapAllocator.allocate(instanceCount * InstancedRailChunk.RAIL_MAPPING.strideInstance);
        ByteBufferOutputStream byteArrayOutputStream = new ByteBufferOutputStream(byteBuf, false);
        LittleEndianDataOutputStream oStream = new LittleEndianDataOutputStream((OutputStream)byteArrayOutputStream);
        for (Map.Entry entry : this.containingRails.entrySet()) {
            ArrayList railSpan = (ArrayList)entry.getValue();
            for (Matrix4f pieceMat : railSpan) {
                try {
                    oStream.writeInt(((BakedRail)entry.getKey()).color);
                    Vector3f lightPos = pieceMat.getTranslationPart();
                    yMin = Math.min(yMin, lightPos.y());
                    yMax = Math.max(yMax, lightPos.y());
                    class_2338 lightBlockPos = new class_2338(class_3532.method_15375((float)lightPos.x()), class_3532.method_15357((double)((double)lightPos.y() + 0.1)), class_3532.method_15375((float)lightPos.z()));
                    int light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, lightBlockPos), (int)world.method_8314(class_1944.field_9284, lightBlockPos));
                    oStream.writeInt(light);
                    byte[] lookAtBytes = new byte[64];
                    ByteBuffer matByteBuf = ByteBuffer.wrap(lookAtBytes).order(ByteOrder.nativeOrder());
                    FloatBuffer matFloatBuf = matByteBuf.asFloatBuffer();
                    pieceMat.store(matFloatBuf);
                    oStream.write(lookAtBytes);
                    for (int k = 0; k < InstancedRailChunk.RAIL_MAPPING.paddingInstance; ++k) {
                        oStream.writeByte(0);
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        this.instanceBuf.size = instanceCount;
        this.instanceBuf.upload(byteBuf, 35048);
        OffHeapAllocator.free(byteBuf);
        if (yMin > yMax) {
            yMin = yMax;
        }
        this.setBoundingBox(yMin, yMax);
    }

    @Override
    public void enqueue(BatchManager batchManager, ShaderProp shaderProp) {
        if (this.vertArrays == null) {
            return;
        }
        if (this.instanceBuf.size < 1) {
            return;
        }
        VertAttrState attrState = new VertAttrState().setOverlayUVNoOverlay();
        if (!RailRenderDispatcher.isHoldingRailItem) {
            attrState.setColor(-1);
        }
        batchManager.enqueue(this.vertArrays, new EnqueueProp(attrState), shaderProp);
    }

    @Override
    public void close() {
        if (this.vertArrays == null) {
            return;
        }
        this.vertArrays.close();
        this.instanceBuf.close();
    }
}

