/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.rail;

import fabric.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import fabric.cn.zbx1425.mtrsteamloco.render.rail.BakedRail;
import fabric.cn.zbx1425.sowcer.batch.BatchManager;
import fabric.cn.zbx1425.sowcer.batch.ShaderProp;
import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;

public abstract class RailChunkBase
implements Closeable {
    public Long chunkId;
    public class_238 boundingBox;
    public HashMap<BakedRail, ArrayList<Matrix4f>> containingRails = new HashMap();
    public final String modelKey;
    protected float modelYMin;
    protected float modelYMax;
    public boolean isDirty = false;
    public boolean bufferBuilt = false;
    public double cameraDistManhattanXZ = 0.0;

    public RailChunkBase(long chunkId, String modelKey) {
        this.chunkId = chunkId;
        this.modelKey = modelKey;
        long boundary = RailModelRegistry.getProperty((String)modelKey).boundingBox;
        this.modelYMin = Float.intBitsToFloat((int)(boundary >> 32));
        this.modelYMax = Float.intBitsToFloat((int)(boundary & 0xFFFFFFFFL));
        this.setBoundingBox(0.0f, 0.0f);
    }

    protected void setBoundingBox(float yMin, float yMax) {
        int posXMin = (int)(this.chunkId >> 32) << 5;
        int posZMin = (int)(this.chunkId & 0xFFFFFFFFL) << 5;
        int span = 32;
        this.boundingBox = new class_238((double)posXMin, (double)(yMin + this.modelYMin - 1.0f), (double)posZMin, (double)(posXMin + span), (double)(yMax + this.modelYMax + 1.0f), (double)(posZMin + span));
    }

    public boolean isEven() {
        return ((int)(this.chunkId >> 32) + (int)(this.chunkId & 0xFFFFFFFFL)) % 2 == 0;
    }

    public class_1923 getChunkPos() {
        return new class_1923((int)(this.chunkId >> 32) << 1, (int)(this.chunkId & 0xFFFFFFFFL) << 1);
    }

    public boolean containsYSection(int yMin, int yMax) {
        return (double)(yMin << 4) < this.boundingBox.field_1322 || (double)(yMax << 4) > this.boundingBox.field_1325;
    }

    public double getCameraDistManhattanXZ(class_243 cameraPos) {
        this.cameraDistManhattanXZ = Math.abs(cameraPos.field_1352 - (this.boundingBox.field_1323 + this.boundingBox.field_1320) / 2.0) + Math.abs(cameraPos.field_1350 - (this.boundingBox.field_1321 + this.boundingBox.field_1324) / 2.0);
        return this.cameraDistManhattanXZ;
    }

    public void addRail(BakedRail rail) {
        this.containingRails.put(rail, rail.coveredChunks.get(this.chunkId));
        this.isDirty = true;
    }

    public void removeRail(BakedRail rail) {
        this.containingRails.remove(rail);
        this.isDirty = true;
    }

    public void rebuildBuffer(class_1937 world) {
        this.isDirty = false;
        this.bufferBuilt = true;
    }

    public abstract void enqueue(BatchManager var1, ShaderProp var2);

    @Override
    public void close() {
    }
}

