/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.rail;

import fabric.cn.zbx1425.mtrsteamloco.ClientConfig;
import fabric.cn.zbx1425.mtrsteamloco.data.RailExtraSupplier;
import fabric.cn.zbx1425.mtrsteamloco.data.RailModelRegistry;
import fabric.cn.zbx1425.mtrsteamloco.gui.SelectListScreen;
import fabric.cn.zbx1425.mtrsteamloco.mixin.LevelRendererAccessor;
import fabric.cn.zbx1425.mtrsteamloco.render.rail.BakedRail;
import fabric.cn.zbx1425.mtrsteamloco.render.rail.InstancedRailChunk;
import fabric.cn.zbx1425.mtrsteamloco.render.rail.MeshBuildingRailChunk;
import fabric.cn.zbx1425.mtrsteamloco.render.rail.RailChunkBase;
import fabric.cn.zbx1425.sowcer.batch.BatchManager;
import fabric.cn.zbx1425.sowcer.batch.ShaderProp;
import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcerext.reuse.DrawScheduler;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mtr.Items;
import mtr.MTRClient;
import mtr.client.ClientData;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.data.TransportMode;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_761;
import net.minecraft.class_765;

public class RailRenderDispatcher {
    private final HashMap<Rail, BakedRail> railRefMap = new HashMap();
    private final HashMap<String, HashMap<Long, RailChunkBase>> railChunkMap = new HashMap();
    private final List<RailChunkBase> railChunkList = new LinkedList<RailChunkBase>();
    private boolean isInstanced;
    private final HashSet<Rail> currentFrameRails = new HashSet();
    public static boolean isHoldingRailItem = false;
    public static boolean isHoldingBrush = false;
    public static boolean isHoldingRailItemOrBrush = false;
    public static boolean isPreviewingModel = false;

    private void addRail(Rail rail) {
        if (this.railRefMap.containsKey(rail)) {
            return;
        }
        BakedRail bakedRail = new BakedRail(rail);
        this.railRefMap.put(rail, bakedRail);
        HashMap<Long, RailChunkBase> chunkMap = this.railChunkMap.get(bakedRail.modelKey);
        if (chunkMap == null) {
            return;
        }
        for (long chunkId : bakedRail.coveredChunks.keySet()) {
            if (chunkMap.containsKey(chunkId)) {
                chunkMap.get(chunkId).addRail(bakedRail);
                continue;
            }
            RailChunkBase newChunk = this.isInstanced ? new InstancedRailChunk((Long)chunkId, bakedRail.modelKey) : new MeshBuildingRailChunk((Long)chunkId, bakedRail.modelKey);
            newChunk.addRail(bakedRail);
            chunkMap.put(chunkId, newChunk);
            this.railChunkList.add(newChunk);
        }
    }

    private void removeRail(Rail rail) {
        if (!this.railRefMap.containsKey(rail)) {
            return;
        }
        BakedRail bakedRail = this.railRefMap.get(rail);
        this.railRefMap.remove(rail);
        HashMap<Long, RailChunkBase> chunkMap = this.railChunkMap.get(bakedRail.modelKey);
        if (chunkMap == null) {
            return;
        }
        for (long chunkId : bakedRail.coveredChunks.keySet()) {
            chunkMap.get(chunkId).removeRail(bakedRail);
        }
    }

    public boolean registerRail(Rail rail) {
        if (RailRenderDispatcher.getModelKeyForRender(rail).isEmpty() || rail.railType == RailType.NONE) {
            return false;
        }
        this.currentFrameRails.add(rail);
        return true;
    }

    public void clearRail() {
        this.currentFrameRails.clear();
        this.railRefMap.clear();
        for (HashMap<Long, RailChunkBase> chunkMap : this.railChunkMap.values()) {
            for (RailChunkBase chunk : chunkMap.values()) {
                chunk.close();
            }
            chunkMap.clear();
        }
        this.railChunkMap.clear();
        this.railChunkList.clear();
        for (String key : RailModelRegistry.elements.keySet()) {
            this.railChunkMap.put(key, new HashMap());
        }
    }

    public void registerLightUpdate(int x, int yMin, int yMax, int z) {
        long chunkId = BakedRail.chunkIdFromSectPos(x, z);
        for (HashMap<Long, RailChunkBase> chunkMap : this.railChunkMap.values()) {
            RailChunkBase chunk = chunkMap.get(chunkId);
            if (chunk == null || chunk.isDirty || !chunk.containsYSection(yMin, yMax)) continue;
            chunk.isDirty = true;
        }
    }

    public void prepareDraw() {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        class_437 currentScreen = class_310.method_1551().field_1755;
        boolean bl = isPreviewingModel = currentScreen instanceof SelectListScreen && ((SelectListScreen)currentScreen).isSelecting();
        if (!isPreviewingModel) {
            isHoldingRailItem = RenderTrains.isHoldingRailRelated((class_1657)class_310.method_1551().field_1724);
            isHoldingBrush = Utilities.isHolding((class_1657)class_310.method_1551().field_1724, item -> item.equals(Items.BRUSH.get()));
            isHoldingRailItemOrBrush = isHoldingRailItem || isHoldingBrush;
        } else {
            isHoldingRailItem = false;
            isHoldingBrush = false;
            isHoldingRailItemOrBrush = false;
        }
    }

    public void drawRails(class_1937 level, BatchManager batchManager, Matrix4f viewMatrix) {
        boolean shouldBeInstanced;
        boolean bl = shouldBeInstanced = ClientConfig.getRailRenderLevel() == 3;
        if (this.isInstanced != shouldBeInstanced) {
            this.clearRail();
        }
        this.isInstanced = shouldBeInstanced;
        HashSet<Rail> railsToAdd = new HashSet<Rail>(this.currentFrameRails);
        railsToAdd.removeAll(this.railRefMap.keySet());
        for (Rail rail : railsToAdd) {
            this.addRail(rail);
        }
        HashSet<Rail> railsToRemove = new HashSet<Rail>(this.railRefMap.keySet());
        railsToRemove.removeAll(this.currentFrameRails);
        for (Rail rail : railsToRemove) {
            this.removeRail(rail);
        }
        this.currentFrameRails.clear();
        class_243 class_2432 = class_310.method_1551().field_1773.method_19418().method_19326();
        this.railChunkList.sort(Comparator.comparingDouble(chunk -> chunk.getCameraDistManhattanXZ(cameraBlockPos)));
        int buffersRebuilt = 0;
        class_4604 cullingFrustum = ((LevelRendererAccessor)class_310.method_1551().field_1769).getCullingFrustum();
        ShaderProp shaderProp = new ShaderProp().setViewMatrix(viewMatrix);
        int maxRailDistance = MTRClient.isReplayMod() ? 1024 : UtilitiesClient.getRenderDistance() * 16;
        boolean isOutsideRenderDistance = false;
        Iterator<RailChunkBase> it = this.railChunkList.iterator();
        while (it.hasNext()) {
            RailChunkBase chunk2 = it.next();
            if (chunk2.containingRails.isEmpty()) {
                chunk2.close();
                it.remove();
                this.railChunkMap.get(chunk2.modelKey).remove(chunk2.chunkId);
                continue;
            }
            if (isOutsideRenderDistance) continue;
            if (chunk2.cameraDistManhattanXZ > (double)maxRailDistance) {
                isOutsideRenderDistance = true;
                continue;
            }
            if (chunk2.isDirty || !chunk2.bufferBuilt) {
                if (MTRClient.isReplayMod() || buffersRebuilt < 1) {
                    chunk2.rebuildBuffer(level);
                }
                ++buffersRebuilt;
            }
            if (!chunk2.bufferBuilt || !cullingFrustum.method_23093(chunk2.boundingBox)) continue;
            chunk2.enqueue(batchManager, shaderProp);
        }
    }

    public void drawRailNodes(class_1937 level, DrawScheduler drawScheduler, Matrix4f viewMatrix) {
        if (isHoldingRailItemOrBrush) {
            HashSet<class_2338> drawnNodes = new HashSet<class_2338>();
            for (Map.Entry entryStart : ClientData.RAILS.entrySet()) {
                for (Map.Entry entryEnd : ((Map)entryStart.getValue()).entrySet()) {
                    int light;
                    Matrix4f nodePose;
                    if (drawnNodes.add((class_2338)entryStart.getKey())) {
                        nodePose = viewMatrix.copy();
                        nodePose.translate((float)((class_2338)entryStart.getKey()).method_10263() + 0.5f, ((class_2338)entryStart.getKey()).method_10264(), (float)((class_2338)entryStart.getKey()).method_10260() + 0.5f);
                        nodePose.rotateY(-((float)((Rail)entryEnd.getValue()).facingStart.angleRadians) + 1.5707964f);
                        light = class_765.method_23687((int)level.method_8314(class_1944.field_9282, (class_2338)entryStart.getKey()), (int)level.method_8314(class_1944.field_9284, (class_2338)entryStart.getKey()));
                        drawScheduler.enqueue(RailModelRegistry.railNodeModel, nodePose, light);
                    }
                    if (!drawnNodes.add((class_2338)entryEnd.getKey())) continue;
                    nodePose = viewMatrix.copy();
                    nodePose.translate((float)((class_2338)entryEnd.getKey()).method_10263() + 0.5f, ((class_2338)entryEnd.getKey()).method_10264(), (float)((class_2338)entryEnd.getKey()).method_10260() + 0.5f);
                    nodePose.rotateY(-((float)((Rail)entryEnd.getValue()).facingEnd.angleRadians) + 1.5707964f);
                    light = class_765.method_23687((int)level.method_8314(class_1944.field_9282, (class_2338)entryEnd.getKey()), (int)level.method_8314(class_1944.field_9284, (class_2338)entryEnd.getKey()));
                    drawScheduler.enqueue(RailModelRegistry.railNodeModel, nodePose, light);
                }
            }
        }
    }

    public static String getModelKeyForRender(Rail rail) {
        String customModelKey = ((RailExtraSupplier)rail).getModelKey();
        if (customModelKey.equals("") || !RailModelRegistry.elements.containsKey(customModelKey)) {
            if (rail.transportMode == TransportMode.TRAIN) {
                if (rail.railType == RailType.SIDING) {
                    return "nte_builtin_depot";
                }
                return "nte_builtin_concrete_sleeper";
            }
            return "";
        }
        if (customModelKey.equals("null")) {
            return isHoldingRailItem ? "" : "null";
        }
        return customModelKey;
    }

    public void drawBoundingBoxes(class_4587 matrixStack, class_4588 buffer) {
        for (RailChunkBase chunk : this.railChunkList) {
            boolean isChunkEven = chunk.isEven();
            class_761.method_22982((class_4587)matrixStack, (class_4588)buffer, (class_238)chunk.boundingBox, (float)1.0f, (float)(isChunkEven ? 1.0f : 0.0f), (float)(isChunkEven ? 0.0f : 1.0f), (float)1.0f);
        }
    }
}

