/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.scripting;

import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.mtrsteamloco.MainClient;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.AbstractScriptContext;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.ScriptContextManager;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.ScriptResourceUtil;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.util.CycleTracker;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.util.GraphicsTexture;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.util.MinecraftClientUtil;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.util.RateLimit;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.util.StateTracker;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.util.TextUtil;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.util.TimingUtil;
import fabric.cn.zbx1425.sowcer.math.Matrices;
import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.model.RawMesh;
import fabric.cn.zbx1425.sowcerext.model.RawModel;
import fabric.cn.zbx1425.sowcerext.model.integration.RawMeshBuilder;
import fabric.cn.zbx1425.sowcerext.util.ResourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mtr.client.ClientData;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Context;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Function;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.ImporterTopLevel;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.NativeJavaClass;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.NativeJavaMethod;
import vendor.cn.zbx1425.mtrsteamloco.org.mozilla.javascript.Scriptable;

public class ScriptHolder {
    private static ExecutorService SCRIPT_THREAD = Executors.newSingleThreadExecutor();
    private Scriptable scope;
    private final List<Function> createFunctions = new ArrayList<Function>();
    private final List<Function> renderFunctions = new ArrayList<Function>();
    private final List<Function> disposeFunctions = new ArrayList<Function>();
    public long failTime = 0L;
    public Exception failException = null;
    public String name;
    public String contextTypeName;
    private Map<class_2960, String> scripts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String name, String contextTypeName, class_3300 resourceManager, Map<class_2960, String> scripts) throws Exception {
        this.name = name;
        this.contextTypeName = contextTypeName;
        this.scripts = scripts;
        Context rhinoCtx = Context.enter();
        rhinoCtx.setLanguageVersion(200);
        try {
            this.scope = new ImporterTopLevel(rhinoCtx);
            this.scope.put("include", this.scope, (Object)new NativeJavaMethod(ScriptResourceUtil.class.getMethod("includeScript", Object.class), "includeScript"));
            this.scope.put("print", this.scope, (Object)new NativeJavaMethod(ScriptResourceUtil.class.getMethod("print", Object[].class), "print"));
            this.scope.put("ModelManager", this.scope, (Object)Context.toObject(MainClient.modelManager, this.scope));
            this.scope.put("Resources", this.scope, (Object)new NativeJavaClass(this.scope, ScriptResourceUtil.class));
            this.scope.put("GraphicsTexture", this.scope, (Object)new NativeJavaClass(this.scope, GraphicsTexture.class));
            this.scope.put("Timing", this.scope, (Object)new NativeJavaClass(this.scope, TimingUtil.class));
            this.scope.put("StateTracker", this.scope, (Object)new NativeJavaClass(this.scope, StateTracker.class));
            this.scope.put("CycleTracker", this.scope, (Object)new NativeJavaClass(this.scope, CycleTracker.class));
            this.scope.put("RateLimit", this.scope, (Object)new NativeJavaClass(this.scope, RateLimit.class));
            this.scope.put("TextUtil", this.scope, (Object)new NativeJavaClass(this.scope, TextUtil.class));
            this.scope.put("RawModel", this.scope, (Object)new NativeJavaClass(this.scope, RawModel.class));
            this.scope.put("RawMesh", this.scope, (Object)new NativeJavaClass(this.scope, RawMesh.class));
            this.scope.put("RawMeshBuilder", this.scope, (Object)new NativeJavaClass(this.scope, RawMeshBuilder.class));
            this.scope.put("Matrices", this.scope, (Object)new NativeJavaClass(this.scope, Matrices.class));
            this.scope.put("Matrix4f", this.scope, (Object)new NativeJavaClass(this.scope, Matrix4f.class));
            this.scope.put("Vector3f", this.scope, (Object)new NativeJavaClass(this.scope, Vector3f.class));
            this.scope.put("MTRClientData", this.scope, (Object)new NativeJavaClass(this.scope, ClientData.class));
            this.scope.put("MinecraftClient", this.scope, (Object)new NativeJavaClass(this.scope, MinecraftClientUtil.class));
            try {
                String[] classesToLoad;
                for (String classToLoad : classesToLoad = new String[]{"util.AddParticleHelper", "particle.MadParticleOption", "particle.SpriteFrom", "command.inheritable.InheritableBoolean", "particle.ParticleRenderTypes", "particle.ChangeMode"}) {
                    Class<?> classToLoadClass = Class.forName("cn.ussshenzhou.madparticle." + classToLoad);
                    this.scope.put(classToLoad.substring(classToLoad.lastIndexOf(".") + 1), this.scope, (Object)new NativeJavaClass(this.scope, classToLoadClass));
                }
                this.scope.put("foundMadParticle", this.scope, (Object)true);
            }
            catch (ClassNotFoundException ignored) {
                this.scope.put("foundMadParticle", this.scope, (Object)false);
            }
            this.scope.put("CompoundTag", this.scope, (Object)new NativeJavaClass(this.scope, class_2487.class));
            rhinoCtx.evaluateString(this.scope, "\"use strict\"", "", 1, null);
            ScriptResourceUtil.activeContext = rhinoCtx;
            ScriptResourceUtil.activeScope = this.scope;
            for (Map.Entry<class_2960, String> entry : scripts.entrySet()) {
                String scriptStr = entry.getValue() == null ? ResourceUtil.readResource(resourceManager, entry.getKey()) : entry.getValue();
                ScriptResourceUtil.executeScript(rhinoCtx, this.scope, entry.getKey(), scriptStr);
                this.acquireFunction("create", this.createFunctions);
                this.acquireFunction("create" + contextTypeName, this.createFunctions);
                this.acquireFunction("render", this.renderFunctions);
                this.acquireFunction("render" + contextTypeName, this.renderFunctions);
                this.acquireFunction("dispose", this.disposeFunctions);
                this.acquireFunction("dispose" + contextTypeName, this.disposeFunctions);
            }
            ScriptResourceUtil.activeContext = null;
            ScriptResourceUtil.activeScope = null;
        }
        finally {
            Context.exit();
        }
    }

    public void reload(class_3300 resourceManager) throws Exception {
        this.load(this.name, this.contextTypeName, resourceManager, this.scripts);
    }

    private void acquireFunction(String functionName, List<Function> target) {
        Object jsFunction = this.scope.get(functionName, this.scope);
        if (jsFunction != Scriptable.NOT_FOUND) {
            if (jsFunction instanceof Function) {
                target.add((Function)jsFunction);
            }
            this.scope.delete(functionName);
        }
    }

    public Future<?> callFunctionAsync(List<Function> functions, AbstractScriptContext scriptCtx, Runnable finishCallback) {
        if (this.duringFailTimeout()) {
            return null;
        }
        this.failTime = 0L;
        return SCRIPT_THREAD.submit(() -> {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Context rhinoCtx = Context.enter();
            if (scriptCtx.state == null) {
                scriptCtx.state = rhinoCtx.newObject(this.scope);
            }
            try {
                long startTime = System.nanoTime();
                TimingUtil.prepareForScript(scriptCtx);
                Object[] functionParam = new Object[]{scriptCtx, scriptCtx.state, scriptCtx.getWrapperObject()};
                for (Function function : functions) {
                    function.call(rhinoCtx, this.scope, this.scope, functionParam);
                }
                if (finishCallback != null) {
                    finishCallback.run();
                }
                scriptCtx.lastExecuteDuration = System.nanoTime() - startTime;
            }
            catch (Exception ex) {
                Main.LOGGER.error("Error in NTE Resource Pack JavaScript", (Throwable)ex);
                this.failTime = System.currentTimeMillis();
                this.failException = ex;
            }
            finally {
                Context.exit();
            }
        });
    }

    public void tryCallRenderFunctionAsync(AbstractScriptContext scriptCtx) {
        block7: {
            block6: {
                if (scriptCtx.scriptStatus != null && !scriptCtx.scriptStatus.isDone()) {
                    return;
                }
                if (scriptCtx.disposed) {
                    return;
                }
                if (!scriptCtx.created) {
                    ScriptContextManager.trackContext(scriptCtx, this);
                    scriptCtx.scriptStatus = this.callFunctionAsync(this.createFunctions, scriptCtx, () -> {
                        scriptCtx.created = true;
                    });
                    return;
                }
                if (scriptCtx.scriptStatus == null) break block6;
                if (!scriptCtx.scriptStatus.isDone()) break block7;
            }
            scriptCtx.scriptStatus = this.callFunctionAsync(this.renderFunctions, scriptCtx, scriptCtx::renderFunctionFinished);
        }
    }

    public void tryCallDisposeFunctionAsync(AbstractScriptContext scriptCtx) {
        if (scriptCtx.scriptStatus != null && !scriptCtx.scriptStatus.isDone()) {
            return;
        }
        scriptCtx.disposed = true;
        if (scriptCtx.created) {
            scriptCtx.scriptStatus = this.callFunctionAsync(this.disposeFunctions, scriptCtx, () -> {
                scriptCtx.created = false;
            });
        }
    }

    private boolean duringFailTimeout() {
        return this.failTime > 0L && System.currentTimeMillis() - this.failTime < 4000L;
    }

    public static void resetRunner() {
        SCRIPT_THREAD.shutdownNow();
        SCRIPT_THREAD = Executors.newSingleThreadExecutor();
    }
}

