/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.scripting.eyecandy;

import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.model.ModelCluster;
import fabric.cn.zbx1425.sowcerext.reuse.DrawScheduler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_638;

public class EyeCandyDrawCalls {
    private final List<ClusterDrawCall> drawList = new ArrayList<ClusterDrawCall>();
    private final List<PlaySoundCall> soundList = new ArrayList<PlaySoundCall>();

    public void addModel(ModelCluster model, Matrix4f pose) {
        this.drawList.add(new ClusterDrawCall(model, pose));
    }

    public void addSound(class_3414 sound, float volume, float pitch) {
        this.soundList.add(new PlaySoundCall(sound, volume, pitch));
    }

    public void commit(DrawScheduler drawScheduler, Matrix4f basePose, int light) {
        for (ClusterDrawCall clusterDrawCall : this.drawList) {
            Matrix4f finalPose = basePose.copy();
            finalPose.multiply(clusterDrawCall.pose);
            drawScheduler.enqueue(clusterDrawCall.model, finalPose, light);
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        for (PlaySoundCall playSoundCall : this.soundList) {
            Vector3f worldPos = basePose.transform(Vector3f.ZERO);
            level.method_8486((double)worldPos.x(), (double)worldPos.y(), (double)worldPos.z(), playSoundCall.sound, class_3419.field_15245, playSoundCall.volume, playSoundCall.pitch, false);
        }
    }

    public void reset() {
        this.drawList.clear();
        this.soundList.clear();
    }

    private static class ClusterDrawCall {
        public ModelCluster model;
        public Matrix4f pose;

        public ClusterDrawCall(ModelCluster model, Matrix4f pose) {
            this.model = model;
            this.pose = pose;
        }
    }

    private static class PlaySoundCall {
        public class_3414 sound;
        public float volume;
        public float pitch;

        public PlaySoundCall(class_3414 sound, float volume, float pitch) {
            this.sound = sound;
            this.volume = volume;
            this.pitch = pitch;
        }
    }
}

