/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.scripting.train;

import fabric.cn.zbx1425.mtrsteamloco.MainClient;
import fabric.cn.zbx1425.mtrsteamloco.render.RenderUtil;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.ScriptHolder;
import fabric.cn.zbx1425.mtrsteamloco.render.scripting.train.TrainScriptContext;
import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcer.math.PoseStackUtil;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import mtr.data.TrainClient;
import mtr.render.TrainRendererBase;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_765;

public class ScriptedTrainRenderer
extends TrainRendererBase {
    public final ScriptHolder typeScripting;
    public final TrainRendererBase baseRenderer;
    private final TrainClient train;
    private final TrainScriptContext trainScripting;

    public ScriptedTrainRenderer(ScriptHolder typeScripting, TrainRendererBase baseRenderer) {
        this.typeScripting = typeScripting;
        this.baseRenderer = baseRenderer;
        this.train = null;
        this.trainScripting = null;
    }

    private ScriptedTrainRenderer(ScriptedTrainRenderer base, TrainClient trainClient) {
        this.typeScripting = base.typeScripting;
        this.baseRenderer = base.baseRenderer == null ? null : base.baseRenderer.createTrainInstance(trainClient);
        this.train = trainClient;
        this.trainScripting = new TrainScriptContext(trainClient);
    }

    public TrainRendererBase createTrainInstance(TrainClient trainClient) {
        ScriptedTrainRenderer result = new ScriptedTrainRenderer(this, trainClient);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderCar(int carIndex, double x, double y, double z, float yaw, float pitch, boolean doorLeftOpen, boolean doorRightOpen) {
        boolean shouldRender;
        assert (this.train != null && this.trainScripting != null);
        boolean bl = shouldRender = !RenderUtil.shouldSkipRenderTrain(this.train);
        if (shouldRender && this.baseRenderer != null) {
            this.baseRenderer.renderCar(carIndex, x, y, z, yaw, pitch, doorLeftOpen, doorRightOpen);
        }
        if (isTranslucentBatch) {
            return;
        }
        class_2338 posAverage = ScriptedTrainRenderer.applyAverageTransform((class_243)this.train.getViewOffset(), (double)x, (double)y, (double)z);
        Vector3f carPos = new Vector3f((float)x, (float)y, (float)z);
        class_243 offset = this.train.vehicleRidingClient.getVehicleOffset();
        if (offset != null) {
            carPos.add((float)offset.field_1352, (float)offset.field_1351, (float)offset.field_1350);
        }
        boolean hasPitch = pitch < 0.0f ? this.train.transportMode.hasPitchAscending : this.train.transportMode.hasPitchDescending;
        Matrix4f worldPose = new Matrix4f();
        worldPose.translate(carPos.x(), carPos.y(), carPos.z());
        worldPose.rotateY((float)Math.PI + yaw);
        worldPose.rotateX(hasPitch ? pitch : 0.0f);
        this.trainScripting.trainExtraWriting.doorLeftOpen[carIndex] = doorLeftOpen;
        this.trainScripting.trainExtraWriting.doorRightOpen[carIndex] = doorRightOpen;
        this.trainScripting.trainExtraWriting.lastWorldPose[carIndex] = worldPose;
        this.trainScripting.trainExtraWriting.lastCarPosition[carIndex] = carPos.copy();
        this.trainScripting.trainExtraWriting.lastCarRotation[carIndex] = new Vector3f(hasPitch ? pitch : 0.0f, (float)Math.PI + yaw, 0.0f);
        this.trainScripting.trainExtraWriting.isInDetailDistance = this.trainScripting.trainExtraWriting.isInDetailDistance | (posAverage != null && posAverage.method_10262((class_2382)camera.method_19328()) <= 1024.0);
        this.trainScripting.trainExtraWriting.shouldRender = shouldRender;
        if (posAverage == null) {
            if (carIndex == this.train.trainCars - 1) {
                this.trainScripting.extraFinished();
                this.typeScripting.tryCallRenderFunctionAsync(this.trainScripting);
            }
            return;
        }
        matrices.method_22904(x, y, z);
        PoseStackUtil.rotY(matrices, (float)Math.PI + yaw);
        PoseStackUtil.rotX(matrices, hasPitch ? pitch : 0.0f);
        int light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, posAverage), (int)world.method_8314(class_1944.field_9284, posAverage));
        Matrix4f drawPose = new Matrix4f(matrices.method_23760().method_23761());
        if (shouldRender) {
            TrainScriptContext trainScriptContext = this.trainScripting;
            synchronized (trainScriptContext) {
                this.trainScripting.scriptResult.commitCar(carIndex, MainClient.drawScheduler, drawPose, worldPose, light);
            }
        }
        matrices.method_22909();
        if (carIndex == this.train.trainCars - 1) {
            this.trainScripting.extraFinished();
            this.typeScripting.tryCallRenderFunctionAsync(this.trainScripting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderConnection(class_243 prevPos1, class_243 prevPos2, class_243 prevPos3, class_243 prevPos4, class_243 thisPos1, class_243 thisPos2, class_243 thisPos3, class_243 thisPos4, double x, double y, double z, float yaw, float pitch) {
        assert (this.train != null && this.trainScripting != null);
        if (RenderUtil.shouldSkipRenderTrain(this.train)) {
            return;
        }
        if (this.baseRenderer != null) {
            this.baseRenderer.renderConnection(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, x, y, z, yaw, pitch);
        }
        if (isTranslucentBatch) {
            return;
        }
        class_2338 posAverage = ScriptedTrainRenderer.applyAverageTransform((class_243)this.train.getViewOffset(), (double)x, (double)y, (double)z);
        if (posAverage == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(x, y, z);
        PoseStackUtil.rotY(matrices, (float)Math.PI + yaw);
        boolean hasPitch = pitch < 0.0f ? this.train.transportMode.hasPitchAscending : this.train.transportMode.hasPitchDescending;
        PoseStackUtil.rotX(matrices, hasPitch ? pitch : 0.0f);
        int light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, posAverage), (int)world.method_8314(class_1944.field_9284, posAverage));
        Matrix4f pose = new Matrix4f(matrices.method_23760().method_23761());
        TrainScriptContext trainScriptContext = this.trainScripting;
        synchronized (trainScriptContext) {
            this.trainScripting.scriptResult.commitConn(0, MainClient.drawScheduler, pose, light);
            matrices.method_22909();
            this.trainScripting.scriptResult.commitConnImmediate(0, matrices, vertexConsumers, prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, light);
        }
        matrices.method_22909();
    }

    public void renderBarrier(class_243 prevPos1, class_243 prevPos2, class_243 prevPos3, class_243 prevPos4, class_243 thisPos1, class_243 thisPos2, class_243 thisPos3, class_243 thisPos4, double x, double y, double z, float yaw, float pitch) {
        assert (this.train != null && this.trainScripting != null);
        if (RenderUtil.shouldSkipRenderTrain(this.train)) {
            return;
        }
        if (this.baseRenderer != null) {
            this.baseRenderer.renderBarrier(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, x, y, z, yaw, pitch);
        }
    }
}

