/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.scripting.train;

import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.model.ModelCluster;
import fabric.cn.zbx1425.sowcerext.reuse.DrawScheduler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mtr.client.IDrawing;
import mtr.render.MoreRenderLayers;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;

public class TrainDrawCalls {
    private final List<ClusterDrawCall>[] carDrawLists;
    private final List<ClusterDrawCall>[] connDrawLists;
    private final class_2960[] connStretchTextures;
    private final List<PlayCarSoundCall>[] carSoundLists;

    public TrainDrawCalls(int carCount) {
        this.carDrawLists = new List[carCount];
        Arrays.setAll(this.carDrawLists, ignored -> new ArrayList());
        this.connDrawLists = new List[carCount - 1];
        Arrays.setAll(this.connDrawLists, ignored -> new ArrayList());
        this.connStretchTextures = new class_2960[carCount - 1];
        this.carSoundLists = new List[carCount];
        Arrays.setAll(this.carSoundLists, ignored -> new ArrayList());
    }

    public void addCarModel(int car, ModelCluster model, Matrix4f pose) {
        this.carDrawLists[car].add(new ClusterDrawCall(model, pose));
    }

    public void addCarSound(int car, class_3414 sound, Vector3f position, float volume, float pitch) {
        this.carSoundLists[car].add(new PlayCarSoundCall(sound, position, volume, pitch));
    }

    public void commitCar(int car, DrawScheduler drawScheduler, Matrix4f basePose, Matrix4f worldPose, int light) {
        for (ClusterDrawCall clusterDrawCall : this.carDrawLists[car]) {
            Matrix4f finalPose = basePose.copy();
            finalPose.multiply(clusterDrawCall.pose);
            drawScheduler.enqueue(clusterDrawCall.model, finalPose, light);
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        for (PlayCarSoundCall playCarSoundCall : this.carSoundLists[car]) {
            Vector3f worldPos = worldPose.transform(playCarSoundCall.position);
            level.method_8486((double)worldPos.x(), (double)worldPos.y(), (double)worldPos.z(), playCarSoundCall.sound, class_3419.field_15245, playCarSoundCall.volume, playCarSoundCall.pitch, false);
        }
    }

    public void addConnModel(int car, ModelCluster model, Matrix4f pose) {
        this.connDrawLists[car].add(new ClusterDrawCall(model, pose));
    }

    public void drawConnStretchTexture(int car, class_2960 texture) {
        this.connStretchTextures[car] = texture;
    }

    public void commitConn(int car, DrawScheduler drawScheduler, Matrix4f basePose, int light) {
        for (ClusterDrawCall clusterDrawCall : this.connDrawLists[car]) {
            Matrix4f finalPose = basePose.copy();
            finalPose.multiply(clusterDrawCall.pose);
            drawScheduler.enqueue(clusterDrawCall.model, finalPose, light);
        }
    }

    public void commitConnImmediate(int car, class_4587 matrices, class_4597 vertexConsumers, class_243 prevPos1, class_243 prevPos2, class_243 prevPos3, class_243 prevPos4, class_243 thisPos1, class_243 thisPos2, class_243 thisPos3, class_243 thisPos4, int light) {
        if (this.connStretchTextures[car] != null) {
            class_4588 vertexConsumerExterior = vertexConsumers.getBuffer(MoreRenderLayers.getExterior((class_2960)this.connStretchTextures[car]));
            TrainDrawCalls.drawTexture(matrices, vertexConsumerExterior, thisPos2, prevPos3, prevPos4, thisPos1, 0.0f, 0.0f, 0.5f, 0.5f, light);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerExterior, prevPos2, thisPos3, thisPos4, prevPos1, 0.0f, 0.0f, 0.5f, 0.5f, light);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerExterior, prevPos3, thisPos2, thisPos3, prevPos2, 0.0f, 0.0f, 0.5f, 0.5f, light);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerExterior, prevPos1, thisPos4, thisPos1, prevPos4, 0.0f, 0.0f, 0.5f, 0.5f, light);
            int lightOnLevel = 0xF000F0;
            class_4588 vertexConsumerSide = vertexConsumers.getBuffer(MoreRenderLayers.getInterior((class_2960)this.connStretchTextures[car]));
            TrainDrawCalls.drawTexture(matrices, vertexConsumerSide, thisPos3, prevPos2, prevPos1, thisPos4, 0.5f, 0.0f, 1.0f, 0.5f, lightOnLevel);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerSide, prevPos3, thisPos2, thisPos1, prevPos4, 0.5f, 0.0f, 1.0f, 0.5f, lightOnLevel);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerSide, prevPos2, thisPos3, thisPos2, prevPos3, 0.0f, 0.5f, 0.5f, 1.0f, lightOnLevel);
            TrainDrawCalls.drawTexture(matrices, vertexConsumerSide, prevPos4, thisPos1, thisPos4, prevPos1, 0.5f, 0.5f, 1.0f, 1.0f, lightOnLevel);
        }
    }

    private static void drawTexture(class_4587 matrices, class_4588 vertexConsumer, class_243 pos1, class_243 pos2, class_243 pos3, class_243 pos4, float u1, float v1, float u2, float v2, int light) {
        IDrawing.drawTexture((class_4587)matrices, (class_4588)vertexConsumer, (float)((float)pos1.field_1352), (float)((float)pos1.field_1351), (float)((float)pos1.field_1350), (float)((float)pos2.field_1352), (float)((float)pos2.field_1351), (float)((float)pos2.field_1350), (float)((float)pos3.field_1352), (float)((float)pos3.field_1351), (float)((float)pos3.field_1350), (float)((float)pos4.field_1352), (float)((float)pos4.field_1351), (float)((float)pos4.field_1350), (float)u1, (float)v1, (float)u2, (float)v2, (class_2350)class_2350.field_11036, (int)-1, (int)light);
    }

    public void reset() {
        for (List<ClusterDrawCall> list : this.carDrawLists) {
            list.clear();
        }
        for (List<ClusterDrawCall> list : this.connDrawLists) {
            list.clear();
        }
        for (List<Object> list : this.carSoundLists) {
            list.clear();
        }
        Arrays.fill(this.connStretchTextures, null);
    }

    private static class ClusterDrawCall {
        public ModelCluster model;
        public Matrix4f pose;

        public ClusterDrawCall(ModelCluster model, Matrix4f pose) {
            this.model = model;
            this.pose = pose;
        }
    }

    private static class PlayCarSoundCall {
        public class_3414 sound;
        public Vector3f position;
        public float volume;
        public float pitch;

        public PlayCarSoundCall(class_3414 sound, Vector3f position, float volume, float pitch) {
            this.sound = sound;
            this.position = position;
            this.volume = volume;
            this.pitch = pitch;
        }
    }
}

