/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.scripting.util;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.cn.zbx1425.mtrsteamloco.mixin.NativeImageAccessor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.system.MemoryUtil;

public class GraphicsTexture
implements Closeable {
    private final class_1043 dynamicTexture;
    public final class_2960 identifier;
    public final BufferedImage bufferedImage;
    public final Graphics2D graphics;
    public final int width;
    public final int height;

    public GraphicsTexture(int width, int height) {
        this.width = width;
        this.height = height;
        this.dynamicTexture = new class_1043(new class_1011(width, height, false));
        this.identifier = new class_2960("mtrsteamloco", String.format("dynamic/graphics/%s", UUID.randomUUID()));
        class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(this.identifier, (class_1044)this.dynamicTexture));
        this.bufferedImage = new BufferedImage(width, height, 2);
        this.graphics = this.bufferedImage.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
    }

    public static BufferedImage createArgbBufferedImage(BufferedImage src) {
        BufferedImage newImage = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Graphics2D graphics = newImage.createGraphics();
        graphics.drawImage((Image)src, 0, 0, null);
        graphics.dispose();
        return newImage;
    }

    public void upload() {
        IntBuffer imgData = IntBuffer.wrap(((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData());
        long pixelAddr = ((NativeImageAccessor)this.dynamicTexture.method_4525()).getPixels();
        ByteBuffer target = MemoryUtil.memByteBuffer((long)pixelAddr, (int)(this.width * this.height * 4));
        for (int i = 0; i < this.width * this.height; ++i) {
            int pixel = imgData.get();
            target.put((byte)(pixel >> 16 & 0xFF));
            target.put((byte)(pixel >> 8 & 0xFF));
            target.put((byte)(pixel & 0xFF));
            target.put((byte)(pixel >> 24 & 0xFF));
        }
        RenderSystem.recordRenderCall(() -> ((class_1043)this.dynamicTexture).method_4524());
    }

    @Override
    public void close() {
        class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4615(this.identifier));
        this.graphics.dispose();
    }
}

