/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.mtrsteamloco.render.train;

import fabric.cn.zbx1425.mtrsteamloco.ClientConfig;
import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.mtrsteamloco.MainClient;
import fabric.cn.zbx1425.mtrsteamloco.render.RenderUtil;
import fabric.cn.zbx1425.mtrsteamloco.render.train.RenderTrainDK3;
import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcer.math.PoseStackUtil;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.multipart.MultipartContainer;
import fabric.cn.zbx1425.sowcerext.multipart.MultipartUpdateProp;
import fabric.cn.zbx1425.sowcerext.multipart.animated.AnimatedLoader;
import java.io.IOException;
import mtr.MTRClient;
import mtr.data.TrainClient;
import mtr.render.TrainRendererBase;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_765;

public class RenderTrainD51
extends TrainRendererBase {
    protected static MultipartContainer modelD51;
    private final TrainClient train;
    private final MultipartUpdateProp updateProp = new MultipartUpdateProp();
    private final TrainRendererBase trailingCarRenderer;
    private static int renderingCarNum;

    public static void initGLModel(class_3300 resourceManager) {
        try {
            MainClient.atlasManager.load(resourceManager, new class_2960("mtrsteamloco:models/atlas/d51.json"));
            modelD51 = AnimatedLoader.loadModel(resourceManager, MainClient.modelManager, MainClient.atlasManager, new class_2960("mtrsteamloco:models/d51/d51.animated"));
        }
        catch (IOException e) {
            modelD51 = null;
            Main.LOGGER.error("Failed loading model for D51:", (Throwable)e);
        }
    }

    public RenderTrainD51(TrainRendererBase trailingCarRenderer) {
        this.train = null;
        this.trailingCarRenderer = trailingCarRenderer;
    }

    private RenderTrainD51(TrainClient trainClient, TrainRendererBase trailingCarRenderer) {
        this.train = trainClient;
        this.trailingCarRenderer = trailingCarRenderer == null ? null : trailingCarRenderer.createTrainInstance(this.train);
    }

    public TrainRendererBase createTrainInstance(TrainClient trainClient) {
        return new RenderTrainD51(trainClient, this.trailingCarRenderer);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void renderCar(int carIndex, double x, double y, double z, float yaw, float pitch, boolean doorLeftOpen, boolean doorRightOpen) {
        int carNum;
        if (RenderUtil.shouldSkipRenderTrain(this.train)) {
            return;
        }
        renderingCarNum = carNum = !this.train.isReversed() ? carIndex : this.train.trainCars - carIndex - 1;
        if (this.trailingCarRenderer != null && carNum != 0) {
            int carNumToRender;
            matrices.method_22903();
            if (this.trailingCarRenderer instanceof RenderTrainDK3) {
                if (carNum == 1) {
                    carNumToRender = this.train.trainCars < 3 ? 1 : 0;
                } else {
                    if (carNum != 2) {
                        matrices.method_22909();
                        return;
                    }
                    carNumToRender = this.train.trainCars - 1;
                }
            } else {
                carNumToRender = carNum == this.train.trainCars - 1 ? carNum : carNum - 1;
            }
            int carIndexToRender = !this.train.isReversed() ? carNumToRender : this.train.trainCars - carNumToRender - 1;
            this.trailingCarRenderer.renderCar(carIndexToRender, x, y, z, yaw, pitch, doorLeftOpen, doorRightOpen);
            matrices.method_22909();
            return;
        }
        if (isTranslucentBatch) {
            return;
        }
        class_2338 posAverage = RenderTrainD51.applyAverageTransform((class_243)this.train.getViewOffset(), (double)x, (double)y, (double)z);
        if (posAverage == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(x, y - 1.0, z);
        PoseStackUtil.rotY(matrices, (float)Math.PI + yaw);
        boolean hasPitch = pitch < 0.0f ? this.train.transportMode.hasPitchAscending : this.train.transportMode.hasPitchDescending;
        PoseStackUtil.rotX(matrices, hasPitch ? pitch : 0.0f);
        if (this.train.isReversed()) {
            PoseStackUtil.rotY(matrices, (float)Math.PI);
        }
        int light = class_765.method_23687((int)world.method_8314(class_1944.field_9282, posAverage), (int)world.method_8314(class_1944.field_9284, posAverage));
        this.updateProp.update(this.train, carIndex, !this.train.isReversed());
        Matrix4f pose = new Matrix4f(matrices.method_23760().method_23761());
        modelD51.updateAndEnqueueAll(MainClient.drawScheduler, this.updateProp, pose, light);
        if (ClientConfig.enableSmoke && this.train.getIsOnRoute() && (int)MTRClient.getGameTick() % 4 == 0) {
            Vector3f smokeOrigin = new Vector3f(0.0f, 2.7f, 8.4f);
            Vector3f carPos = new Vector3f((float)x, (float)y, (float)z);
            class_243 offset = this.train.vehicleRidingClient.getVehicleOffset();
            if (offset != null) {
                carPos.add((float)offset.field_1352, (float)offset.field_1351, (float)offset.field_1350);
            }
            smokeOrigin.rotX(pitch);
            smokeOrigin.rotY((!this.train.isReversed() ? (float)Math.PI : 0.0f) + yaw);
            smokeOrigin.add(carPos);
            world.method_8406((class_2394)Main.PARTICLE_STEAM_SMOKE, (double)smokeOrigin.x(), (double)smokeOrigin.y(), (double)smokeOrigin.z(), 0.0, (double)0.7f, 0.0);
        }
        matrices.method_22909();
        matrices.method_22909();
    }

    public void renderConnection(class_243 prevPos1, class_243 prevPos2, class_243 prevPos3, class_243 prevPos4, class_243 thisPos1, class_243 thisPos2, class_243 thisPos3, class_243 thisPos4, double x, double y, double z, float yaw, float pitch) {
        if (this.trailingCarRenderer != null && renderingCarNum > 1) {
            this.trailingCarRenderer.renderConnection(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, x, y, z, yaw, pitch);
        }
    }

    public void renderBarrier(class_243 prevPos1, class_243 prevPos2, class_243 prevPos3, class_243 prevPos4, class_243 thisPos1, class_243 thisPos2, class_243 thisPos3, class_243 thisPos4, double x, double y, double z, float yaw, float pitch) {
        if (this.trailingCarRenderer != null && renderingCarNum > 1) {
            this.trailingCarRenderer.renderBarrier(prevPos1, prevPos2, prevPos3, prevPos4, thisPos1, thisPos2, thisPos3, thisPos4, x, y, z, yaw, pitch);
        }
    }

    static {
        renderingCarNum = 0;
    }
}

