/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcer.batch;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fabric.cn.zbx1425.sowcer.shader.BlazeRenderType;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class MaterialProp {
    public String shaderName;
    public class_2960 texture;
    public VertAttrState attrState = new VertAttrState();
    public boolean translucent = false;
    public boolean writeDepthBuf = true;
    public boolean billboard = false;
    public boolean cutoutHack = false;
    public int sheetElementsU = 0;
    public int sheetElementsV = 0;
    public static final class_2960 WHITE_TEXTURE_LOCATION = new class_2960("minecraft:textures/misc/white.png");

    public MaterialProp() {
    }

    public MaterialProp(String shaderName) {
        this.shaderName = shaderName;
    }

    public MaterialProp(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        String content = new String(dis.readNBytes(len), StandardCharsets.UTF_8);
        JsonObject mtlObj = (JsonObject)new JsonParser().parse(content);
        this.shaderName = mtlObj.get("shaderName").getAsString();
        this.texture = mtlObj.get("texture").isJsonNull() ? null : new class_2960(mtlObj.get("texture").getAsString());
        this.attrState.color = mtlObj.get("color").isJsonNull() ? null : Integer.valueOf(mtlObj.get("color").getAsInt());
        this.attrState.lightmapUV = mtlObj.get("lightmapUV").isJsonNull() ? null : Integer.valueOf(mtlObj.get("lightmapUV").getAsInt());
        this.translucent = mtlObj.has("translucent") && mtlObj.get("translucent").getAsBoolean();
        this.writeDepthBuf = mtlObj.has("writeDepthBuf") && mtlObj.get("writeDepthBuf").getAsBoolean();
        this.billboard = mtlObj.has("billboard") && mtlObj.get("billboard").getAsBoolean();
        this.cutoutHack = mtlObj.has("cutoutHack") && mtlObj.get("cutoutHack").getAsBoolean();
    }

    public void setupCompositeState() {
        if (this.texture != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)WHITE_TEXTURE_LOCATION);
        }
        if (this.translucent || this.cutoutHack) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        } else {
            RenderSystem.disableBlend();
        }
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.enableCull();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_310.method_1551().field_1773.method_22975().method_23209();
        RenderSystem.depthMask((boolean)this.writeDepthBuf);
    }

    public class_1921 getBlazeRenderType() {
        class_2960 textureToUse = this.texture == null ? WHITE_TEXTURE_LOCATION : this.texture;
        return switch (this.shaderName) {
            case "rendertype_entity_cutout" -> BlazeRenderType.entityCutout(textureToUse);
            case "rendertype_entity_translucent_cull" -> BlazeRenderType.entityTranslucentCull(textureToUse);
            case "rendertype_beacon_beam" -> BlazeRenderType.beaconBeam(textureToUse, this.translucent);
            default -> BlazeRenderType.entityCutout(textureToUse);
        };
    }

    public MaterialProp copy() {
        MaterialProp result = new MaterialProp();
        result.copyFrom(this);
        return result;
    }

    public void copyFrom(MaterialProp other) {
        this.shaderName = other.shaderName;
        this.texture = other.texture;
        this.attrState = other.attrState.copy();
        this.translucent = other.translucent;
        this.writeDepthBuf = other.writeDepthBuf;
        this.billboard = other.billboard;
        this.sheetElementsU = other.sheetElementsU;
        this.sheetElementsV = other.sheetElementsV;
    }

    public void serializeTo(DataOutputStream dos) throws IOException {
        JsonObject mtlObj = new JsonObject();
        mtlObj.addProperty("version", (Number)2);
        mtlObj.addProperty("shaderName", this.shaderName);
        if (this.texture == null) {
            mtlObj.add("texture", (JsonElement)new JsonNull());
        } else {
            mtlObj.addProperty("texture", this.texture.toString());
        }
        if (this.attrState.color == null) {
            mtlObj.add("color", (JsonElement)new JsonNull());
        } else {
            mtlObj.addProperty("color", (Number)this.attrState.color);
        }
        if (this.attrState.lightmapUV == null) {
            mtlObj.add("lightmapUV", (JsonElement)new JsonNull());
        } else {
            mtlObj.addProperty("lightmapUV", (Number)this.attrState.lightmapUV);
        }
        mtlObj.addProperty("translucent", Boolean.valueOf(this.translucent));
        mtlObj.addProperty("writeDepthBuf", Boolean.valueOf(this.writeDepthBuf));
        mtlObj.addProperty("billboard", Boolean.valueOf(this.billboard));
        mtlObj.addProperty("cutoutHack", Boolean.valueOf(this.cutoutHack));
        String content = mtlObj.toString();
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        dos.writeInt(contentBytes.length);
        dos.write(contentBytes);
    }

    public String toString() {
        return String.format("{%s: %s%s}", this.texture == null ? "null" : this.texture.toString(), this.translucent ? " T-" : "", this.shaderName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterialProp that = (MaterialProp)o;
        return this.translucent == that.translucent && this.writeDepthBuf == that.writeDepthBuf && this.billboard == that.billboard && this.cutoutHack == that.cutoutHack && this.sheetElementsU == that.sheetElementsU && this.sheetElementsV == that.sheetElementsV && Objects.equals(this.shaderName, that.shaderName) && Objects.equals(this.texture, that.texture) && Objects.equals(this.attrState, that.attrState);
    }

    public int hashCode() {
        return Objects.hash(this.shaderName, this.texture, this.attrState, this.translucent, this.writeDepthBuf, this.billboard, this.cutoutHack, this.sheetElementsU, this.sheetElementsV);
    }
}

