/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcer.math;

import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import java.util.Stack;

public class Matrices {
    private final Stack<Matrix4f> stack = new Stack();

    public Matrices() {
        this.stack.push(new Matrix4f());
    }

    public void translate(double x, double y, double z) {
        this.translate((float)x, (float)y, (float)z);
    }

    public void translate(float x, float y, float z) {
        this.stack.peek().translate(x, y, z);
    }

    public void rotate(float x, float y, float z, float radian) {
        this.stack.peek().rotate(new Vector3f(x, y, z), radian);
    }

    public void rotateX(float radian) {
        this.stack.peek().rotateX(radian);
    }

    public void rotateY(float radian) {
        this.stack.peek().rotateY(radian);
    }

    public void rotateZ(float radian) {
        this.stack.peek().rotateZ(radian);
    }

    public void pushPose() {
        this.stack.push(this.stack.peek().copy());
    }

    public void popPose() {
        this.stack.pop();
    }

    public void popPushPose() {
        this.stack.pop();
        this.stack.push(this.stack.peek().copy());
    }

    public Matrix4f last() {
        return this.stack.peek();
    }

    public boolean clear() {
        return this.stack.size() == 1;
    }

    public void setIdentity() {
        this.stack.pop();
        this.stack.push(new Matrix4f());
    }
}

