/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcer.object;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.cn.zbx1425.sowcer.batch.MaterialProp;
import fabric.cn.zbx1425.sowcer.model.Mesh;
import fabric.cn.zbx1425.sowcer.object.IndexBuf;
import fabric.cn.zbx1425.sowcer.object.InstanceBuf;
import fabric.cn.zbx1425.sowcer.util.GlStateTracker;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrMapping;
import java.io.Closeable;
import org.lwjgl.opengl.GL33;

public class VertArray
implements Closeable {
    public int id;
    public MaterialProp materialProp;
    public IndexBuf indexBuf;
    public InstanceBuf instanceBuf;
    public VertAttrMapping mapping;

    public VertArray() {
        this.id = GL33.glGenVertexArrays();
    }

    private VertArray(VertArray other) {
        this.id = other.id;
        this.materialProp = other.materialProp;
        this.indexBuf = other.indexBuf;
        this.instanceBuf = other.instanceBuf;
        this.mapping = other.mapping;
    }

    public void create(Mesh mesh, VertAttrMapping mapping, InstanceBuf instanceBuf) {
        this.materialProp = mesh.materialProp;
        this.indexBuf = mesh.indexBuf;
        this.instanceBuf = instanceBuf;
        this.mapping = mapping;
        GL33.glBindVertexArray((int)this.id);
        mapping.setupAttrsToVao(mesh.vertBuf, instanceBuf);
        mesh.indexBuf.bind(34963);
        VertArray.unbind();
    }

    public void bind() {
        GlStateTracker.assertProtected();
        GL33.glBindVertexArray((int)this.id);
    }

    public static void unbind() {
        GlStateTracker.assertProtected();
        GL33.glBindVertexArray((int)0);
    }

    public void draw() {
        if (this.instanceBuf == null) {
            GL33.glDrawElements((int)4, (int)this.indexBuf.vertexCount, (int)this.indexBuf.indexType, (long)0L);
        } else {
            if (this.instanceBuf.size < 1) {
                return;
            }
            GL33.glDrawElementsInstanced((int)4, (int)this.indexBuf.vertexCount, (int)this.indexBuf.indexType, (long)0L, (int)this.instanceBuf.size);
        }
    }

    public int getFaceCount() {
        return this.indexBuf.faceCount * (this.instanceBuf == null ? 1 : this.instanceBuf.size);
    }

    public VertArray copyForMaterialChanges() {
        VertArray result = new VertArray(this);
        result.materialProp = result.materialProp.copy();
        return result;
    }

    @Override
    public void close() {
        if (RenderSystem.isOnRenderThread()) {
            GL33.glDeleteVertexArrays((int)this.id);
            this.id = 0;
        } else {
            RenderSystem.recordRenderCall(this::close);
        }
    }
}

