/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcer.shader;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.sowcer.ContextCapability;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import org.apache.commons.io.IOUtils;

public class PatchingResourceProvider
implements class_5912 {
    private final class_5912 source;

    public PatchingResourceProvider(class_5912 source) {
        this.source = source;
    }

    public Optional<class_3298> method_14486(class_2960 resourceLocation) {
        try {
            Optional srcResource;
            if (resourceLocation.method_12832().contains("_modelmat")) {
                resourceLocation = new class_2960(resourceLocation.method_12836(), resourceLocation.method_12832().replace("_modelmat", ""));
            }
            if ((srcResource = this.source.method_14486(resourceLocation)).isEmpty()) {
                return Optional.empty();
            }
            InputStream srcInputStream = ((class_3298)srcResource.get()).method_14482();
            String returningContent = "";
            if (resourceLocation.method_12832().endsWith(".json")) {
                srcContent = IOUtils.toString((InputStream)srcInputStream, (Charset)StandardCharsets.UTF_8);
                JsonObject data = Main.JSON_PARSER.parse(srcContent).getAsJsonObject();
                data.addProperty("vertex", data.get("vertex").getAsString() + "_modelmat");
                JsonArray attribArray = data.get("attributes").getAsJsonArray();
                int dummyAttribCount = 6 - attribArray.size();
                for (int i = 0; i < dummyAttribCount; ++i) {
                    attribArray.add("Dummy" + i);
                }
                attribArray.add("ModelMat");
                returningContent = data.toString();
                srcInputStream.close();
            } else if (resourceLocation.method_12832().endsWith(".vsh")) {
                srcContent = IOUtils.toString((InputStream)srcInputStream, (Charset)StandardCharsets.UTF_8);
                returningContent = PatchingResourceProvider.patchVertexShaderSource(srcContent);
                srcInputStream.close();
            } else {
                return srcResource;
            }
            ByteArrayInputStream newContentStream = new ByteArrayInputStream(returningContent.getBytes(StandardCharsets.UTF_8));
            return Optional.of(new class_3298(((class_3298)srcResource.get()).method_45304(), () -> newContentStream));
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
    }

    public static String patchVertexShaderSource(String srcContent) {
        String[] contentParts = srcContent.split("void main");
        contentParts[0] = contentParts[0].replace("uniform mat4 ModelViewMat;", "uniform mat4 ModelViewMat;\nin mat4 ModelMat;");
        if (ContextCapability.isGL4ES) {
            contentParts[0] = contentParts[0].replace("ivec2", "vec2");
        }
        contentParts[1] = contentParts[1].replaceAll("\\bPosition\\b", "(MODELVIEWMAT * ModelMat * vec4(Position, 1.0)).xyz").replaceAll("\\bNormal\\b", "normalize(mat3(MODELVIEWMAT * ModelMat) * Normal)").replace("ModelViewMat", "mat4(1.0)").replace("MODELVIEWMAT", "ModelViewMat");
        return contentParts[0] + "void main" + contentParts[1];
    }
}

