/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcer.shader;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import fabric.cn.zbx1425.mtrsteamloco.render.ShadersModHandler;
import fabric.cn.zbx1425.sowcer.batch.MaterialProp;
import fabric.cn.zbx1425.sowcer.batch.ShaderProp;
import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcer.shader.PatchingResourceProvider;
import fabric.cn.zbx1425.sowcer.util.AttrUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_285;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5912;
import net.minecraft.class_5944;

public class ShaderManager {
    public static final class_296 MC_ELEMENT_MATRIX = new class_296(0, class_296.class_297.field_1623, class_296.class_298.field_20782, 16);
    public static final class_293 MC_FORMAT_ENTITY_MAT = new class_293(ImmutableMap.builder().put((Object)"Position", (Object)class_290.field_1587).put((Object)"Color", (Object)class_290.field_1581).put((Object)"UV0", (Object)class_290.field_1591).put((Object)"UV1", (Object)class_290.field_1583).put((Object)"UV2", (Object)class_290.field_20886).put((Object)"Normal", (Object)class_290.field_1579).put((Object)"ModelMat", (Object)MC_ELEMENT_MATRIX).put((Object)"Padding", (Object)class_290.field_1578).build());
    public final Map<String, class_5944> shaders = new HashMap<String, class_5944>();

    public boolean isReady() {
        return this.shaders.size() > 0;
    }

    public void reloadShaders(class_3300 resourceManager) throws IOException {
        this.shaders.values().forEach(class_5944::close);
        this.shaders.clear();
        PatchingResourceProvider provider = new PatchingResourceProvider((class_5912)resourceManager);
        this.loadShader(provider, "rendertype_entity_cutout");
        this.loadShader(provider, "rendertype_entity_translucent_cull");
        this.loadShader(provider, "rendertype_beacon_beam");
    }

    private void loadShader(class_5912 resourceManager, String name) throws IOException {
        class_5944 shader = new class_5944(resourceManager, name, MC_FORMAT_ENTITY_MAT);
        this.shaders.put(name, shader);
    }

    public void setupShaderBatchState(MaterialProp materialProp, ShaderProp shaderProp) {
        class_5944 shaderInstance;
        boolean useCustomShader = ShadersModHandler.canUseCustomShader();
        if (useCustomShader) {
            shaderInstance = this.shaders.get(materialProp.shaderName);
            materialProp.setupCompositeState();
        } else {
            class_1921 renderType = materialProp.getBlazeRenderType();
            renderType.method_23516();
            shaderInstance = RenderSystem.getShader();
        }
        if (shaderInstance == null) {
            throw new IllegalArgumentException("Cannot get shader: " + materialProp.shaderName + (useCustomShader ? "_modelmat" : ""));
        }
        for (int l = 0; l < 8; ++l) {
            int o = RenderSystem.getShaderTexture((int)l);
            shaderInstance.method_34583("Sampler" + l, (Object)o);
        }
        if (shaderInstance.field_29470 != null) {
            Matrix4f mvMatrix = new Matrix4f(RenderSystem.getModelViewMatrix()).copy();
            if (shaderProp.viewMatrix != null) {
                mvMatrix.multiply(shaderProp.viewMatrix);
            }
            if (materialProp.billboard) {
                AttrUtil.zeroRotation(mvMatrix);
            }
            shaderInstance.field_29470.method_1250(mvMatrix.asMoj());
        }
        if (shaderInstance.field_29471 != null) {
            shaderInstance.field_29471.method_1250(RenderSystem.getProjectionMatrix());
        }
        if (shaderInstance.field_36323 != null) {
            shaderInstance.field_36323.method_39978(RenderSystem.getInverseViewRotationMatrix());
        }
        if (shaderInstance.field_29474 != null) {
            shaderInstance.field_29474.method_1253(RenderSystem.getShaderColor());
        }
        if (shaderInstance.field_29477 != null) {
            shaderInstance.field_29477.method_1251(RenderSystem.getShaderFogStart());
        }
        if (shaderInstance.field_29478 != null) {
            shaderInstance.field_29478.method_1251(RenderSystem.getShaderFogEnd());
        }
        if (shaderInstance.field_29479 != null) {
            shaderInstance.field_29479.method_1253(RenderSystem.getShaderFogColor());
        }
        if (shaderInstance.field_36373 != null) {
            shaderInstance.field_36373.method_35649(RenderSystem.getShaderFogShape().method_40036());
        }
        if (shaderInstance.field_29472 != null) {
            shaderInstance.field_29472.method_1250(RenderSystem.getTextureMatrix());
        }
        if (shaderInstance.field_29481 != null) {
            shaderInstance.field_29481.method_1251(RenderSystem.getShaderGameTime());
        }
        if (shaderInstance.field_29473 != null) {
            class_1041 window = class_310.method_1551().method_22683();
            shaderInstance.field_29473.method_1255((float)window.method_4489(), (float)window.method_4506());
        }
        RenderSystem.setupShaderLights((class_5944)shaderInstance);
        shaderInstance.method_34586();
        if (shaderInstance.field_29493 != class_5944.field_29486) {
            class_285.method_22094((int)shaderInstance.field_29493);
            class_5944.field_29486 = shaderInstance.field_29493;
        }
    }

    public void cleanupShaderBatchState(MaterialProp materialProp, ShaderProp shaderProp) {
        class_5944 shaderInstance;
        boolean useCustomShader = ShadersModHandler.canUseCustomShader();
        if (!useCustomShader && (shaderInstance = RenderSystem.getShader()) != null && shaderInstance.field_29470 != null) {
            shaderInstance.field_29470.method_1250(RenderSystem.getModelViewMatrix());
            if (ShadersModHandler.canUseCustomShader()) {
                shaderInstance.field_29470.method_1300();
            } else {
                shaderInstance.method_34586();
            }
        }
    }
}

