/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcer.vertex;

import fabric.cn.zbx1425.sowcer.object.InstanceBuf;
import fabric.cn.zbx1425.sowcer.object.VertBuf;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrSrc;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrState;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrType;
import java.util.HashMap;

public class VertAttrMapping {
    public final HashMap<VertAttrType, VertAttrSrc> sources;
    public final HashMap<VertAttrType, Integer> pointers = new HashMap();
    public final int strideVertex;
    public final int strideInstance;
    public final int paddingVertex;
    public final int paddingInstance;

    private VertAttrMapping(HashMap<VertAttrType, VertAttrSrc> sources) {
        this.sources = sources;
        int strideVertex = 0;
        int strideInstance = 0;
        block4: for (VertAttrType attrType : VertAttrType.values()) {
            switch (sources.get((Object)attrType)) {
                case VERTEX_BUF: 
                case VERTEX_BUF_OR_GLOBAL: {
                    this.pointers.put(attrType, strideVertex);
                    strideVertex += attrType.byteSize;
                    continue block4;
                }
                case INSTANCE_BUF: 
                case INSTANCE_BUF_OR_GLOBAL: {
                    this.pointers.put(attrType, strideInstance);
                    strideInstance += attrType.byteSize;
                }
            }
        }
        if (strideVertex % 4 != 0) {
            this.paddingVertex = 4 - strideVertex % 4;
            strideVertex += this.paddingVertex;
        } else {
            this.paddingVertex = 0;
        }
        if (strideInstance % 4 != 0) {
            this.paddingInstance = 4 - strideInstance % 4;
            strideInstance += this.paddingInstance;
        } else {
            this.paddingInstance = 0;
        }
        this.strideVertex = strideVertex;
        this.strideInstance = strideInstance;
    }

    public void setupAttrsToVao(VertBuf vertexBuf, InstanceBuf instanceBuf) {
        block5: for (VertAttrType attrType : VertAttrType.values()) {
            switch (this.sources.get((Object)attrType)) {
                case GLOBAL: {
                    attrType.toggleAttrArray(false);
                    continue block5;
                }
                case VERTEX_BUF: 
                case VERTEX_BUF_OR_GLOBAL: {
                    attrType.toggleAttrArray(true);
                    vertexBuf.bind(34962);
                    attrType.setupAttrPtr(this.strideVertex, this.pointers.get((Object)attrType));
                    attrType.setAttrDivisor(0);
                    continue block5;
                }
                case INSTANCE_BUF: 
                case INSTANCE_BUF_OR_GLOBAL: {
                    attrType.toggleAttrArray(true);
                    instanceBuf.bind(34962);
                    attrType.setupAttrPtr(this.strideInstance, this.pointers.get((Object)attrType));
                    attrType.setAttrDivisor(1);
                }
            }
        }
    }

    public void applyToggleableAttr(VertAttrState enqueueProp, VertAttrState materialProp) {
        for (VertAttrType attrType : VertAttrType.values()) {
            if (!this.sources.get((Object)attrType).isToggleable()) continue;
            boolean hasAttr = enqueueProp != null && enqueueProp.hasAttr(attrType) || materialProp != null && materialProp.hasAttr(attrType);
            attrType.toggleAttrArray(!hasAttr);
        }
    }

    public static class Builder {
        private final HashMap<VertAttrType, VertAttrSrc> sources = new HashMap(VertAttrType.values().length);

        public Builder() {
            for (VertAttrType attrType : VertAttrType.values()) {
                this.sources.put(attrType, VertAttrSrc.VERTEX_BUF);
            }
        }

        public Builder set(VertAttrType type, VertAttrSrc src) {
            this.sources.put(type, src);
            return this;
        }

        public VertAttrMapping build() {
            return new VertAttrMapping(this.sources);
        }
    }
}

