/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcer.vertex;

import fabric.cn.zbx1425.sowcer.ContextCapability;
import org.lwjgl.opengl.GL33;

public enum VertAttrType {
    POSITION(0, 5126, 3, 1, false, false),
    COLOR(1, 5121, 4, 1, true, false),
    UV_TEXTURE(2, 5126, 2, 1, false, false),
    UV_OVERLAY(3, 5122, 2, 1, false, true),
    UV_LIGHTMAP(4, 5122, 2, 1, false, true),
    NORMAL(5, 5120, 3, 1, true, false),
    MATRIX_MODEL(6, 5126, 4, 4, false, false);

    public final int location;
    public final int type;
    public final int size;
    public final int span;
    public final int byteSize;
    public final boolean normalized;
    public final boolean iPointer;

    private VertAttrType(int location, int type, int size, int span, boolean normalized, boolean iPointer) {
        this.location = location;
        this.type = type;
        this.size = size;
        this.span = span;
        this.normalized = normalized;
        this.iPointer = iPointer;
        this.byteSize = (switch (type) {
            case 5126 -> 4;
            case 5120, 5121 -> 1;
            case 5122 -> 2;
            default -> 0;
        }) * size * span;
    }

    public void toggleAttrArray(boolean enable) {
        for (int i = 0; i < this.span; ++i) {
            if (enable) {
                GL33.glEnableVertexAttribArray((int)(this.location + i));
                continue;
            }
            GL33.glDisableVertexAttribArray((int)(this.location + i));
        }
    }

    public void setupAttrPtr(int stride, int pointer) {
        for (int i = 0; i < this.span; ++i) {
            int attrPtr = pointer + i * this.byteSize / this.span;
            if (this.iPointer) {
                if (!ContextCapability.isGL4ES) {
                    GL33.glVertexAttribIPointer((int)(this.location + i), (int)this.size, (int)this.type, (int)stride, (long)attrPtr);
                    continue;
                }
                GL33.glVertexAttribPointer((int)(this.location + i), (int)this.size, (int)this.type, (boolean)false, (int)stride, (long)attrPtr);
                continue;
            }
            GL33.glVertexAttribPointer((int)(this.location + i), (int)this.size, (int)this.type, (boolean)this.normalized, (int)stride, (long)attrPtr);
        }
    }

    public void setAttrDivisor(int divisor) {
        if (!ContextCapability.supportVertexAttribDivisor) {
            return;
        }
        for (int i = 0; i < this.span; ++i) {
            GL33.glVertexAttribDivisor((int)(this.location + i), (int)divisor);
        }
    }
}

