/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcerext.model;

import fabric.cn.zbx1425.sowcer.batch.BatchManager;
import fabric.cn.zbx1425.sowcer.batch.EnqueueProp;
import fabric.cn.zbx1425.sowcer.batch.ShaderProp;
import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcer.model.VertArrays;
import fabric.cn.zbx1425.sowcer.util.AttrUtil;
import fabric.cn.zbx1425.sowcer.util.DrawContext;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrMapping;
import fabric.cn.zbx1425.sowcer.vertex.VertAttrState;
import fabric.cn.zbx1425.sowcerext.model.RawMesh;
import fabric.cn.zbx1425.sowcerext.model.RawModel;
import fabric.cn.zbx1425.sowcerext.model.integration.BufferSourceProxy;
import fabric.cn.zbx1425.sowcerext.reuse.ModelManager;
import java.io.Closeable;
import net.minecraft.class_2960;

public class ModelCluster
implements Closeable {
    public final VertArrays uploadedOpaqueParts;
    public final RawModel opaqueParts;
    public final VertArrays uploadedTranslucentParts;
    public final RawModel translucentParts;

    public ModelCluster(RawModel source, VertAttrMapping mapping, ModelManager modelManager) {
        this.translucentParts = new RawModel();
        this.opaqueParts = new RawModel();
        for (RawMesh mesh : source.meshList.values()) {
            if (mesh.materialProp.translucent) {
                this.translucentParts.append(mesh);
                continue;
            }
            this.opaqueParts.append(mesh);
        }
        this.uploadedOpaqueParts = VertArrays.createAll(modelManager.uploadModel(this.opaqueParts), mapping, null);
        this.uploadedTranslucentParts = VertArrays.createAll(modelManager.uploadModel(this.translucentParts), mapping, null);
    }

    private ModelCluster(VertArrays uploadedOpaqueParts, RawModel opaqueParts, VertArrays uploadedTranslucentParts, RawModel translucentParts) {
        this.uploadedOpaqueParts = uploadedOpaqueParts;
        this.opaqueParts = opaqueParts;
        this.uploadedTranslucentParts = uploadedTranslucentParts;
        this.translucentParts = translucentParts;
    }

    public void enqueueOpaqueGl(BatchManager batchManager, Matrix4f pose, int light, DrawContext drawContext) {
        int shaderLightmapUV = AttrUtil.exchangeLightmapUVBits(light);
        batchManager.enqueue(this.uploadedOpaqueParts, new EnqueueProp(new VertAttrState().setColor(255, 255, 255, 255).setOverlayUVNoOverlay().setLightmapUV(shaderLightmapUV).setModelMatrix(pose)), ShaderProp.DEFAULT);
    }

    public void enqueueOpaqueBlaze(BufferSourceProxy vertexConsumers, Matrix4f pose, int light, DrawContext drawContext) {
        this.opaqueParts.writeBlazeBuffer(vertexConsumers, pose, light, drawContext);
    }

    public void enqueueTranslucentGl(BatchManager batchManager, Matrix4f matrix4f, int light, DrawContext drawContext) {
        int shaderLightmapUV = AttrUtil.exchangeLightmapUVBits(light);
        batchManager.enqueue(this.uploadedTranslucentParts, new EnqueueProp(new VertAttrState().setColor(255, 255, 255, 255).setOverlayUVNoOverlay().setLightmapUV(shaderLightmapUV).setModelMatrix(matrix4f)), ShaderProp.DEFAULT);
    }

    public void enqueueTranslucentBlaze(BufferSourceProxy vertexConsumers, Matrix4f pose, int light, DrawContext drawContext) {
        this.translucentParts.writeBlazeBuffer(vertexConsumers, pose, light, drawContext);
    }

    @Override
    public void close() {
        this.uploadedOpaqueParts.close();
    }

    public void replaceTexture(String oldTexture, class_2960 newTexture) {
        this.uploadedOpaqueParts.replaceTexture(oldTexture, newTexture);
        this.opaqueParts.replaceTexture(oldTexture, newTexture);
        this.uploadedTranslucentParts.replaceTexture(oldTexture, newTexture);
        this.translucentParts.replaceTexture(oldTexture, newTexture);
    }

    public void replaceAllTexture(class_2960 newTexture) {
        this.uploadedOpaqueParts.replaceAllTexture(newTexture);
        this.opaqueParts.replaceAllTexture(newTexture);
        this.uploadedTranslucentParts.replaceAllTexture(newTexture);
        this.translucentParts.replaceAllTexture(newTexture);
    }

    public ModelCluster copyForMaterialChanges() {
        return new ModelCluster(this.uploadedOpaqueParts.copyForMaterialChanges(), this.opaqueParts.copyForMaterialChanges(), this.uploadedTranslucentParts.copyForMaterialChanges(), this.translucentParts.copyForMaterialChanges());
    }
}

