/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcerext.model.integration;

import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.model.Vertex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

public class FaceList {
    private final class_1921 renderType;
    private final boolean needSorting;
    private final List<TransformedFace> queuedFaces = new ArrayList<TransformedFace>();

    public FaceList(class_1921 renderType, boolean needSorting) {
        this.renderType = renderType;
        this.needSorting = needSorting;
    }

    public void addFace(Vertex[] vertices, int color, int light) {
        this.queuedFaces.add(new TransformedFace(vertices, color, light));
    }

    public void commit(class_4597 bufferSource) {
        class_4588 vertexConsumer = bufferSource.getBuffer(this.renderType);
        if (this.needSorting) {
            this.queuedFaces.sort((a, b) -> -Float.compare(a.sortingVector.distanceSq(Vector3f.ZERO), b.sortingVector.distanceSq(Vector3f.ZERO)));
        }
        for (TransformedFace face : this.queuedFaces) {
            for (Vertex vertex : face.vertices) {
                vertexConsumer.method_22912((double)vertex.position.x(), (double)vertex.position.y(), (double)vertex.position.z()).method_1336((int)((byte)(face.color >>> 24)), (int)((byte)(face.color >>> 16)), (int)((byte)(face.color >>> 8)), (int)((byte)face.color)).method_22913(vertex.u, vertex.v).method_22922(class_4608.field_21444).method_22916(face.light).method_22914(vertex.normal.x(), vertex.normal.y(), vertex.normal.z()).method_1344();
            }
        }
    }

    private static class TransformedFace {
        private final Vertex[] vertices;
        private final Vector3f sortingVector;
        int color;
        int light;

        public TransformedFace(Vertex[] vertices, int color, int light) {
            this.vertices = vertices;
            this.sortingVector = new Vector3f(0.0f, 0.0f, 0.0f);
            for (Vertex vertex : vertices) {
                this.sortingVector.add(vertex.position);
            }
            this.color = color;
            this.light = light;
        }
    }
}

