/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcerext.model.integration;

import fabric.cn.zbx1425.sowcer.batch.MaterialProp;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.model.Face;
import fabric.cn.zbx1425.sowcerext.model.RawMesh;
import fabric.cn.zbx1425.sowcerext.model.Vertex;
import java.util.stream.IntStream;
import net.minecraft.class_2960;

public class RawMeshBuilder {
    private final RawMesh mesh;
    private final int faceSize;
    private Vertex buildingVertex = new Vertex();

    public RawMeshBuilder(int faceSize, String renderType, class_2960 texture) {
        this.faceSize = faceSize;
        this.mesh = new RawMesh(new MaterialProp());
        this.mesh.setRenderType(renderType);
        this.mesh.materialProp.texture = texture;
    }

    public RawMesh getMesh() {
        return this.mesh;
    }

    public RawMeshBuilder reset() {
        this.mesh.vertices.clear();
        this.mesh.faces.clear();
        this.buildingVertex = new Vertex();
        return this;
    }

    public RawMeshBuilder vertex(Vector3f position) {
        this.buildingVertex.position = position;
        return this;
    }

    public RawMeshBuilder vertex(double d, double e, double f) {
        this.buildingVertex.position = new Vector3f((float)d, (float)e, (float)f);
        return this;
    }

    public RawMeshBuilder normal(float f, float g, float h) {
        this.buildingVertex.normal = new Vector3f(f, g, h);
        return this;
    }

    public RawMeshBuilder uv(float f, float g) {
        this.buildingVertex.u = f;
        this.buildingVertex.v = g;
        return this;
    }

    public void endVertex() {
        this.mesh.vertices.add(this.buildingVertex);
        this.buildingVertex = new Vertex();
        if (this.mesh.vertices.size() % this.faceSize == 0) {
            this.mesh.faces.add(new Face(IntStream.range(this.mesh.vertices.size() - this.faceSize, this.mesh.vertices.size()).toArray()));
        }
    }

    public RawMeshBuilder color(int r, int g, int b, int a) {
        this.mesh.materialProp.attrState.setColor(r, g, b, a);
        return this;
    }

    public RawMeshBuilder lightMapUV(short u, short v) {
        this.mesh.materialProp.attrState.setLightmapUV(u, v);
        return this;
    }
}

