/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcerext.model.loader;

import fabric.cn.zbx1425.sowcer.batch.MaterialProp;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.model.Face;
import fabric.cn.zbx1425.sowcerext.model.RawMesh;
import fabric.cn.zbx1425.sowcerext.model.RawModel;
import fabric.cn.zbx1425.sowcerext.model.Vertex;
import fabric.cn.zbx1425.sowcerext.reuse.AtlasManager;
import fabric.cn.zbx1425.sowcerext.util.Logging;
import fabric.cn.zbx1425.sowcerext.util.ResourceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.apache.commons.lang3.StringUtils;

public class CsvModelLoader {
    public static RawModel loadModel(class_3300 resourceManager, class_2960 objLocation, AtlasManager atlasManager) throws IOException {
        String rawModelData = ResourceUtil.readResource(resourceManager, objLocation);
        String[] rawModelLines = rawModelData.split("[\\r\\n]+");
        ArrayList<RawMesh> builtMeshList = new ArrayList<RawMesh>();
        boolean isGLCoords = false;
        RawMesh buildingMesh = new RawMesh(new MaterialProp("rendertype_entity_cutout"));
        for (String line : rawModelLines) {
            try {
                if (line.contains(";")) {
                    line = line.split(";", 2)[0];
                }
                if (StringUtils.isEmpty((CharSequence)(line = line.trim().toLowerCase()))) continue;
                String[] tokens = line.split(",");
                for (int i = 0; i < tokens.length; ++i) {
                    tokens[i] = tokens[i].trim();
                }
                if (tokens.length < 1 || StringUtils.isEmpty((CharSequence)tokens[0])) continue;
                switch (tokens[0]) {
                    case "createmeshbuilder": {
                        buildingMesh.validateVertIndex();
                        if (!buildingMesh.faces.isEmpty()) {
                            builtMeshList.add(buildingMesh);
                        }
                        buildingMesh = new RawMesh(new MaterialProp("rendertype_entity_cutout"));
                        break;
                    }
                    case "addvertex": {
                        if (tokens.length == 4) {
                            buildingMesh.vertices.add(new Vertex(new Vector3f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), Float.parseFloat(tokens[3]))));
                            break;
                        }
                        if (tokens.length == 7) {
                            buildingMesh.vertices.add(new Vertex(new Vector3f(Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]), Float.parseFloat(tokens[3])), new Vector3f(Float.parseFloat(tokens[4]), Float.parseFloat(tokens[5]), Float.parseFloat(tokens[6]))));
                            break;
                        }
                        throw new IllegalArgumentException("Invalid AddVertex command.");
                    }
                    case "addface": 
                    case "addface2": {
                        if (tokens.length < 4) {
                            throw new IllegalArgumentException("Invalid AddFace/AddFace2 command.");
                        }
                        int[] vertIndices = new int[tokens.length - 1];
                        for (int i = 1; i < tokens.length; ++i) {
                            vertIndices[i - 1] = Integer.parseInt(tokens[i]);
                        }
                        buildingMesh.faces.addAll(Face.triangulate(vertIndices, tokens[0].equals("addface2")));
                        break;
                    }
                    case "setcolor": 
                    case "setcolorall": {
                        Integer[] setColorParams = CsvModelLoader.parseParams(tokens, new Integer[]{0, 0, 0, 255}, Integer::parseInt);
                        if (tokens[0].equals("setcolorall")) {
                            for (RawMesh mesh : builtMeshList) {
                                mesh.materialProp.attrState.setColor(setColorParams[0], setColorParams[1], setColorParams[2], setColorParams[3]);
                            }
                        }
                        buildingMesh.materialProp.attrState.setColor(setColorParams[0], setColorParams[1], setColorParams[2], setColorParams[3]);
                        break;
                    }
                    case "loadtexture": {
                        if (tokens.length < 2) {
                            throw new IllegalArgumentException("Invalid LoadTexture command.");
                        }
                        buildingMesh.materialProp.texture = ResourceUtil.resolveRelativePath(objLocation, tokens[1], ".png");
                        break;
                    }
                    case "settexturecoordinates": {
                        if (tokens.length < 4) {
                            throw new IllegalArgumentException("Invalid SetTextureCoordinates command.");
                        }
                        int vertId = Integer.parseInt(tokens[1]);
                        if (vertId < 0 || vertId >= buildingMesh.vertices.size()) {
                            throw new IndexOutOfBoundsException("Invalid vertex index in SetTextureCoordinates.");
                        }
                        buildingMesh.vertices.get((int)vertId).u = Float.parseFloat(tokens[2]);
                        buildingMesh.vertices.get((int)vertId).v = Float.parseFloat(tokens[3]);
                        break;
                    }
                    case "generatenormals": {
                        break;
                    }
                    case "cube": {
                        Float[] cubeParams = CsvModelLoader.parseParams(tokens, new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, Float::parseFloat);
                        if (cubeParams[1].floatValue() == 0.0f) {
                            cubeParams[1] = cubeParams[0];
                        }
                        if (cubeParams[2].floatValue() == 0.0f) {
                            cubeParams[2] = cubeParams[0];
                        }
                        CsvModelLoader.createCube(buildingMesh, cubeParams[0].floatValue(), cubeParams[1].floatValue(), cubeParams[2].floatValue());
                        break;
                    }
                    case "cylinder": {
                        Float[] cylinderParams = CsvModelLoader.parseParams(tokens, new Float[]{Float.valueOf(8.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)}, Float::parseFloat);
                        CsvModelLoader.createCylinder(buildingMesh, Math.round(cylinderParams[0].floatValue()), cylinderParams[1].floatValue(), cylinderParams[2].floatValue(), cylinderParams[3].floatValue());
                        break;
                    }
                    case "translate": 
                    case "translateall": {
                        Float[] translateParams = CsvModelLoader.parseParams(tokens, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, Float::parseFloat);
                        if (tokens[0].equals("translateall")) {
                            for (RawMesh rawMesh : builtMeshList) {
                                rawMesh.applyTranslation(translateParams[0].floatValue(), translateParams[1].floatValue(), translateParams[2].floatValue());
                            }
                        }
                        buildingMesh.applyTranslation(translateParams[0].floatValue(), translateParams[1].floatValue(), translateParams[2].floatValue());
                        break;
                    }
                    case "scale": 
                    case "scaleall": {
                        Float[] scaleParams = CsvModelLoader.parseParams(tokens, new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)}, Float::parseFloat);
                        if (tokens[0].equals("scaleall")) {
                            for (Object mesh2 : builtMeshList) {
                                ((RawMesh)mesh2).applyScale(scaleParams[0].floatValue(), scaleParams[1].floatValue(), scaleParams[2].floatValue());
                            }
                        }
                        buildingMesh.applyScale(scaleParams[0].floatValue(), scaleParams[1].floatValue(), scaleParams[2].floatValue());
                        break;
                    }
                    case "rotate": 
                    case "rotateall": {
                        Float[] floatArray = CsvModelLoader.parseParams(tokens, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, Float::parseFloat);
                        if (tokens[0].equals("rotateall")) {
                            Object mesh2;
                            mesh2 = builtMeshList.iterator();
                            while (mesh2.hasNext()) {
                                RawMesh rawMesh = (RawMesh)mesh2.next();
                                rawMesh.applyRotation(new Vector3f(floatArray[0].floatValue(), floatArray[1].floatValue(), floatArray[2].floatValue()), floatArray[3].floatValue());
                            }
                        }
                        buildingMesh.applyRotation(new Vector3f(floatArray[0].floatValue(), floatArray[1].floatValue(), floatArray[2].floatValue()), floatArray[3].floatValue());
                        break;
                    }
                    case "shear": 
                    case "shearall": {
                        Object mesh32;
                        Float[] shearParams = CsvModelLoader.parseParams(tokens, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, Float::parseFloat);
                        if (tokens[0].equals("shearall")) {
                            for (Object mesh32 : builtMeshList) {
                                ((RawMesh)mesh32).applyShear(new Vector3f(shearParams[0].floatValue(), shearParams[1].floatValue(), shearParams[2].floatValue()), new Vector3f(shearParams[3].floatValue(), shearParams[4].floatValue(), shearParams[5].floatValue()), shearParams[6].floatValue());
                            }
                        }
                        buildingMesh.applyShear(new Vector3f(shearParams[0].floatValue(), shearParams[1].floatValue(), shearParams[2].floatValue()), new Vector3f(shearParams[3].floatValue(), shearParams[4].floatValue(), shearParams[5].floatValue()), shearParams[6].floatValue());
                        break;
                    }
                    case "mirror": 
                    case "mirrorall": {
                        RawMesh mesh;
                        Object mesh32;
                        Integer[] integerArray = CsvModelLoader.parseParams(tokens, new Integer[]{0, 0, 0, 0, 0, 0}, Integer::parseInt);
                        if (tokens.length < 5) {
                            integerArray[3] = integerArray[0];
                            integerArray[4] = integerArray[1];
                            integerArray[5] = integerArray[2];
                        }
                        if (tokens[0].equals("mirrorall")) {
                            mesh32 = builtMeshList.iterator();
                            while (mesh32.hasNext()) {
                                mesh = (RawMesh)mesh32.next();
                                mesh.applyMirror(integerArray[0] != 0, integerArray[1] != 0, integerArray[2] != 0, integerArray[3] != 0, integerArray[4] != 0, integerArray[5] != 0);
                            }
                        }
                        buildingMesh.applyMirror(integerArray[0] != 0, integerArray[1] != 0, integerArray[2] != 0, integerArray[3] != 0, integerArray[4] != 0, integerArray[5] != 0);
                        break;
                    }
                    case "setemissivecolor": 
                    case "setemissivecolorall": 
                    case "setblendmode": 
                    case "setwrapmode": 
                    case "setdecaltransparentcolor": 
                    case "enablecrossfading": {
                        break;
                    }
                    case "setrendertype": 
                    case "setrendertypeall": {
                        RawMesh mesh;
                        Object mesh32;
                        if (tokens[0].equals("setrendertypeall")) {
                            mesh32 = builtMeshList.iterator();
                            while (mesh32.hasNext()) {
                                mesh = (RawMesh)mesh32.next();
                                mesh.setRenderType(tokens[1]);
                            }
                        }
                        buildingMesh.setRenderType(tokens[1]);
                        break;
                    }
                    case "setbillboard": {
                        buildingMesh.materialProp.billboard = tokens[1].equals("true");
                        break;
                    }
                    case "setisglcoords": {
                        isGLCoords = tokens[1].equals("true");
                        break;
                    }
                    case "uvmirror": 
                    case "uvmirrorall": {
                        Integer[] uvMirrorParams = CsvModelLoader.parseParams(tokens, new Integer[]{0, 0}, Integer::parseInt);
                        if (tokens[0].equals("uvmirrorall")) {
                            for (RawMesh mesh : builtMeshList) {
                                mesh.applyUVMirror(uvMirrorParams[0] != 0, uvMirrorParams[1] != 0);
                            }
                        }
                        buildingMesh.applyUVMirror(uvMirrorParams[0] != 0, uvMirrorParams[1] != 0);
                        break;
                    }
                    default: {
                        Logging.LOGGER.warn("Unknown CSV command: " + tokens[0]);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                Logging.LOGGER.error("Failed loading CSV model " + objLocation + ", line \"" + line + "\": " + ex.toString());
            }
        }
        buildingMesh.validateVertIndex();
        if (!buildingMesh.faces.isEmpty()) {
            builtMeshList.add(buildingMesh);
        }
        RawModel model = new RawModel();
        model.sourceLocation = objLocation;
        for (RawMesh mesh : builtMeshList) {
            if (!isGLCoords) {
                mesh.applyScale(-1.0f, 1.0f, 1.0f);
            }
            if (atlasManager != null) {
                atlasManager.applyToMesh(mesh);
            }
            model.append(mesh);
        }
        model.generateNormals();
        model.distinct();
        return model;
    }

    private static <T> T[] parseParams(String[] tokens, T[] defaults, Function<String, T> parser) {
        Object[] result = (Object[])defaults.clone();
        for (int i = 0; i < defaults.length; ++i) {
            if (i + 1 >= tokens.length) {
                return result;
            }
            String valueStr = tokens[i + 1].trim();
            if (StringUtils.isEmpty((CharSequence)valueStr)) continue;
            result[i] = parser.apply(valueStr);
        }
        return result;
    }

    private static void createCube(RawMesh buildingMesh, float sx, float sy, float sz) {
        int v = buildingMesh.vertices.size();
        buildingMesh.vertices.add(new Vertex(new Vector3f(sx, sy, -sz)));
        buildingMesh.vertices.add(new Vertex(new Vector3f(sx, -sy, -sz)));
        buildingMesh.vertices.add(new Vertex(new Vector3f(-sx, -sy, -sz)));
        buildingMesh.vertices.add(new Vertex(new Vector3f(-sx, sy, -sz)));
        buildingMesh.vertices.add(new Vertex(new Vector3f(sx, sy, sz)));
        buildingMesh.vertices.add(new Vertex(new Vector3f(sx, -sy, sz)));
        buildingMesh.vertices.add(new Vertex(new Vector3f(-sx, -sy, sz)));
        buildingMesh.vertices.add(new Vertex(new Vector3f(-sx, sy, sz)));
        buildingMesh.faces.add(new Face(new int[]{v, v + 1, v + 2}));
        buildingMesh.faces.add(new Face(new int[]{v, v + 2, v + 3}));
        buildingMesh.faces.add(new Face(new int[]{v, v + 4, v + 5}));
        buildingMesh.faces.add(new Face(new int[]{v, v + 5, v + 1}));
        buildingMesh.faces.add(new Face(new int[]{v, v + 3, v + 7}));
        buildingMesh.faces.add(new Face(new int[]{v, v + 7, v + 4}));
        buildingMesh.faces.add(new Face(new int[]{v + 6, v + 5, v + 4}));
        buildingMesh.faces.add(new Face(new int[]{v + 6, v + 4, v + 7}));
        buildingMesh.faces.add(new Face(new int[]{v + 6, v + 7, v + 3}));
        buildingMesh.faces.add(new Face(new int[]{v + 6, v + 3, v + 2}));
        buildingMesh.faces.add(new Face(new int[]{v + 6, v + 2, v + 1}));
        buildingMesh.faces.add(new Face(new int[]{v + 6, v + 1, v + 5}));
    }

    private static void createCylinder(RawMesh buildingMesh, int n, float r1, float r2, float h) {
        int i;
        boolean uppercap = (double)r1 > 0.0;
        boolean lowercap = (double)r2 > 0.0;
        int m = (uppercap ? 1 : 0) + (lowercap ? 1 : 0);
        r1 = Math.abs(r1);
        r2 = Math.abs(r2);
        float ns = h >= 0.0f ? 1.0f : -1.0f;
        float d = (float)(Math.PI * 2 / (double)n);
        float g = 0.5f * h;
        float t = 0.0f;
        float a = (float)((double)h != 0.0 ? Math.atan((r2 - r1) / h) : 0.0);
        int v = buildingMesh.vertices.size();
        for (i = 0; i < n; ++i) {
            float dx = (float)Math.cos(t);
            float dz = (float)Math.sin(t);
            float lx = dx * r2;
            float lz = dz * r2;
            float ux = dx * r1;
            float uz = dz * r1;
            Vector3f normal = new Vector3f(dx * ns, 0.0f, dz * ns);
            Vector3f s = normal.copy();
            s.cross(new Vector3f(0.0f, -1.0f, 0.0f));
            normal.rot(s, a);
            buildingMesh.vertices.add(new Vertex(new Vector3f(ux, g, uz), normal));
            buildingMesh.vertices.add(new Vertex(new Vector3f(lx, -g, lz), normal));
            t += d;
        }
        for (i = 0; i < n; ++i) {
            int i0 = (2 * i + 2) % (2 * n);
            int i1 = (2 * i + 3) % (2 * n);
            int i2 = 2 * i + 1;
            int i3 = 2 * i;
            buildingMesh.faces.add(new Face(new int[]{v + i0, v + i1, v + i2}));
            buildingMesh.faces.add(new Face(new int[]{v + i0, v + i2, v + i3}));
        }
        for (i = 0; i < m; ++i) {
            int j;
            ArrayList<Integer> verts = new ArrayList<Integer>();
            for (j = 0; j < n; ++j) {
                if (verts.size() > 2) {
                    verts.add((Integer)verts.get(0));
                    verts.add((Integer)verts.get(verts.size() - 2));
                }
                if (i == 0 & lowercap) {
                    verts.add(v + 2 * j + 1);
                    continue;
                }
                verts.add(v + 2 * (n - j - 1));
            }
            verts.add((Integer)verts.get(0));
            verts.add((Integer)verts.get(verts.size() - 1));
            verts.add((Integer)verts.get(1));
            for (j = 0; j < verts.size() / 3; ++j) {
                buildingMesh.faces.add(new Face(new int[]{(Integer)verts.get(j * 3), (Integer)verts.get(j * 3 + 1), (Integer)verts.get(j * 3 + 2)}));
            }
        }
    }
}

