/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcerext.multipart;

import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcerext.model.ModelCluster;
import fabric.cn.zbx1425.sowcerext.multipart.MultipartUpdateProp;
import fabric.cn.zbx1425.sowcerext.multipart.PartBase;
import fabric.cn.zbx1425.sowcerext.reuse.DrawScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MultipartContainer {
    public List<PartBase> parts = new ArrayList<PartBase>();

    public void updateAndEnqueueAll(DrawScheduler scheduler, MultipartUpdateProp prop, Matrix4f basePose, int light) {
        for (PartBase part : this.parts) {
            part.update(prop);
        }
        for (PartBase part : this.parts) {
            ModelCluster model = part.getModel(prop);
            if (model == null) continue;
            Matrix4f partPose = basePose.copy();
            partPose.multiply(part.getTransform(prop));
            scheduler.enqueue(model, partPose, light);
        }
    }

    public void topologicalSort() {
        ArrayList<PartBase> result = new ArrayList<PartBase>(this.parts.size());
        HashMap<PartBase, Integer> inDeg = new HashMap<PartBase, Integer>();
        LinkedList<PartBase> queue = new LinkedList<PartBase>();
        for (PartBase part : this.parts) {
            int crntInDeg = part.parent == null ? 0 : 1;
            inDeg.put(part, crntInDeg);
            if (crntInDeg != 0) continue;
            queue.add(part);
        }
        while (!queue.isEmpty()) {
            PartBase partU = (PartBase)queue.poll();
            result.add(partU);
            for (PartBase partV : this.parts) {
                if (partV.parent != partU) continue;
                int crntInDeg = (Integer)inDeg.get(partV) - 1;
                inDeg.put(partV, crntInDeg);
                if (crntInDeg != 0) continue;
                queue.add(partV);
            }
        }
        if (result.size() != this.parts.size()) {
            throw new IllegalArgumentException("Multipart contains loop reference.");
        }
        this.parts = result;
    }
}

