/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcerext.multipart.animated;

import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.model.RawModel;
import fabric.cn.zbx1425.sowcerext.multipart.MultipartContainer;
import fabric.cn.zbx1425.sowcerext.multipart.animated.AnimatedPart;
import fabric.cn.zbx1425.sowcerext.multipart.animated.StaticPart;
import fabric.cn.zbx1425.sowcerext.multipart.animated.script.FunctionScript;
import fabric.cn.zbx1425.sowcerext.reuse.AtlasManager;
import fabric.cn.zbx1425.sowcerext.reuse.ModelManager;
import fabric.cn.zbx1425.sowcerext.util.Logging;
import fabric.cn.zbx1425.sowcerext.util.ResourceUtil;
import java.io.IOException;
import java.util.Locale;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class AnimatedLoader {
    private final MultipartContainer buildingContainer = new MultipartContainer();
    private final RawModel staticModel = new RawModel();

    public static MultipartContainer loadModel(class_3300 resourceManager, ModelManager modelManager, AtlasManager atlasManager, class_2960 objLocation) throws IOException {
        AnimatedLoader loader = new AnimatedLoader();
        loader.load(resourceManager, modelManager, atlasManager, objLocation, new Vector3f(0.0f, 0.0f, 0.0f));
        StaticPart staticPart = new StaticPart(loader.staticModel, modelManager);
        loader.buildingContainer.parts.add(staticPart);
        return loader.buildingContainer;
    }

    private void load(class_3300 resourceManager, ModelManager modelManager, AtlasManager atlasManager, class_2960 objLocation, Vector3f translation) throws IOException {
        String rawModelData = ResourceUtil.readResource(resourceManager, objLocation);
        String[] rawModelLines = rawModelData.split("[\\r\\n]+");
        String section = "";
        AnimatedPart buildingPart = new AnimatedPart();
        Vector3f includeTranslation = new Vector3f(0.0f, 0.0f, 0.0f);
        block57: for (String line : rawModelLines) {
            String trimLine;
            if (line.contains(";")) {
                line = line.split(";", 2)[0];
            }
            if (StringUtils.isEmpty((CharSequence)(trimLine = line.trim()))) continue;
            try {
                String value;
                String key;
                String[] tokens;
                if (trimLine.startsWith("[") && trimLine.endsWith("]")) {
                    if (section.equals("object")) {
                        if (buildingPart.isStatic()) {
                            buildingPart.bakeToStaticModel(this.staticModel, translation);
                        } else if (buildingPart.rawStates != null && buildingPart.rawStates.length > 0) {
                            buildingPart.uploadStates(modelManager, translation);
                            this.buildingContainer.parts.add(buildingPart);
                        }
                        buildingPart = new AnimatedPart();
                    }
                    if (!(section = trimLine.substring(1, trimLine.length() - 1).trim().replace(" ", "").toLowerCase()).equals("include")) continue;
                    includeTranslation = new Vector3f(0.0f, 0.0f, 0.0f);
                    continue;
                }
                if (section.equals("object")) {
                    if (!trimLine.contains("=") || (tokens = trimLine.split("=", 2)).length != 2) continue;
                    key = tokens[0].trim().toLowerCase();
                    value = tokens[1].trim().toLowerCase();
                    if (StringUtils.isEmpty((CharSequence)value)) continue;
                    switch (key) {
                        case "position": {
                            buildingPart.externTranslation = AnimatedLoader.parseVectorValue(value);
                            break;
                        }
                        case "states": {
                            String[] states = value.split(",");
                            buildingPart.rawStates = new RawModel[states.length];
                            for (int i = 0; i < states.length; ++i) {
                                String crntState = states[i].trim().toLowerCase(Locale.ROOT);
                                if (StringUtils.isEmpty((CharSequence)crntState)) continue;
                                class_2960 crntStateLocation = ResourceUtil.resolveRelativePath(objLocation, crntState, null);
                                String crntStatExt = FilenameUtils.getExtension((String)crntState);
                                if (crntStatExt.equals("obj") || crntStatExt.equals("csv") || crntStatExt.equals("nmb")) {
                                    buildingPart.rawStates[i] = modelManager.loadRawModel(resourceManager, crntStateLocation, atlasManager);
                                    continue;
                                }
                                Logging.LOGGER.warn("Unsupported model format in ANIMATED: " + crntState);
                            }
                            continue block57;
                        }
                        case "statefunction": {
                            buildingPart.stateFunction = new FunctionScript(value);
                            break;
                        }
                        case "translatexdirection": {
                            buildingPart.translateXDirection = AnimatedLoader.parseVectorValue(value);
                            break;
                        }
                        case "translateydirection": {
                            buildingPart.translateYDirection = AnimatedLoader.parseVectorValue(value);
                            break;
                        }
                        case "translatezdirection": {
                            buildingPart.translateZDirection = AnimatedLoader.parseVectorValue(value);
                            break;
                        }
                        case "translatexfunction": {
                            buildingPart.translateXFunction = new FunctionScript(value);
                            break;
                        }
                        case "translateyfunction": {
                            buildingPart.translateYFunction = new FunctionScript(value);
                            break;
                        }
                        case "translatezfunction": {
                            buildingPart.translateZFunction = new FunctionScript(value);
                            break;
                        }
                        case "rotatexdirection": {
                            buildingPart.rotateXDirection = AnimatedLoader.parseVectorValue(value);
                            break;
                        }
                        case "rotateydirection": {
                            buildingPart.rotateYDirection = AnimatedLoader.parseVectorValue(value);
                            break;
                        }
                        case "rotatezdirection": {
                            buildingPart.rotateZDirection = AnimatedLoader.parseVectorValue(value);
                            break;
                        }
                        case "rotatexfunction": {
                            buildingPart.rotateXFunction = new FunctionScript(value);
                            break;
                        }
                        case "rotateyfunction": {
                            buildingPart.rotateYFunction = new FunctionScript(value);
                            break;
                        }
                        case "rotatezfunction": {
                            buildingPart.rotateZFunction = new FunctionScript(value);
                            break;
                        }
                        case "rotatexdamping": 
                        case "rotateydamping": 
                        case "rotatezdamping": {
                            Logging.LOGGER.warn("ANIMATED command that isn't currently supported: " + key);
                            break;
                        }
                        case "textureshiftxdirection": 
                        case "textureshiftydirection": 
                        case "textureshiftxfunction": 
                        case "textureshiftyfunction": 
                        case "trackfollowerfunction": 
                        case "textureoverride": {
                            break;
                        }
                        case "refreshrate": {
                            buildingPart.refreshRateMillis = (int)(Float.parseFloat(value) * 1000.0f);
                            break;
                        }
                        case "billboard": {
                            buildingPart.billboard = Integer.parseInt(value) != 0;
                        }
                        default: {
                            Logging.LOGGER.warn("Unknown ANIMATED command in Object: " + tokens[0]);
                        }
                    }
                    continue;
                }
                if (section.equals("include")) {
                    if (trimLine.contains("=")) {
                        tokens = trimLine.split("=");
                        if (tokens.length != 2) continue;
                        key = tokens[0].trim().toLowerCase();
                        value = tokens[1].trim().toLowerCase().replace("\\", "/");
                        if (StringUtils.isEmpty((CharSequence)value)) continue;
                        switch (key) {
                            case "position": {
                                includeTranslation = AnimatedLoader.parseVectorValue(value);
                                break;
                            }
                            default: {
                                Logging.LOGGER.warn("Unknown ANIMATED command in Include: " + tokens[0]);
                                break;
                            }
                        }
                        continue;
                    }
                    class_2960 crntStateLocation = ResourceUtil.resolveRelativePath(objLocation, trimLine, null);
                    String crntStatExt = FilenameUtils.getExtension((String)trimLine);
                    if (crntStatExt.equals("obj") || crntStatExt.equals("csv") || crntStatExt.equals("nmb")) {
                        RawModel model = modelManager.loadRawModel(resourceManager, crntStateLocation, atlasManager).copy();
                        model.sourceLocation = null;
                        model.applyTranslation(translation.x() + includeTranslation.x(), translation.y() + includeTranslation.y(), translation.z() + includeTranslation.z());
                        this.staticModel.append(model);
                        continue;
                    }
                    if (crntStatExt.equals("animated")) {
                        this.load(resourceManager, modelManager, atlasManager, crntStateLocation, new Vector3f(translation.x() + includeTranslation.x(), translation.y() + includeTranslation.y(), translation.z() + includeTranslation.z()));
                        continue;
                    }
                    Logging.LOGGER.warn("Unsupported model format in ANIMATED: " + trimLine);
                    continue;
                }
                Logging.LOGGER.warn("Unsupported ANIMATED section: " + section);
            }
            catch (Exception ex) {
                Logging.LOGGER.error("Failed loading ANIMATED model " + objLocation + ", line \"" + line + "\": ", (Throwable)ex);
            }
        }
        if (section.equals("object")) {
            if (buildingPart.isStatic()) {
                buildingPart.bakeToStaticModel(this.staticModel, translation);
            } else if (buildingPart.rawStates != null && buildingPart.rawStates.length > 0) {
                buildingPart.uploadStates(modelManager, translation);
                this.buildingContainer.parts.add(buildingPart);
            }
        }
        this.staticModel.distinct();
    }

    private static Vector3f parseVectorValue(String value) {
        String[] tokens = value.split(",");
        if (tokens.length != 3) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return new Vector3f(Float.parseFloat(tokens[0].trim()), Float.parseFloat(tokens[1].trim()), Float.parseFloat(tokens[2].trim()));
    }
}

