/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcerext.multipart.animated;

import fabric.cn.zbx1425.sowcer.math.Matrix4f;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.model.ModelCluster;
import fabric.cn.zbx1425.sowcerext.model.RawModel;
import fabric.cn.zbx1425.sowcerext.multipart.MultipartUpdateProp;
import fabric.cn.zbx1425.sowcerext.multipart.PartBase;
import fabric.cn.zbx1425.sowcerext.multipart.animated.AnimatedPartStates;
import fabric.cn.zbx1425.sowcerext.multipart.animated.script.FunctionScript;
import fabric.cn.zbx1425.sowcerext.reuse.ModelManager;

public class AnimatedPart
extends PartBase {
    public RawModel[] rawStates;
    public Vector3f externTranslation = new Vector3f(0.0f, 0.0f, 0.0f);
    public ModelCluster[] uploadedStates;
    public int refreshRateMillis = 0;
    public boolean billboard = false;
    public FunctionScript stateFunction = FunctionScript.DEFAULT;
    public Vector3f translateXDirection = new Vector3f(1.0f, 0.0f, 0.0f);
    public Vector3f translateYDirection = new Vector3f(0.0f, 1.0f, 0.0f);
    public Vector3f translateZDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    public FunctionScript translateXFunction = FunctionScript.DEFAULT;
    public FunctionScript translateYFunction = FunctionScript.DEFAULT;
    public FunctionScript translateZFunction = FunctionScript.DEFAULT;
    public Vector3f rotateXDirection = new Vector3f(1.0f, 0.0f, 0.0f);
    public Vector3f rotateYDirection = new Vector3f(0.0f, 1.0f, 0.0f);
    public Vector3f rotateZDirection = new Vector3f(0.0f, 0.0f, 1.0f);
    public FunctionScript rotateXFunction = FunctionScript.DEFAULT;
    public FunctionScript rotateYFunction = FunctionScript.DEFAULT;
    public FunctionScript rotateZFunction = FunctionScript.DEFAULT;
    private final Long id = AnimatedPartStates.getNewPartId();

    @Override
    public void update(MultipartUpdateProp prop) {
        boolean shouldUpdate;
        int lastState = prop.animatedPartStates.partStates.getOrDefault(this.id, -1);
        Matrix4f lastTransform = prop.animatedPartStates.partTransforms.getOrDefault(this.id, null);
        Long lastUpdateTime = prop.animatedPartStates.partUpdateTimes.getOrDefault(this.id, 0L);
        boolean bl = shouldUpdate = lastTransform == null || this.refreshRateMillis <= 0 || System.currentTimeMillis() - lastUpdateTime >= (long)this.refreshRateMillis;
        if (shouldUpdate) {
            double elapsedTime = (double)(System.currentTimeMillis() - lastUpdateTime) / 1000.0;
            int state = (int)this.stateFunction.update(prop, elapsedTime, lastState);
            float translateX = this.translateXFunction.update(prop, elapsedTime, lastState);
            float translateY = this.translateYFunction.update(prop, elapsedTime, lastState);
            float translateZ = this.translateZFunction.update(prop, elapsedTime, lastState);
            float rotateX = this.rotateXFunction.update(prop, elapsedTime, lastState);
            float rotateY = this.rotateYFunction.update(prop, elapsedTime, lastState);
            float rotateZ = this.rotateZFunction.update(prop, elapsedTime, lastState);
            Matrix4f result = new Matrix4f();
            if (this.parent != null) {
                result.multiply(this.parent.getTransform(prop));
            }
            result.translate(-(this.translateXDirection.x() * translateX + this.translateYDirection.x() * translateY + this.translateZDirection.x() * translateZ + this.externTranslation.x()), this.translateXDirection.y() * translateX + this.translateYDirection.y() * translateY + this.translateZDirection.y() * translateZ + this.externTranslation.y(), this.translateXDirection.z() * translateX + this.translateYDirection.z() * translateY + this.translateZDirection.z() * translateZ + this.externTranslation.z());
            result.rotate(this.rotateXDirection, rotateX);
            result.rotate(this.rotateYDirection, -rotateY);
            result.rotate(this.rotateZDirection, -rotateZ);
            prop.animatedPartStates.partStates.put(this.id, state);
            prop.animatedPartStates.partTransforms.put(this.id, result);
            prop.animatedPartStates.partUpdateTimes.put(this.id, System.currentTimeMillis());
        }
    }

    @Override
    public ModelCluster getModel(MultipartUpdateProp prop) {
        int lastState = prop.animatedPartStates.partStates.getOrDefault(this.id, -1);
        if (lastState < 0 || lastState >= this.uploadedStates.length) {
            return null;
        }
        return this.uploadedStates[lastState];
    }

    @Override
    public Matrix4f getTransform(MultipartUpdateProp prop) {
        return prop.animatedPartStates.partTransforms.getOrDefault(this.id, null);
    }

    @Override
    public boolean isStatic() {
        return this.stateFunction.isStatic() && this.translateXFunction.isStatic() && this.translateYFunction.isStatic() && this.translateZFunction.isStatic() && this.rotateXFunction.isStatic() && this.rotateYFunction.isStatic() && this.rotateZFunction.isStatic();
    }

    public void uploadStates(ModelManager modelManager, Vector3f translation) {
        this.externTranslation.add(translation);
        if (this.rawStates == null || this.rawStates.length == 0) {
            return;
        }
        this.uploadedStates = new ModelCluster[this.rawStates.length];
        for (int i = 0; i < this.rawStates.length; ++i) {
            if (this.rawStates[i] == null) continue;
            this.uploadedStates[i] = modelManager.uploadVertArrays(this.rawStates[i]);
        }
    }

    public void bakeToStaticModel(RawModel staticModelRef, Vector3f translation) {
        this.externTranslation.add(translation);
        if (this.rawStates == null || this.rawStates.length == 0) {
            return;
        }
        MultipartUpdateProp prop = new MultipartUpdateProp();
        this.update(prop);
        int lastState = prop.animatedPartStates.partStates.getOrDefault(this.id, -1);
        if (lastState < 0 || lastState >= this.rawStates.length) {
            return;
        }
        RawModel state = this.rawStates[lastState];
        if (state == null) {
            return;
        }
        RawModel clonedState = state.copy();
        clonedState.sourceLocation = null;
        clonedState.applyMatrix(this.getTransform(prop));
        staticModelRef.append(clonedState);
    }
}

