/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcerext.multipart.animated.script;

import fabric.cn.zbx1425.sowcerext.multipart.MultipartUpdateProp;
import fabric.cn.zbx1425.sowcerext.multipart.animated.AnimatedPartStates;
import fabric.cn.zbx1425.sowcerext.multipart.animated.script.CSUtil;
import fabric.cn.zbx1425.sowcerext.multipart.animated.script.Executor;
import fabric.cn.zbx1425.sowcerext.multipart.animated.script.Instructions;
import fabric.cn.zbx1425.sowcerext.multipart.animated.script.Notation;
import fabric.cn.zbx1425.sowcerext.util.Logging;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public class FunctionScript {
    public static final FunctionScript DEFAULT = new FunctionScript("0");
    public long id;
    public Instructions[] InstructionSet;
    public double[] Stack;
    public double[] Constants;
    public double Maximum = Double.NaN;
    public double Minimum = Double.NaN;
    private boolean exceptionCaught;

    public boolean isStatic() {
        return this.ConstantResult();
    }

    public float update(MultipartUpdateProp prop, double elapsedTime, int currentState) {
        if (this.exceptionCaught) {
            return 0.0f;
        }
        double lastResult = prop.animatedPartStates.funcResults.getOrDefault(this.id, 0.0);
        try {
            lastResult = Executor.ExecuteFunctionScript(this, prop, elapsedTime, currentState, lastResult);
        }
        catch (Exception ex) {
            if (!this.exceptionCaught) {
                Logging.LOGGER.error("Failed evaluating OpenBVE function script:", (Throwable)ex);
                this.exceptionCaught = true;
            }
            lastResult = 0.0;
        }
        prop.animatedPartStates.funcResults.put(this.id, lastResult);
        if (!Double.isNaN(this.Minimum) & lastResult < this.Minimum) {
            return (float)this.Minimum;
        }
        if (!Double.isNaN(this.Maximum) & lastResult > this.Maximum) {
            return (float)this.Maximum;
        }
        return (float)lastResult;
    }

    public boolean ConstantResult() {
        if (this.InstructionSet.length == 1 && this.InstructionSet[0] == Instructions.SystemConstant) {
            return true;
        }
        for (int i = 0; i < this.InstructionSet.length; ++i) {
            if (this.InstructionSet[i].ordinal() < Instructions.LogicalXor.ordinal()) continue;
            return false;
        }
        return true;
    }

    public FunctionScript(String Expression) {
        this.id = AnimatedPartStates.getNewFuncId();
        boolean Infix = true;
        if (Infix) {
            Expression = Notation.GetFunctionNotationFromInfixNotation(Expression, true);
            Expression = Notation.GetPostfixNotationFromFunctionNotation(Expression);
        }
        Expression = Notation.GetOptimizedPostfixNotation(Expression);
        String[] Arguments2 = Expression.trim().split("\\s+");
        this.InstructionSet = new Instructions[16];
        int n = 0;
        this.Stack = new double[16];
        int m = 0;
        int s = 0;
        this.Constants = new double[16];
        int c = 0;
        block302: for (int i = 0; i < Arguments2.length; ++i) {
            double d;
            if (CSUtil.tryParseDouble(Arguments2[i])) {
                d = Double.parseDouble(Arguments2[i]);
                if (n >= this.InstructionSet.length) {
                    this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                }
                this.InstructionSet[n] = Instructions.SystemConstant;
                if (c >= this.Constants.length) {
                    this.Constants = Arrays.copyOf(this.Constants, this.Constants.length << 1);
                }
                this.Constants[c] = d;
                ++n;
                ++c;
                if (++s < m) continue;
                m = s;
                continue;
            }
            if (CSUtil.tryParseTime(Arguments2[i]) && this.InstructionSet[n - 1] == Instructions.TimeSecondsSinceMidnight) {
                d = Duration.parse(Arguments2[i]).getSeconds();
                if (c >= this.Constants.length) {
                    this.Constants = Arrays.copyOf(this.Constants, this.Constants.length << 1);
                }
                this.Constants[c] = d;
                ++n;
                ++c;
                if (++s < m) continue;
                m = s;
                continue;
            }
            if (Arguments2[i].indexOf(58) != -1) {
                throw new IllegalArgumentException("Invalid character encountered in variable " + Expression);
            }
            switch (Arguments2[i].toLowerCase(Locale.ROOT)) {
                case "halt": {
                    throw new IllegalArgumentException("The halt instruction was encountered in function script " + Expression);
                }
                case "value": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.SystemValue;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "delta": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.SystemDelta;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "~": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.StackCopy;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "<>": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.StackSwap;
                    ++n;
                    continue block302;
                }
                case "+": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathPlus;
                    ++n;
                    --s;
                    continue block302;
                }
                case "-": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathSubtract;
                    ++n;
                    --s;
                    continue block302;
                }
                case "minus": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathMinus;
                    ++n;
                    continue block302;
                }
                case "*": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathTimes;
                    ++n;
                    --s;
                    continue block302;
                }
                case "/": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathDivide;
                    ++n;
                    --s;
                    continue block302;
                }
                case "reciprocal": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathReciprocal;
                    ++n;
                    continue block302;
                }
                case "power": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathPower;
                    ++n;
                    --s;
                    continue block302;
                }
                case "++": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathIncrement;
                    ++n;
                    continue block302;
                }
                case "--": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathDecrement;
                    ++n;
                    continue block302;
                }
                case "fma": {
                    if (s < 3) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 3 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathFusedMultiplyAdd;
                    ++n;
                    s -= 2;
                    continue block302;
                }
                case "quotient": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathQuotient;
                    ++n;
                    --s;
                    continue block302;
                }
                case "mod": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathMod;
                    ++n;
                    --s;
                    continue block302;
                }
                case "random": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathRandom;
                    ++n;
                    --s;
                    continue block302;
                }
                case "randomint": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathRandomInt;
                    ++n;
                    --s;
                    continue block302;
                }
                case "floor": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathFloor;
                    ++n;
                    continue block302;
                }
                case "ceiling": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathCeiling;
                    ++n;
                    continue block302;
                }
                case "round": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathRound;
                    ++n;
                    continue block302;
                }
                case "min": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathMin;
                    ++n;
                    --s;
                    continue block302;
                }
                case "max": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathMax;
                    ++n;
                    --s;
                    continue block302;
                }
                case "abs": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathAbs;
                    ++n;
                    continue block302;
                }
                case "sign": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathSign;
                    ++n;
                    continue block302;
                }
                case "exp": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathExp;
                    ++n;
                    continue block302;
                }
                case "log": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathLog;
                    ++n;
                    continue block302;
                }
                case "sqrt": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathSqrt;
                    ++n;
                    continue block302;
                }
                case "sin": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathSin;
                    ++n;
                    continue block302;
                }
                case "cos": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathCos;
                    ++n;
                    continue block302;
                }
                case "tan": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathTan;
                    ++n;
                    continue block302;
                }
                case "arctan": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathArcTan;
                    ++n;
                    continue block302;
                }
                case "pi": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MathPi;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "==": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CompareEqual;
                    ++n;
                    --s;
                    continue block302;
                }
                case "!=": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CompareUnequal;
                    ++n;
                    --s;
                    continue block302;
                }
                case "<": {
                    int nCars;
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (Objects.equals(Arguments2[i - 2].toLowerCase(Locale.ROOT), "cars") && Math.abs(nCars = Integer.parseInt(Arguments2[i - 1])) != nCars) {
                        throw new IllegalArgumentException("Cannot test against less than zero cars in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CompareLess;
                    ++n;
                    --s;
                    continue block302;
                }
                case ">": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CompareGreater;
                    ++n;
                    --s;
                    continue block302;
                }
                case "<=": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CompareLessEqual;
                    ++n;
                    --s;
                    continue block302;
                }
                case ">=": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CompareGreaterEqual;
                    ++n;
                    --s;
                    continue block302;
                }
                case "?": {
                    if (s < 3) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 3 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CompareConditional;
                    ++n;
                    s -= 2;
                    continue block302;
                }
                case "!": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LogicalNot;
                    ++n;
                    continue block302;
                }
                case "&": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LogicalAnd;
                    ++n;
                    --s;
                    continue block302;
                }
                case "|": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LogicalOr;
                    ++n;
                    --s;
                    continue block302;
                }
                case "!&": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LogicalNand;
                    ++n;
                    --s;
                    continue block302;
                }
                case "!|": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LogicalNor;
                    ++n;
                    --s;
                    continue block302;
                }
                case "^": {
                    if (s < 2) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 2 arguments on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LogicalXor;
                    ++n;
                    --s;
                    continue block302;
                }
                case "time": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TimeSecondsSinceMidnight;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "hour": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TimeHourDigit;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "minute": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TimeMinuteDigit;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "second": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TimeSecondDigit;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "cameradistance": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CameraDistance;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "cameraxdistance": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CameraXDistance;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "cameraydistance": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CameraYDistance;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "camerazdistance": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CameraZDistance;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "cameramode": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CameraView;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "playertrain": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.PlayerTrain;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "cars": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainCars;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "destination": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainDestination;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "speed": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainSpeed;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "speedindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainSpeedOfCar;
                    ++n;
                    continue block302;
                }
                case "speedometer": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainSpeedometer;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "speedometerindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainSpeedometerOfCar;
                    ++n;
                    continue block302;
                }
                case "acceleration": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainAcceleration;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "accelerationindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainAccelerationOfCar;
                    ++n;
                    continue block302;
                }
                case "accelerationmotor": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainAccelerationMotor;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "accelerationmotorindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainAccelerationMotorOfCar;
                    ++n;
                    continue block302;
                }
                case "distance": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainDistance;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "distanceindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainDistanceToCar;
                    ++n;
                    continue block302;
                }
                case "trackdistance": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainTrackDistance;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "frontaxlecurveradius": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.FrontAxleCurveRadius;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "frontaxlecurveradiusindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.FrontAxleCurveRadiusOfCar;
                    ++n;
                    continue block302;
                }
                case "rearaxlecurveradius": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.RearAxleCurveRadius;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "rearaxlecurveradiusindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.RearAxleCurveRadiusOfCar;
                    ++n;
                    continue block302;
                }
                case "curveradius": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CurveRadius;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "curveradiusindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CurveRadiusOfCar;
                    ++n;
                    continue block302;
                }
                case "curvecant": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CurveCant;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "curvecantindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CurveCantOfCar;
                    ++n;
                    continue block302;
                }
                case "pitch": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.Pitch;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "pitchindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.PitchOfCar;
                    ++n;
                    continue block302;
                }
                case "odometer": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.Odometer;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "odometerindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.OdometerOfCar;
                    ++n;
                    continue block302;
                }
                case "trackdistanceindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainTrackDistanceToCar;
                    ++n;
                    continue block302;
                }
                case "doors": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.Doors;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "doorsindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.DoorsIndex;
                    ++n;
                    continue block302;
                }
                case "leftdoors": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LeftDoors;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "leftdoorsindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LeftDoorsIndex;
                    ++n;
                    continue block302;
                }
                case "rightdoors": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.RightDoors;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "rightdoorsindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.RightDoorsIndex;
                    ++n;
                    continue block302;
                }
                case "leftdoorstarget": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LeftDoorsTarget;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "leftdoorstargetindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LeftDoorsTargetIndex;
                    ++n;
                    continue block302;
                }
                case "rightdoorstarget": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.RightDoorsTarget;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "rightdoorstargetindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.RightDoorsTargetIndex;
                    ++n;
                    continue block302;
                }
                case "leftdoorbutton": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LeftDoorButton;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "rightdoorbutton": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.RightDoorButton;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "pilotlamp": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.PilotLamp;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "passalarm": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.PassAlarm;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "stationadjustalarm": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.StationAdjustAlarm;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "reversernotch": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.ReverserNotch;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "powernotch": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.PowerNotch;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "powernotches": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.PowerNotches;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "brakenotch": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeNotch;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "locobrakenotch": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.LocoBrakeNotch;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "brakenotches": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeNotches;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "brakenotchlinear": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeNotchLinear;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "brakenotcheslinear": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeNotchesLinear;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "emergencybrake": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.EmergencyBrake;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "horn": 
                case "klaxon": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.Klaxon;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "primaryhorn": 
                case "primaryklaxon": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.PrimaryKlaxon;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "secondaryhorn": 
                case "secondaryklaxon": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.SecondaryKlaxon;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "musichorn": 
                case "musicklaxon": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.MusicKlaxon;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "hasairbrake": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.HasAirBrake;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "holdbrake": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.HoldBrake;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "hasholdbrake": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.HasHoldBrake;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "constspeed": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.ConstSpeed;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "hasconstspeed": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.HasConstSpeed;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "mainreservoir": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeMainReservoir;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "mainreservoirindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeMainReservoirOfCar;
                    ++n;
                    continue block302;
                }
                case "equalizingreservoir": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeEqualizingReservoir;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "equalizingreservoirindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeEqualizingReservoirOfCar;
                    ++n;
                    continue block302;
                }
                case "brakepipe": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeBrakePipe;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "brakepipeindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeBrakePipeOfCar;
                    ++n;
                    continue block302;
                }
                case "brakecylinder": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeBrakeCylinder;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "brakecylinderindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeBrakeCylinderOfCar;
                    ++n;
                    continue block302;
                }
                case "straightairpipe": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeStraightAirPipe;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "straightairpipeindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeStraightAirPipeOfCar;
                    ++n;
                    continue block302;
                }
                case "hasplugin": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.SafetyPluginAvailable;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "pluginstate": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.SafetyPluginState;
                    ++n;
                    continue block302;
                }
                case "timetable": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TimetableVisible;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "panel2timetable": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.Panel2Timetable;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "distancenextstation": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.DistanceNextStation;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "stopsnextstation": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.StopsNextStation;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "distancestationindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.DistanceStation;
                    ++n;
                    continue block302;
                }
                case "stopsstationindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.StopsStation;
                    ++n;
                    continue block302;
                }
                case "terminalstation": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TerminalStation;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "nextstation": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.NextStation;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "nextstationstop": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.NextStationStop;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "routelimit": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.RouteLimit;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "section": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.SectionAspectNumber;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "currentstate": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.CurrentObjectState;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "raindrop": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.RainDrop;
                    ++n;
                    continue block302;
                }
                case "snowflake": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.SnowFlake;
                    ++n;
                    continue block302;
                }
                case "wiperposition": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.WiperPosition;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "brightnessindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrightnessOfCar;
                    ++n;
                    continue block302;
                }
                case "carnumber": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.TrainCarNumber;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "wheelradius": {
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeBrakePipe;
                    ++n;
                    if (++s < m) continue block302;
                    m = s;
                    continue block302;
                }
                case "wheelradiusindex": {
                    if (s < 1) {
                        throw new IllegalArgumentException(Arguments2[i] + " requires at least 1 argument on the stack in function script " + Expression);
                    }
                    if (n >= this.InstructionSet.length) {
                        this.InstructionSet = Arrays.copyOf(this.InstructionSet, this.InstructionSet.length << 1);
                    }
                    this.InstructionSet[n] = Instructions.BrakeBrakePipeOfCar;
                    ++n;
                    continue block302;
                }
                default: {
                    throw new IllegalArgumentException("Unknown command " + Arguments2[i] + " encountered in function script " + Expression);
                }
            }
        }
        if (s != 1) {
            throw new IllegalArgumentException("There must be exactly one argument left on the stack at the end in function script " + Expression);
        }
        this.InstructionSet = Arrays.copyOf(this.InstructionSet, n);
        this.Stack = Arrays.copyOf(this.Stack, m);
        this.Constants = Arrays.copyOf(this.Constants, c);
    }
}

