/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcerext.multipart.mi;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.sowcer.math.Vector3f;
import fabric.cn.zbx1425.sowcerext.model.RawModel;
import fabric.cn.zbx1425.sowcerext.multipart.MultipartContainer;
import fabric.cn.zbx1425.sowcerext.multipart.PartBase;
import fabric.cn.zbx1425.sowcerext.multipart.mi.MiPart;
import fabric.cn.zbx1425.sowcerext.reuse.AtlasManager;
import fabric.cn.zbx1425.sowcerext.reuse.ModelManager;
import fabric.cn.zbx1425.sowcerext.util.ResourceUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.apache.commons.lang3.StringUtils;

public class MiLoader {
    public static MultipartContainer loadModel(class_3300 resourceManager, ModelManager modelManager, AtlasManager atlasManager, class_2960 objLocation) throws IOException {
        MiPart miPart;
        JsonObject partObj;
        JsonObject configData = Main.JSON_PARSER.parse(ResourceUtil.readResource(resourceManager, objLocation)).getAsJsonObject();
        JsonObject miData = Main.JSON_PARSER.parse(ResourceUtil.readResource(resourceManager, ResourceUtil.resolveRelativePath(objLocation, configData.get("miProject").getAsString(), ""))).getAsJsonObject();
        float timelineFps = configData.get("timelineFps").getAsFloat();
        HashMap<String, MiPart> idToParts = new HashMap<String, MiPart>();
        HashMap<String, MiPart> nameToParts = new HashMap<String, MiPart>();
        for (JsonElement part : miData.get("timelines").getAsJsonArray()) {
            partObj = part.getAsJsonObject();
            miPart = new MiPart();
            for (Map.Entry keyFrame : partObj.get("keyframes").getAsJsonObject().entrySet()) {
                float time = Float.parseFloat((String)keyFrame.getKey()) / timelineFps;
                JsonObject keyFrameObj = ((JsonElement)keyFrame.getValue()).getAsJsonObject();
                miPart.translateX.spline.put(Float.valueOf(time), Float.valueOf(MiLoader.frameValue(keyFrameObj, "POS_X") / 16.0f));
                miPart.translateZ.spline.put(Float.valueOf(time), Float.valueOf(MiLoader.frameValue(keyFrameObj, "POS_Y") / 16.0f));
                miPart.translateY.spline.put(Float.valueOf(time), Float.valueOf(MiLoader.frameValue(keyFrameObj, "POS_Z") / 16.0f));
                float deg2Rad = (float)Math.PI / 180;
                miPart.rotateX.spline.put(Float.valueOf(time), Float.valueOf(MiLoader.frameValue(keyFrameObj, "ROT_X") * ((float)Math.PI / 180)));
                miPart.rotateZ.spline.put(Float.valueOf(time), Float.valueOf(MiLoader.frameValue(keyFrameObj, "ROT_Y") * ((float)Math.PI / 180)));
                miPart.rotateY.spline.put(Float.valueOf(time), Float.valueOf(MiLoader.frameValue(keyFrameObj, "ROT_Z") * ((float)Math.PI / 180)));
            }
            miPart.name = partObj.get("name").getAsString();
            idToParts.put(partObj.get("id").getAsString(), miPart);
        }
        for (JsonElement part : miData.get("timelines").getAsJsonArray()) {
            partObj = part.getAsJsonObject();
            miPart = (MiPart)idToParts.get(partObj.get("id").getAsString());
            String parent = partObj.get("parent").getAsString();
            if (StringUtils.isEmpty((CharSequence)parent) || parent.equals("root")) continue;
            miPart.parent = (PartBase)idToParts.get(parent);
        }
        MultipartContainer container = new MultipartContainer();
        container.parts.addAll(idToParts.values());
        container.topologicalSort();
        for (PartBase part : container.parts) {
            RawModel model;
            Vector3f translation;
            miPart = (MiPart)part;
            if (StringUtils.isEmpty((CharSequence)miPart.name)) continue;
            if (miPart.parent != null && !StringUtils.isEmpty((CharSequence)((MiPart)miPart.parent).name)) {
                miPart.name = ((MiPart)miPart.parent).name + "." + miPart.name;
            }
            nameToParts.put(miPart.name, miPart);
            if (!configData.get("models").getAsJsonObject().has(miPart.name)) continue;
            JsonObject modelObj = configData.get("models").getAsJsonObject().get(miPart.name).getAsJsonObject();
            Vector3f offset = modelObj.has("offset") ? MiLoader.parseVectorValue(modelObj.get("offset").getAsString()) : new Vector3f(0.0f, 0.0f, 0.0f);
            Vector3f vector3f = translation = modelObj.has("position") ? MiLoader.parseVectorValue(modelObj.get("position").getAsString()) : new Vector3f(0.0f, 0.0f, 0.0f);
            if (modelObj.has("model")) {
                model = modelManager.loadRawModel(resourceManager, ResourceUtil.resolveRelativePath(objLocation, modelObj.get("model").getAsString(), ""), atlasManager);
                Vector3f pivot = modelObj.has("pivot") ? MiLoader.parseVectorValue(modelObj.get("pivot").getAsString()) : new Vector3f(0.0f, 0.0f, 0.0f);
                model.applyTranslation(-pivot.x(), -pivot.y(), -pivot.z());
                offset.add(pivot);
            } else {
                model = null;
            }
            miPart.setModel(model, modelManager);
            miPart.internalOffset = offset;
            miPart.externalOffset = translation;
        }
        for (JsonElement copy : configData.get("copyKeyframes").getAsJsonArray()) {
            JsonObject copyObj = copy.getAsJsonObject();
            Vector3f srcSpan = MiLoader.parseVectorValue(copyObj.get("src").getAsString());
            float destBegin = copyObj.get("dest").getAsFloat();
            Vector3f mirror = MiLoader.parseVectorValue(copyObj.get("mirror").getAsString());
            boolean mirrorX = mirror.x() != 0.0f;
            JsonObject modelReplace = copyObj.get("modelReplace").getAsJsonObject();
            for (Map.Entry entry : idToParts.entrySet()) {
                MiPart srcPart = (MiPart)entry.getValue();
                MiPart destPart = modelReplace.has(srcPart.name) ? (MiPart)nameToParts.get(modelReplace.get(srcPart.name).getAsString()) : srcPart;
                MiLoader.copyKeyFrames(srcPart.translateX, destPart.translateX, srcSpan, destBegin, mirrorX ? -1.0f : 1.0f, 0.0f);
                MiLoader.copyKeyFrames(srcPart.translateY, destPart.translateY, srcSpan, destBegin, 1.0f, 0.0f);
                MiLoader.copyKeyFrames(srcPart.translateZ, destPart.translateZ, srcSpan, destBegin, 1.0f, 0.0f);
                MiLoader.copyKeyFrames(srcPart.rotateX, destPart.rotateX, srcSpan, destBegin, 1.0f, 0.0f);
                MiLoader.copyKeyFrames(srcPart.rotateY, destPart.rotateY, srcSpan, destBegin, mirrorX ? -1.0f : 1.0f, 0.0f);
                MiLoader.copyKeyFrames(srcPart.rotateZ, destPart.rotateZ, srcSpan, destBegin, mirrorX ? -1.0f : 1.0f, 0.0f);
            }
        }
        return container;
    }

    private static Vector3f parseVectorValue(String value) {
        String[] tokens = value.split(",");
        return new Vector3f(tokens.length >= 1 ? Float.parseFloat(tokens[0].trim()) : 0.0f, tokens.length >= 2 ? Float.parseFloat(tokens[1].trim()) : 0.0f, tokens.length >= 3 ? Float.parseFloat(tokens[2].trim()) : 0.0f);
    }

    private static float frameValue(JsonObject keyFrameObj, String element) {
        return keyFrameObj.has(element) ? keyFrameObj.get(element).getAsFloat() : 0.0f;
    }

    private static void copyKeyFrames(MiPart.FloatSpline srcSpline, MiPart.FloatSpline destSpline, Vector3f srcSpan, float destBegin, float mul, float add) {
        HashMap<Float, Float> tempMap = new HashMap<Float, Float>();
        for (Map.Entry<Float, Float> entry : srcSpline.spline.entrySet()) {
            if (entry.getKey().floatValue() < srcSpan.x()) continue;
            if (entry.getKey().floatValue() > srcSpan.y()) break;
            tempMap.put(Float.valueOf(entry.getKey().floatValue() - srcSpan.x() + destBegin), Float.valueOf(entry.getValue().floatValue() * mul + add));
        }
        destSpline.spline.putAll(tempMap);
    }
}

