/*
 * Decompiled with CFR 0.152.
 */
package fabric.cn.zbx1425.sowcerext.reuse;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fabric.cn.zbx1425.mtrsteamloco.Main;
import fabric.cn.zbx1425.sowcerext.model.RawMesh;
import fabric.cn.zbx1425.sowcerext.reuse.AtlasSprite;
import fabric.cn.zbx1425.sowcerext.util.ResourceUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class AtlasManager {
    public HashMap<class_2960, AtlasSprite> sprites = new HashMap();
    public HashSet<class_2960> noAtlasList = new HashSet();

    public void load(class_3300 resourceManager, class_2960 atlasConf) throws IOException {
        JsonObject atlasConfObj = Main.JSON_PARSER.parse(ResourceUtil.readResource(resourceManager, atlasConf)).getAsJsonObject();
        String basePath = atlasConfObj.get("basePath").getAsString();
        for (JsonElement sheetObj : atlasConfObj.get("sheets").getAsJsonArray()) {
            class_2960 sheetConf = ResourceUtil.resolveRelativePath(atlasConf, sheetObj.getAsString(), ".json");
            class_2960 sheetTexture = ResourceUtil.resolveRelativePath(atlasConf, sheetObj.getAsString(), ".png");
            JsonObject sheetConfObj = Main.JSON_PARSER.parse(ResourceUtil.readResource(resourceManager, sheetConf)).getAsJsonObject();
            int sheetWidth = sheetConfObj.get("meta").getAsJsonObject().get("size").getAsJsonObject().get("w").getAsInt();
            int sheetHeight = sheetConfObj.get("meta").getAsJsonObject().get("size").getAsJsonObject().get("h").getAsInt();
            for (Map.Entry entry : sheetConfObj.get("frames").getAsJsonObject().entrySet()) {
                class_2960 texture = ResourceUtil.resolveRelativePath(sheetConf, basePath + (String)entry.getKey(), ".png");
                JsonObject spriteObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                this.sprites.put(texture, new AtlasSprite(sheetTexture, sheetWidth, sheetHeight, spriteObj.get("frame").getAsJsonObject().get("x").getAsInt(), spriteObj.get("frame").getAsJsonObject().get("y").getAsInt(), spriteObj.get("frame").getAsJsonObject().get("w").getAsInt(), spriteObj.get("frame").getAsJsonObject().get("h").getAsInt(), spriteObj.get("spriteSourceSize").getAsJsonObject().get("x").getAsInt(), spriteObj.get("spriteSourceSize").getAsJsonObject().get("y").getAsInt(), spriteObj.get("spriteSourceSize").getAsJsonObject().get("w").getAsInt(), spriteObj.get("spriteSourceSize").getAsJsonObject().get("h").getAsInt(), spriteObj.get("sourceSize").getAsJsonObject().get("w").getAsInt(), spriteObj.get("sourceSize").getAsJsonObject().get("h").getAsInt(), spriteObj.get("rotated").getAsBoolean()));
            }
        }
        for (JsonElement noAtlasObj : atlasConfObj.get("noAtlas").getAsJsonArray()) {
            class_2960 noAtlasTexture = ResourceUtil.resolveRelativePath(atlasConf, basePath + noAtlasObj.getAsString(), ".png");
            this.noAtlasList.add(noAtlasTexture);
        }
    }

    public void applyToMesh(RawMesh mesh) {
        if (mesh.materialProp.texture == null || this.noAtlasList.contains(mesh.materialProp.texture)) {
            return;
        }
        AtlasSprite sprite = this.sprites.getOrDefault(mesh.materialProp.texture, null);
        if (sprite != null) {
            sprite.applyToMesh(mesh);
        }
    }

    public void clear() {
        this.sprites.clear();
    }
}

