/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco;

import forge.cn.zbx1425.mtrsteamloco.Main;
import forge.cn.zbx1425.mtrsteamloco.MainClient;
import forge.cn.zbx1425.mtrsteamloco.data.EyeCandyProperties;
import forge.cn.zbx1425.mtrsteamloco.data.EyeCandyRegistry;
import forge.cn.zbx1425.mtrsteamloco.render.integration.TrainModelCapture;
import forge.cn.zbx1425.sowcerext.model.ModelCluster;
import forge.cn.zbx1425.sowcerext.model.RawModel;
import forge.cn.zbx1425.sowcerext.model.loader.NmbModelLoader;
import forge.cn.zbx1425.sowcerext.model.loader.ObjModelLoader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import mtr.client.TrainClientRegistry;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelSimpleTrainBase;
import mtr.render.JonModelTrainRenderer;
import mtr.render.TrainRendererBase;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FilenameUtils;

public class Debug {
    public static void saveAllBuiltinModels(Path outputDir) {
        TrainClientRegistry.forEach((TransportMode)TransportMode.TRAIN, (trainId, trainProperties) -> {
            block12: {
                TrainRendererBase patt1254$temp = trainProperties.renderer;
                if (patt1254$temp instanceof JonModelTrainRenderer) {
                    JonModelTrainRenderer renderer = (JonModelTrainRenderer)patt1254$temp;
                    if (renderer.model != null && renderer.textureId != null && renderer.model instanceof ModelSimpleTrainBase) {
                        try {
                            List resources;
                            String textureName = FilenameUtils.getBaseName((String)renderer.textureId);
                            TrainModelCapture.CaptureResult result = TrainModelCapture.captureModels(renderer.model, new ResourceLocation(renderer.textureId + ".png"));
                            result.getNamedModels().values().forEach(RawModel::distinct);
                            ObjModelLoader.saveModels(result.getNamedModels(), outputDir.resolve(trainId + ".obj"), outputDir.resolve(textureName + ".mtl"), false);
                            if (Files.exists(outputDir.resolve(textureName + ".png"), new LinkOption[0]) || (resources = UtilitiesClient.getResources((ResourceManager)Minecraft.m_91087_().m_91098_(), (ResourceLocation)new ResourceLocation(renderer.textureId + ".png"))).isEmpty()) break block12;
                            try (InputStream is = Utilities.getInputStream((Resource)((Resource)resources.get(0)));){
                                Files.copy(is, outputDir.resolve(textureName + ".png"), new CopyOption[0]);
                            }
                            catch (IOException ex) {
                                Main.LOGGER.warn("Failed to save texture for " + trainId + ": ", (Throwable)ex);
                            }
                        }
                        catch (IOException ex) {
                            Main.LOGGER.warn("Failed to save model for " + trainId, (Throwable)ex);
                        }
                    }
                }
            }
        });
    }

    public static void saveAllLoadedModels(Path outputDir) {
        for (Map.Entry<ResourceLocation, RawModel> pair : MainClient.modelManager.loadedRawModels.entrySet()) {
            Path path = Paths.get(outputDir.toString(), pair.getKey().m_135827_(), pair.getKey().m_135815_());
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                FileOutputStream fos = new FileOutputStream(FilenameUtils.removeExtension((String)path.toString()) + ".nmb");
                NmbModelLoader.serializeModel(pair.getValue(), fos, false);
                fos.close();
            }
            catch (IOException e) {
                Main.LOGGER.error("Failed exporting models:", (Throwable)e);
            }
        }
    }

    public static void registerAllModelsAsEyeCandy() {
        for (Map.Entry<ResourceLocation, ModelCluster> entry : MainClient.modelManager.uploadedVertArrays.entrySet()) {
            String key = FilenameUtils.getBaseName((String)entry.getKey().m_135815_());
            EyeCandyRegistry.register(key, new EyeCandyProperties((Component)Text.literal((String)key), entry.getValue()));
        }
    }
}

