/*
 * Decompiled with CFR 0.152.
 */
package forge.cn.zbx1425.mtrsteamloco;

import com.google.gson.JsonParser;
import forge.cn.zbx1425.mtrsteamloco.BuildConfig;
import forge.cn.zbx1425.mtrsteamloco.RegistriesWrapper;
import forge.cn.zbx1425.mtrsteamloco.block.BlockDepartureBell;
import forge.cn.zbx1425.mtrsteamloco.block.BlockEyeCandy;
import forge.cn.zbx1425.mtrsteamloco.network.PacketUpdateBlockEntity;
import forge.cn.zbx1425.mtrsteamloco.network.PacketUpdateHoldingItem;
import forge.cn.zbx1425.mtrsteamloco.network.PacketUpdateRail;
import forge.cn.zbx1425.mtrsteamloco.network.PacketVersionCheck;
import java.net.URISyntaxException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import mtr.CreativeModeTabs;
import mtr.Registry;
import mtr.RegistryObject;
import mtr.item.ItemBridgeCreator;
import mtr.item.ItemWithCreativeTabBase;
import mtr.mappings.RegistryUtilities;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static final String MOD_ID = "mtrsteamloco";
    public static final Logger LOGGER;
    public static final JsonParser JSON_PARSER;
    public static final boolean enableRegistry;
    public static final RegistryObject<Block> BLOCK_DEPARTURE_BELL;
    public static final RegistryObject<Block> BLOCK_EYE_CANDY;
    public static final RegistryObject<BlockEntityType<BlockEyeCandy.BlockEntityEyeCandy>> BLOCK_ENTITY_TYPE_EYE_CANDY;
    public static final RegistryObject<ItemWithCreativeTabBase> BRIDGE_CREATOR_1;
    public static final SoundEvent SOUND_EVENT_BELL;
    public static SimpleParticleType PARTICLE_STEAM_SMOKE;

    public static void init(RegistriesWrapper registries) {
        LOGGER.info("MTR-NTE 0.5.1+1.19.4 built at " + DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault()).format(BuildConfig.BUILD_TIME));
        if (enableRegistry) {
            registries.registerBlockAndItem("departure_bell", BLOCK_DEPARTURE_BELL, CreativeModeTabs.RAILWAY_FACILITIES);
            registries.registerBlockAndItem("eye_candy", BLOCK_EYE_CANDY, CreativeModeTabs.STATION_BUILDING_BLOCKS);
            registries.registerBlockEntityType("eye_candy", BLOCK_ENTITY_TYPE_EYE_CANDY);
            registries.registerItem("bridge_creator_1", BRIDGE_CREATOR_1);
            registries.registerSoundEvent("bell", SOUND_EVENT_BELL);
            PARTICLE_STEAM_SMOKE = registries.createParticleType(true);
            registries.registerParticleType("steam_smoke", (ParticleType<?>)PARTICLE_STEAM_SMOKE);
            Registry.registerNetworkReceiver((ResourceLocation)PacketUpdateBlockEntity.PACKET_UPDATE_BLOCK_ENTITY, PacketUpdateBlockEntity::receiveUpdateC2S);
            Registry.registerNetworkReceiver((ResourceLocation)PacketUpdateRail.PACKET_UPDATE_RAIL, PacketUpdateRail::receiveUpdateC2S);
            Registry.registerNetworkReceiver((ResourceLocation)PacketUpdateHoldingItem.PACKET_UPDATE_HOLDING_ITEM, PacketUpdateHoldingItem::receiveUpdateC2S);
            Registry.registerPlayerJoinEvent(PacketVersionCheck::sendVersionCheckS2C);
        }
    }

    static {
        boolean enableRegistry1;
        LOGGER = LoggerFactory.getLogger((String)"MTR-NTE");
        JSON_PARSER = new JsonParser();
        try {
            String jarPath = Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().toLowerCase(Locale.ROOT);
            enableRegistry1 = !jarPath.endsWith("-client.jar");
        }
        catch (URISyntaxException ignored) {
            enableRegistry1 = true;
        }
        enableRegistry = enableRegistry1;
        BLOCK_DEPARTURE_BELL = new RegistryObject(BlockDepartureBell::new);
        BLOCK_EYE_CANDY = new RegistryObject(BlockEyeCandy::new);
        BLOCK_ENTITY_TYPE_EYE_CANDY = new RegistryObject(() -> RegistryUtilities.getBlockEntityType(BlockEyeCandy.BlockEntityEyeCandy::new, (Block)((Block)BLOCK_EYE_CANDY.get())));
        BRIDGE_CREATOR_1 = new RegistryObject(() -> new ItemBridgeCreator(1));
        SOUND_EVENT_BELL = RegistryUtilities.createSoundEvent((ResourceLocation)new ResourceLocation("mtrsteamloco:bell"));
    }

    @FunctionalInterface
    public static interface RegisterBlockItem {
        public void accept(String var1, RegistryObject<Block> var2, CreativeModeTabs.Wrapper var3);
    }
}

